/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.util.Consumer;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphImpl;
import com.intellij.vcs.log.graph.utils.DfsUtil;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.UnsignedBitSet;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReachableNodes {
    @NotNull
    private final LiteLinearGraph myGraph;
    @NotNull
    private final DfsUtil myDfsUtil;
    @NotNull
    private final Flags myTempFlags;

    public ReachableNodes(@NotNull LiteLinearGraph graph) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/impl/facade/ReachableNodes", "<init>"));
        }
        this.myDfsUtil = new DfsUtil();
        this.myGraph = graph;
        this.myTempFlags = new BitSetFlags(graph.nodesCount());
    }

    @NotNull
    public static UnsignedBitSet getReachableNodes(@NotNull PermanentLinearGraphImpl permanentGraph, @Nullable Set<Integer> headNodeIndexes) {
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraph", "com/intellij/vcs/log/graph/impl/facade/ReachableNodes", "getReachableNodes"));
        }
        if (headNodeIndexes == null) {
            UnsignedBitSet nodesVisibility = new UnsignedBitSet();
            nodesVisibility.set(0, permanentGraph.nodesCount() - 1, true);
            UnsignedBitSet unsignedBitSet = nodesVisibility;
            if (unsignedBitSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/ReachableNodes", "getReachableNodes"));
            }
            return unsignedBitSet;
        }
        assert (!headNodeIndexes.isEmpty());
        final UnsignedBitSet result = new UnsignedBitSet();
        ReachableNodes getter = new ReachableNodes(LinearGraphUtils.asLiteLinearGraph(permanentGraph));
        getter.walk(headNodeIndexes, new Consumer<Integer>(){

            public void consume(Integer node) {
                result.set(node, true);
            }
        });
        UnsignedBitSet unsignedBitSet = result;
        if (unsignedBitSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/ReachableNodes", "getReachableNodes"));
        }
        return unsignedBitSet;
    }

    public Set<Integer> getContainingBranches(int nodeIndex, final @NotNull Collection<Integer> branchNodeIndexes) {
        if (branchNodeIndexes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchNodeIndexes", "com/intellij/vcs/log/graph/impl/facade/ReachableNodes", "getContainingBranches"));
        }
        final HashSet<Integer> result = new HashSet<Integer>();
        this.walk(Collections.singletonList(nodeIndex), false, new Consumer<Integer>(){

            public void consume(Integer integer) {
                if (branchNodeIndexes.contains(integer)) {
                    result.add(integer);
                }
            }
        });
        return result;
    }

    public void walk(@NotNull Collection<Integer> headIds, @NotNull Consumer<Integer> consumer) {
        if (headIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headIds", "com/intellij/vcs/log/graph/impl/facade/ReachableNodes", "walk"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/graph/impl/facade/ReachableNodes", "walk"));
        }
        this.walk(headIds, true, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void walk(@NotNull Collection<Integer> startNodes, final boolean goDown, final @NotNull Consumer<Integer> consumer) {
        if (startNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startNodes", "com/intellij/vcs/log/graph/impl/facade/ReachableNodes", "walk"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/graph/impl/facade/ReachableNodes", "walk"));
        }
        Flags flags = this.myTempFlags;
        synchronized (flags) {
            this.myTempFlags.setAll(false);
            for (int start : startNodes) {
                if (start < 0 || this.myTempFlags.get(start)) continue;
                this.myTempFlags.set(start, true);
                consumer.consume((Object)start);
                this.myDfsUtil.nodeDfsIterator(start, new DfsUtil.NextNode(){

                    @Override
                    public int fun(int currentNode) {
                        for (int downNode : ReachableNodes.this.myGraph.getNodes(currentNode, goDown ? LiteLinearGraph.NodeFilter.DOWN : LiteLinearGraph.NodeFilter.UP)) {
                            if (ReachableNodes.this.myTempFlags.get(downNode)) continue;
                            ReachableNodes.this.myTempFlags.set(downNode, true);
                            consumer.consume((Object)downNode);
                            return downNode;
                        }
                        return -1;
                    }
                });
            }
        }
    }
}

