/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.naming.ConventionInspection;
import org.jetbrains.annotations.NotNull;

public class LambdaParameterNamingConventionInspectionBase
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 1;
    private static final int DEFAULT_MAX_LENGTH = 20;

    @NotNull
    public String getID() {
        if ("LambdaParameterNamingConvention" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/LambdaParameterNamingConventionInspectionBase", "getID"));
        }
        return "LambdaParameterNamingConvention";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("lambda.parameter.naming.convention.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/LambdaParameterNamingConventionInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String parameterName = (String)infos[0];
        if (parameterName.length() < this.getMinLength()) {
            String string = InspectionGadgetsBundle.message("lambda.parameter.naming.convention.problem.descriptor.short", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/LambdaParameterNamingConventionInspectionBase", "buildErrorString"));
            }
            return string;
        }
        if (parameterName.length() > this.getMaxLength()) {
            String string = InspectionGadgetsBundle.message("lambda.parameter.naming.convention.problem.descriptor.long", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/LambdaParameterNamingConventionInspectionBase", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("lambda.parameter.naming.convention.problem.descriptor.regex.mismatch", this.getRegex());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/LambdaParameterNamingConventionInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected String getDefaultRegex() {
        return "[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 1;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 20;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        public void visitParameter(@NotNull PsiParameter variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/naming/LambdaParameterNamingConventionInspectionBase$NamingConventionsVisitor", "visitParameter"));
            }
            PsiElement scope = variable.getDeclarationScope();
            if (!(scope instanceof PsiLambdaExpression)) {
                return;
            }
            String name = variable.getName();
            if (name == null || LambdaParameterNamingConventionInspectionBase.this.isValid(name)) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, name);
        }
    }
}

