/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class WaitWhileHoldingTwoLocksInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("wait.while.holding.two.locks.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/WaitWhileHoldingTwoLocksInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("wait.while.holding.two.locks.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/WaitWhileHoldingTwoLocksInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new WaitWhileHoldingTwoLocksVisitor();
    }

    private static class WaitWhileHoldingTwoLocksVisitor
    extends BaseInspectionVisitor {
        private WaitWhileHoldingTwoLocksVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            this.checkErrorsIn((PsiElement)method);
        }

        public void visitClassInitializer(PsiClassInitializer initializer) {
            this.checkErrorsIn((PsiElement)initializer);
        }

        private void checkErrorsIn(PsiElement context) {
            context.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){
                private int m_numLocksHeld;

                public void visitClass(PsiClass aClass) {
                }

                public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                    PsiType parameterType;
                    if (expression == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/WaitWhileHoldingTwoLocksInspection$WaitWhileHoldingTwoLocksVisitor$1", "visitMethodCallExpression"));
                    }
                    super.visitMethodCallExpression(expression);
                    if (this.m_numLocksHeld < 2) {
                        return;
                    }
                    PsiReferenceExpression methodExpression = expression.getMethodExpression();
                    String methodName = methodExpression.getReferenceName();
                    if (!"wait".equals(methodName)) {
                        return;
                    }
                    PsiMethod method = expression.resolveMethod();
                    if (method == null) {
                        return;
                    }
                    PsiParameterList parameterList = method.getParameterList();
                    int numParams = parameterList.getParametersCount();
                    if (numParams > 2) {
                        return;
                    }
                    PsiParameter[] parameters = parameterList.getParameters();
                    if (numParams > 0 && !(parameterType = parameters[0].getType()).equals(PsiType.LONG)) {
                        return;
                    }
                    if (numParams > 1 && !(parameterType = parameters[1].getType()).equals(PsiType.INT)) {
                        return;
                    }
                    WaitWhileHoldingTwoLocksVisitor.this.registerMethodCallError(expression, new Object[0]);
                }

                public void visitMethod(@NotNull PsiMethod method) {
                    if (method == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/threading/WaitWhileHoldingTwoLocksInspection$WaitWhileHoldingTwoLocksVisitor$1", "visitMethod"));
                    }
                    if (method.hasModifierProperty("synchronized")) {
                        ++this.m_numLocksHeld;
                    }
                    super.visitMethod(method);
                    if (method.hasModifierProperty("synchronized")) {
                        --this.m_numLocksHeld;
                    }
                }

                public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement synchronizedStatement) {
                    if (synchronizedStatement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "synchronizedStatement", "com/siyeh/ig/threading/WaitWhileHoldingTwoLocksInspection$WaitWhileHoldingTwoLocksVisitor$1", "visitSynchronizedStatement"));
                    }
                    ++this.m_numLocksHeld;
                    super.visitSynchronizedStatement(synchronizedStatement);
                    --this.m_numLocksHeld;
                }
            });
        }
    }
}

