/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.EventListener;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointBase;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.BreakpointTarget;
import org.jetbrains.debugger.FunctionSupport;

public abstract class BreakpointManagerBase<T extends BreakpointBase<?>>
implements BreakpointManager {
    protected final Set<T> breakpoints = ContainerUtil.newConcurrentSet();
    protected final ConcurrentMap<T, T> breakpointDuplicationByTarget = ContainerUtil.newConcurrentMap((TObjectHashingStrategy)new TObjectHashingStrategy<T>(){

        public int computeHashCode(T b) {
            int result = ((BreakpointBase)b).getLine();
            result = 31 * result + ((BreakpointBase)b).getColumn();
            if (((BreakpointBase)b).getCondition() != null) {
                result = 31 * result + ((BreakpointBase)b).getCondition().hashCode();
            }
            result = 31 * result + ((BreakpointBase)b).getTarget().hashCode();
            return result;
        }

        public boolean equals(T b1, T b2) {
            return ((BreakpointBase)b1).getTarget().getClass() == ((BreakpointBase)b2).getTarget().getClass() && ((BreakpointBase)b1).getTarget().equals(((BreakpointBase)b2).getTarget()) && ((BreakpointBase)b1).getLine() == ((BreakpointBase)b2).getLine() && ((BreakpointBase)b1).getColumn() == ((BreakpointBase)b2).getColumn() && StringUtil.equals((CharSequence)((BreakpointBase)b1).getCondition(), (CharSequence)((BreakpointBase)b2).getCondition());
        }
    });
    protected final EventDispatcher<BreakpointManager.BreakpointListener> dispatcher = EventDispatcher.create(BreakpointManager.BreakpointListener.class);

    protected abstract T createBreakpoint(@NotNull BreakpointTarget var1, int var2, int var3, @Nullable String var4, int var5, boolean var6);

    protected abstract Promise<Breakpoint> doSetBreakpoint(@NotNull BreakpointTarget var1, @NotNull T var2);

    @Override
    @NotNull
    public Breakpoint setBreakpoint(@NotNull BreakpointTarget target, int line, int column, @Nullable String condition, int ignoreCount, boolean enabled) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/debugger/BreakpointManagerBase", "setBreakpoint"));
        }
        final T breakpoint = this.createBreakpoint(target, line, column, condition, ignoreCount, enabled);
        BreakpointBase existingBreakpoint = (BreakpointBase)this.breakpointDuplicationByTarget.putIfAbsent(breakpoint, breakpoint);
        if (existingBreakpoint != null) {
            BreakpointBase breakpointBase = existingBreakpoint;
            if (breakpointBase == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/BreakpointManagerBase", "setBreakpoint"));
            }
            return breakpointBase;
        }
        this.breakpoints.add(breakpoint);
        if (enabled) {
            this.doSetBreakpoint(target, breakpoint).rejected((Consumer)new Consumer<Throwable>(){

                public void consume(@NotNull Throwable error) {
                    if (error == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "org/jetbrains/debugger/BreakpointManagerBase$2", "consume"));
                    }
                    String message = error.getMessage();
                    ((BreakpointManager.BreakpointListener)BreakpointManagerBase.this.dispatcher.getMulticaster()).errorOccurred(breakpoint, message == null ? error.toString() : message);
                }
            });
        }
        T t = breakpoint;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/BreakpointManagerBase", "setBreakpoint"));
        }
        return t;
    }

    @Override
    @NotNull
    public Promise<Void> remove(@NotNull Breakpoint breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "org/jetbrains/debugger/BreakpointManagerBase", "remove"));
        }
        BreakpointBase b = (BreakpointBase)breakpoint;
        boolean existed = this.breakpoints.remove(b);
        if (existed) {
            this.breakpointDuplicationByTarget.remove(b);
        }
        Promise<Void> promise = !existed || !b.isVmRegistered() ? Promise.DONE : this.doClearBreakpoint(b);
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/BreakpointManagerBase", "remove"));
        }
        return promise;
    }

    @Override
    @NotNull
    public Promise<Void> removeAll() {
        BreakpointBase[] list = this.breakpoints.toArray(new BreakpointBase[this.breakpoints.size()]);
        this.breakpoints.clear();
        this.breakpointDuplicationByTarget.clear();
        SmartList promises = new SmartList();
        for (BreakpointBase b : list) {
            if (!b.isVmRegistered()) continue;
            promises.add(this.doClearBreakpoint(b));
        }
        Promise promise = Promise.all((Collection)promises);
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/BreakpointManagerBase", "removeAll"));
        }
        return promise;
    }

    @NotNull
    protected abstract Promise<Void> doClearBreakpoint(@NotNull T var1);

    @Override
    public void addBreakpointListener(@NotNull BreakpointManager.BreakpointListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/debugger/BreakpointManagerBase", "addBreakpointListener"));
        }
        this.dispatcher.addListener((EventListener)listener);
    }

    public Iterable<T> getBreakpoints() {
        return this.breakpoints;
    }

    protected final void notifyBreakpointResolvedListener(@NotNull T breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "org/jetbrains/debugger/BreakpointManagerBase", "notifyBreakpointResolvedListener"));
        }
        if (((BreakpointBase)breakpoint).isResolved()) {
            ((BreakpointManager.BreakpointListener)this.dispatcher.getMulticaster()).resolved((Breakpoint)breakpoint);
        }
    }

    @Override
    @Nullable
    public FunctionSupport getFunctionSupport() {
        return null;
    }

    @Override
    public boolean hasScriptRegExpSupport() {
        return false;
    }

    @Override
    @NotNull
    public BreakpointManager.MUTE_MODE getMuteMode() {
        BreakpointManager.MUTE_MODE mUTE_MODE = BreakpointManager.MUTE_MODE.ONE;
        if (mUTE_MODE == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/BreakpointManagerBase", "getMuteMode"));
        }
        return mUTE_MODE;
    }

    @Override
    @NotNull
    public Promise<Void> flush(@NotNull Breakpoint breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "org/jetbrains/debugger/BreakpointManagerBase", "flush"));
        }
        Promise<Void> promise = ((BreakpointBase)breakpoint).flush(this);
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/BreakpointManagerBase", "flush"));
        }
        return promise;
    }

    @Override
    @NotNull
    public Promise<?> enableBreakpoints(boolean enabled) {
        Promise promise = Promise.reject((String)"Unsupported");
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/BreakpointManagerBase", "enableBreakpoints"));
        }
        return promise;
    }
}

