/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.util.io.socketConnection.SocketConnectionListener;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.HyperlinkListener;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.PropertyMetadata;
import kotlin.PropertyMetadataImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.ContextDependentAsyncResultConsumer;
import org.jetbrains.debugger.DebugProcessImpl;
import org.jetbrains.debugger.RejectErrorReporter;
import org.jetbrains.debugger.StepAction;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextManager;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.debugger.frame.SuspendContextImpl;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\u0015\u001e)\u0001B)\u001a2vOB\u0013xnY3tg&k\u0007\u000f\u001c\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015!!WMY;hO\u0016\u0014(\"A\"\u000b\u0019Yk7i\u001c8oK\u000e$\u0018n\u001c8\u000b\u0015\r|gN\\3di&|gNC\u0007Y\t\u0016\u0014Wo\u001a)s_\u000e,7o\u001d\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u0013a$WMY;hO\u0016\u0014(B\u0002\u001fj]&$hHC\u0004tKN\u001c\u0018n\u001c8\u000b\u001ba#UMY;h'\u0016\u001c8/[8o\u0015=)G-\u001b;peN\u0004&o\u001c<jI\u0016\u0014(\u0002\u0007-EK\n,xmZ3s\u000b\u0012LGo\u001c:t!J|g/\u001b3fe*QQM^1mk\u0006$\u0018n\u001c8\u000b)Ml\u0017M\u001d;Ti\u0016\u0004\u0018J\u001c;p\u0011\u0006tG\r\\3s\u0015UA6+\\1siN#X\r]%oi>D\u0015M\u001c3mKJT\u0001b\u001d;faBLgn\u001a\u0006\u0010Kb,7-\u001e;j_:\u0014Vm];mi*yQ\t_3dkRLwN\u001c*fgVdGOC\u0005fq\u0016\u001cW\u000f^5p]*\u0019rL\u0019:fC.\u0004x.\u001b8u\u0011\u0006tG\r\\3sg*)\u0011I\u001d:bs*11n\u001c;mS:T!\u0003\u0017\"sK\u0006\\\u0007o\\5oi\"\u000bg\u000e\u001a7fe*Y!M]3bWB|\u0017N\u001c;t\u0015qy&M]3bWB|\u0017N\u001c;IC:$G.\u001a:tI\u0011,G.Z4bi\u0016T!\u0002\u001d:pa\u0016\u0014H/[3t\u0015A\u0011V-\u00193P]2L\bK]8qKJ$\u0018P\u0003\fhKR|&M]3bWB|\u0017N\u001c;IC:$G.\u001a:t\u001559W\r^\"p]:,7\r^5p]*iB-[:bE2,Gi\u001c(piN#X\r]%oi>d\u0015N\u0019:be&,7OC\u0004C_>dW-\u00198\u000bA\u001d,G\u000fR5tC\ndW\rR8O_R\u001cF/\u001a9J]R|G*\u001b2sCJLWm\u001d\u0006!g\u0016$H)[:bE2,Gi\u001c(piN#X\r]%oi>d\u0015N\u0019:be&,7O\u0003\nhKR,\u00050Z2vi&|gNU3tk2$(bC5t\r>\u00148-Z*uKBTabZ3u\u0013N4uN]2f'R,\u0007O\u0003\btKRL5OR8sG\u0016\u001cF/\u001a9\u000b\u001b1\f7\u000f^\"bY24%/Y7f\u0015%\u0019\u0015\r\u001c7Ge\u0006lWM\u0003\thKRd\u0015m\u001d;DC2dgI]1nK*\u00012/\u001a;MCN$8)\u00197m\rJ\fW.\u001a\u0006\tY\u0006\u001cHo\u0015;fa*Q1\u000b^3q\u0003\u000e$\u0018n\u001c8\u000b\u0017\u001d,G\u000fT1tiN#X\r\u001d\u0006\fg\u0016$H*Y:u'R,\u0007O\u0003\u0013qe>\u001cWm]:Ce\u0016\f7\u000e]8j]R\u001cuN\u001c3ji&|gn]!u\u0013\u0012,7+\u001b3f\u00159\u0011X\r]3biN#X\r]%oi>TQ\"\u0011;p[&\u001c'i\\8mK\u0006t'\u0002\u00026bm\u0006TA!\u001e;jY*Q1m\u001c8dkJ\u0014XM\u001c;\u000b\r\u0005$x.\\5d\u0015E9W\r\u001e*fa\u0016\fGo\u0015;fa&sGo\u001c\u0006\u000fkJdGk\u001c$jY\u0016\u001c\u0015m\u00195f\u00155\u0019uN\\2veJ,g\u000e^'ba*\u0019QK\u001d7\u000b\u0017YK'\u000f^;bY\u001aKG.\u001a\u0006\b_B,g.\u00199j\u0015\r1hm\u001d\u0006\u0012O\u0016$XK\u001d7U_\u001aKG.Z\"bG\",'\"\u00052sK\u0006\\\u0007o\\5oiJ+\u0017m\u00195fI*Q!M]3bWB|\u0017N\u001c;\u000b\u0017a\u0013%/Z1la>Lg\u000e\u001e\u0006\u0017KZ\fG.^1uK\u0012dunZ#yaJ,7o]5p]*11\u000b\u001e:j]\u001eTab];ta\u0016tGmQ8oi\u0016DHOC\bY'V\u001c\b/\u001a8e\u0007>tG/\u001a=u\u0015\u00151'/Y7f\u0015\u0011)f.\u001b;\u000b\t1\fgn\u001a\u0006\u0018G\",7m[\"b]B+'OZ8s[\u000e{W.\\1oINT!bY8oi&tW/\u001a,n\u0015)\u0019H/\u001a9BGRLwN\u001c\u0006\u0019GJ,\u0017\r^3Ce\u0016\f7\u000e]8j]RD\u0015M\u001c3mKJ\u001c(b\u00053p\u000f\u0016$\bK]8dKN\u001c\b*\u00198eY\u0016\u0014(B\u0004)s_\u000e,7o\u001d%b]\u0012dWM\u001d\u0006\baJ|7-Z:t\u0015U9W\r\u001e\"sK\u0006\\\u0007o\\5oi\"\u000bg\u000e\u001a7feNT\u0001eZ3u\u0007V\u0014(/\u001a8u'R\fG/\u001a%za\u0016\u0014H.\u001b8l\u0019&\u001cH/\u001a8fe*\t\u0002*\u001f9fe2Lgn\u001b'jgR,g.\u001a:\u000b\u000b)\fg/\u0019=\u000b\u000bM<\u0018N\\4\u000b\u000b\u00154XM\u001c;\u000b\u00119+H\u000e\\1cY\u0016T1\"\u00198o_R\fG/[8og*92n\u001c;mS:t#N^7/!2\fGOZ8s[RK\b/\u001a\u0006\u0017O\u0016$8)\u001e:sK:$8\u000b^1uK6+7o]1hK*9aj\u001c;Ok2d'BE4fi\u0016#\u0017\u000e^8sgB\u0013xN^5eKJTQcZ3u%\u0016\fG\u000e\u0015:pG\u0016\u001c8\u000fS1oI2,'OC\fhKR\u001cV.\u0019:u'R,\u0007/\u00138u_\"\u000bg\u000e\u001a7fe*)q-\u001a;W[*\u0011a+\u001c\u0006\u0015SN4\u0016\r\\;fg\u000e+8\u000f^8n'>\u0014H/\u001a3\u000b%%\u001ch+\\*uKB|U\u000f^\"peJ,7\r\u001e\u0006\u0012aJ|7-Z:t\u0005J,\u0017m\u001b9pS:$(BD*vgB,g\u000eZ\"p]R,\u0007\u0010\u001e\u0006\u0010qN+8\u000f]3oI\u000e{g\u000e^3yi*\u00112+^:qK:$7i\u001c8uKb$\u0018*\u001c9m\u0015!\u0002(o\\2fgN\u0014%/Z1la>Lg\u000e\u001e'pO\u0016C\bO]3tg&|g.\u00118e'V\u001c\b/\u001a8e\u0015\u0019\u0011Xm];nK*\u00012/\u0019<f%\u0016\u001cx\u000e\u001c<fI\u001aKG.\u001a\u0006\u0004kJd'\u0002\u00024jY\u0016T!b]3u\u001fZ,'\u000f\\1z\u0015\u001d\u001aX\r\u001e)s_\u000e,7o\u001d\"sK\u0006\\\u0007o\\5oi\u000e{g\u000eZ5uS>t7/\u0011;JI\u0016\u001c\u0016\u000eZ3\u000b\u000bY\fG.^3\u000b%M$\u0018M\u001d;G_J\u001cWm\u0015;fa&sGo\u001c\u0006\rgR\f'\u000f\u001e)bkNLgn\u001a\u0006\u000egR\f'\u000f^*uKBLe\u000e^8\u000b\u0019M$\u0018M\u001d;Ti\u0016\u0004x*\u001e;\u000b\u001bM$\u0018M\u001d;Ti\u0016\u0004xJ^3s\u0015M)\b\u000fZ1uK2\u000b7\u000f^\"bY24%/Y7fi\u0010Q!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0004\t\u0005A\u0001\u0001\u0004\u0001\u0006\u0005\u0011\t\u0001bA\u0003\u0004\t\tA)\u0001\u0004\u0001\u0006\u0003!!QA\u0001\u0003\u0004\u0011\u0013)!\u0001b\u0002\t\u000b\u0015\u0019A\u0001\u0002E\u0004\u0019\u0001)1\u0001\u0002\u0003\t\u000e1\u0001QA\u0001\u0003\u0005\u0011!)1\u0001b\u0003\t\u00101\u0001QA\u0001\u0003\u0005\u0011')1\u0001\"\u0004\t\u00131\u0001QA\u0001C\u0004\u0011-)1\u0001b\u0004\t\u00161\u0001QA\u0001\u0003\u0005\u0011\u001b)!\u0001\u0002\u0002\t\u0006\u0015\u0011A1\u0002E\b\u000b\t!i\u0001C\u0005\u0006\u0005\u0011=\u0001RC\u0003\u0002\u00113)1\u0001B\u0006\t\u00191\u0001QA\u0001\u0003\u0005\u00117)1\u0001\u0002\u0007\t\u001b1\u0001QA\u0001\u0003\f\u0011;)!\u0001B\u0007\t\u001f\u0015\u0011A\u0001\u0004\u0005\u000e\u000b\r!1\u0002C\t\r\u0001\u0015\u0019A!\u0001\u0005\u0016\u0019\u0001)!\u0001B\u0001\t+\u0015\u0019A!\u0001\u0005\u0018\u0019\u0001)!\u0001B\u0001\t/\u0015\t\u0001BG\u0003\u0003\tEA)$\u0002\u0002\u0005$!YRA\u0001\u0003\u0013\u0011o)1\u0001\"\n\t41\u0001QA\u0001C\u0013\u0011g)1\u0001\u0002\n\t;1\u0001QA\u0001C\u0004\u0011k)1\u0001\"\u000b\t<1\u0001QA\u0001C\u0004\u0011{)!\u0001b\u000b\t?\u0015\u0019AA\u0006\u0005\u001f\u0019\u0001)!\u0001\u0002\n\t;\u0015\u0019A\u0001\u0004\u0005\"\u0019\u0001)1\u0001B\u0006\tE1\u0001QA\u0001\u0003\u0005\u0011\u000f*1\u0001\"\r\tG1\u0001Qa\u0001\u0003\f\u0011\u0011b\u0001!\u0002\u0002\u0005\u0019!\tSA\u0001\u0003\u0012\u0011\u0013*!\u0001\"\u000e\tE\u0015\u0011A\u0011\u0007\u0005$\u000b\t!y\u0001\u0003\u0015\u0006\u0007\u0011a\u0002r\n\u0007\u0001\u000b\t!A\u0004c\u0014\u0006\u0003!QSA\u0001C\u001e\u0011+*!\u0001\u0002\u0010\tW\u0015\u0019AQ\bE*\u0019\u0001)!\u0001\"\u0001\tY\u0015\u0019Aq\bE,\u0019\u0001)!\u0001\"\u0010\tT\u0015\u0019Aq\bE.\u0019\u0001)1\u0001B\u0001\ta1\u0001QA\u0001\u0003\u0002\u0011A*1\u0001B\u0001\te1\u0001QA\u0001\u0003\u0002\u0011\u000f*1\u0001B\u0012\tg1\u0001QA\u0001\u0003\u0002\u0011I*!\u0001B\u0012\tg\u0015\u0011A\u0011\u0006E\u001e\u000b\t!a\u0003\u0003\u0010\u0005'1\rQc\u0002\u0003\u0001\u0011\t)B!B\u0001\t\u0006%\tA1A\r\u0003\u000b\u0005AI!L\f\u0005C\u0012A:\"\t\u0005\u0006\u0003!]\u0011\"B\u0005\u0005\u000b\u0005AI\"C\u0001\u0005\u0004\u0011\nSkA\u0005\u0006\u0007\u0011q\u0011\"\u0001E\u000e\u001b\u0011!y\"\u0003\u0002\t\u001d1\u0005Q\u0006\u0005\u0003d\ta\u0019\u0011eA\u0003\u0003\t\u0003A\u0001!V\u0002\t\u000b\r!1!C\u0001\t\u00135\u0019A\u0001E\u0005\u0002\u0011%is\u0003\"b\r1C\t#!B\u0001\t\u001e\u0011\u0012\u0001FA+\u0004\u001d\u0015\u0019A\u0011E\u0005\u0002\t\u0003i1\u0001b\t\n\u0003\u0011\u0005\u0011#\u0002\u0003\u0013\u0013\u0005!\u0001!D\u0001\u0005\u00025ZA!\u0019\u0003\u0019\u000f\u0005\u0012Q!\u0001\u0005\u0007+\u000e!Qa\u0001\u0003\b\u0013\u0005A\u0019\"\f\t\u0005E\u0012A\"\"I\u0002\u0006\u0003!AA\u0012A+\u0004\u0011\u0015\u0019AAC\u0005\u0002\u0011+i1\u0001\"\n\n\u0003!UQf\u0006CC\u001aa\u0019\u0012EA\u0003\u0002\u0011;!#\u0001\u000b\u0002V\u00079)1\u0001B\n\n\u0003\u0011\u0005Qb\u0001C\u0014\u0013\u0005!\t!E\u0003\u0005)%\tA\u0001A\u0007\u0002\t\u0003i\u0003\u0004\"b\r1S\t3!B\u0001\t\u001f1\u0005AE\u0001\u0015\u0003+\u000eqQa\u0001C\u0015\u0013\u0005Ay\"D\u0002\u0005,%\t\u0001rD\t\u0006\tYI\u0011\u0001\u0002\u0001\u000e\u0003!}Q\u0006\u0007CC\u001aa5\u0012eA\u0003\u0002\u0011Aa\t\u0001\n\u0002)\u0005U\u001ba\"B\u0002\u0005.%\t\u0001\u0012E\u0007\u0004\t_I\u0011\u0001#\t\u0012\u000b\u0011A\u0012\"\u0001\u0003\u0001\u001b\u0005A\t#L\u0006\u0005\u00034A\n$\t\u0002\u0006\u0003!uQk\u0001\u0003\u0006\u0007\u0011E\u0012\"\u0001C\u0001[=!!\r\u0002\r\u001aC\t)\u0011\u0001C\nV\u0007!)1\u0001B\r\n\u0003!\u001dRb\u0001\u0003\u001d\u0013\u0005A9#\f\b\u0005C\u0012A\n\"I\u0003\u0006\u0003!9\u0011\"\u0001C\u0002\u0019\u0003)6\u0001B\u0003\u0004\t#I\u0011\u0001\u0003\u0006./\u0011\u0011G\u0001'\u000f\"\u0015\u0015\t\u0001\u0002F\u0005\u0004\u0013\t)\u0011\u0001C\u000b\n\u0007%\u0011Q!\u0001E\u0017+\u000eAQa\u0001C\u001d\u0013\u0005Aq#D\u0002\u0005@%\t\u0001bF\u0017*\t\u0005A\u0002%(\u0005\u0005\u0001!\u0005S\u0002B\u0003\u0002\u0011_I\u0011\u0001b\u0001Q\u0007\u0001iz\u0001\u0002\u0001\tD5\u0019Q!\u0001\u0005\u0019\u0019\u0003\u00016\u0011AO\u0007\t\u0001A)%\u0004\u0002\u0006\u0003!I\u0002kA\u0001\"\u0005\u0015\t\u00012G)\u0004\u0013\u0011\u0001\u0013\"\u0001\u0003\u0001\u001b\u0005A!$D\u0001\t75\t\u0001rGW\n\t\rAR%\t\u0002\u0006\u0003!u\u0011kA\u0002\u0005K%\tA\u0011A\u0017\u0014\t\tAZ%(\u0004\u0005\u0001!1SBA\u0003\u0002\u0011A\u00016\u0001A\u0011\u0003\u000b\u0005A\u0019$U\u0002\u0006\t\u0017J\u0011\u0001\u0002\u0001\u000e\u0003!\u0005R\u0016\u0005\u0003\u00131\u001b\n\u0003\"B\u0001\t\u0018%)\u0011\u0002B\u0003\u0002\u00113I\u0011\u0001b\u0001R\u0007\u0011!i%\u0003\u0002\t\u001d1\u0005Q6\u0003\u0003\u000b1\u001d\n#!B\u0001\t:E\u001b1\u0001B\u0014\n\u0003!iR\u0016\u0005\u0003\u00041#\n\u0003\"B\u0001\t\u0018%)\u0011\u0002B\u0003\u0002\u00113I\u0011\u0001b\u0001R\u0007\u0011!\t&\u0003\u0002\t\u001d1\u0005Qv\u0005\u0003\u00041%\nC\"B\u0001\t?AeS3B\u0003\u0002\u0011}a\t!U\u0002\u0002\t\u0001\n6!\u0001\u0003!#\u000e\u0019A!K\u0005\u0002\u0011\u0003j;\u0003B\u0002\u0019[\u0005bQ!\u0001\u0005\u0019!3*Z!B\u0001\t11\u0005\u0011kA\u0001\u0005CE\u001b\u0011\u0001B\u0011R\u0007\r!Q&C\u0001\t75NAa\u0001\r/C\t)\u0011\u0001\u0003\u0004R\u0007\r!a&C\u0001\t\u00145VAA\u0001M/C\r)\u0011\u0001#\u000f\r\u0002E\u001b1\u0001\"\u0018\n\u0003!iR\u0016\u0004\u0003\u00041=\nS!B\u0001\t\u000f%\tA1\u0001G\u0001#\u000e\u0019AaL\u0005\u0002\u0011)i+\u0002B\u0002\u0019`\u0005\u001aQ!\u0001E\"\u0019\u0003\t6a\u0001C0\u0013\u0005A!%l\u0005\u0005\u0007a\u0005\u0014EA\u0003\u0002\u0011;\t6a\u0001C1\u0013\u0005!\t!l\u0005\u0005\u0015a\t\u0014EA\u0003\u0002\u0011;\t6a\u0001\u00032\u0013\u0005!\t!\f\u0015\u0005\u0005a\rTT\u0002\u0003\u0001\u0011\u000bj!!B\u0001\tFA\u001b\u0001!(\u0005\u0005\u0001!\u0005S\u0002B\u0003\u0002\u0011_I\u0011\u0001b\u0001Q\u0007\u0003ij\u0001\u0002\u0001\tf5\u0011Q!\u0001E$!\u000e\t\u0011EA\u0003\u0002\u0011g\t6!\u0003C2\u0013\u0005!\u0001!D\u0001\tI5\t\u0001BG\u0007\u0002\u0011\u0013j\u0003\u0006B\u0001\u0019huEA\u0001\u0001E!\u001b\u0011)\u0011\u0001c\f\n\u0003\u0011\r\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001RM\u0007\u0003\u000b\u0005A9\u0005UB\u0001;\u001b!\u0001\u0001#\u0012\u000e\u0005\u0015\t\u0001R\t)\u0004\u0003\u0005\u0012Q!\u0001E\u001a#\u000eIAqM\u0005\u0002\t\u0001i\u0011\u0001\u0003\u000e\u000e\u0003!%S\"\u0001\u0005%['!1\u0001\u0007\u001b\"\u0005\u0015\t\u00012G)\u0004\u0007\u0011!\u0014\"\u0001\u0003\u0001[s!1\u0001'\u001b\u001e\u000e\u0011\u0001\u0001\"N\u0007\u0003\u000b\u0005AQ\u0003U\u0002\u0001;\u001b!\u0001\u0001c\u001b\u000e\u0005\u0015\t\u0001R\u0006)\u0004\u0002\u0005\u0012Q!\u0001E\u001a#\u000e9A\u0011N\u0005\u0002\t\u0001i\u0011\u0001C\u0013\u000e\u0003!-S6\u0003\u0003\u00031Y\n#!B\u0001\t4E\u001b1\u0001\u0002\u001c\n\u0003\u0011\u0001Qf\u0005\u0003\u00041[jj\u0001\u0002\u0001\to5\u0011Q!\u0001E\u000f!\u000e\u0001\u0011EA\u0003\u0002\u0011g\t6!\u0002C7\u0013\u0005!\u0001!D\u0001\u0005\u00025NAa\u0001M8C\t)\u0011\u0001c\rR\u0007\r!y'C\u0001\u0005\u00015NAa\u0001\r9C\t)\u0011\u0001c\rR\u0007\r!\u0001(C\u0001\u0005\u00015NAa\u0001M9C\t)\u0011\u0001c\rR\u0007\r!\t(C\u0001\u0005\u00015NAa\u0001\r:C\t)\u0011\u0001c\rR\u0007\r!\u0011(C\u0001\u0005\u00015NAa\u0001M:C\t)\u0011\u0001c\rR\u0007\r!\u0019(C\u0001\u0005\u00015NA!\u0001\r;C\t)\u0011\u0001c\rR\u0007\r!!(C\u0001\u0005\u0001Uj\r!bf\u0001\t\r\b\u0011c\u0002\u0003\u0001\u0011\t)B!B\u0001\t\u0006%\tA1\u0001M\u0006;\u001b!\u0001\u0001\u0003\u0004\u000e\u0005\u0015\t\u0001\"\u0002)\u0004\u0001u=A\u0001\u0001\u0005\u0004\u001b\r)!\u0001\"\u0001\t\u0001A\u001b\t!(\u0004\u0005\u0001!9QBA\u0003\u0002\u0011\u0019\u00016!AO\n\t\u0001A\t\"D\u0003\u0006\u0003!9\u0011\"\u0001C\u0002\u0019\u0003\u000161AO\b\t\u0001A!\"D\u0002\u0006\u0003!AA\u0012\u0001)\u0004\u0005\u0005:Q!\u0001E\u0002\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0001\u0011kA\u0007\u0005\f%\tA\u0001A\u0007\u0002\u0011#i\u0011\u0001C\u0005\u000e\u0003!MQ\"\u0001\u0005\u000b\u001b\u0005A)\u0002"})
public abstract class DebugProcessImpl<C extends VmConnection<?>>
extends XDebugProcess {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final AtomicBoolean repeatStepInto;
    @Nullable
    private volatile StepAction lastStep;
    @Nullable
    private volatile CallFrame lastCallFrame;
    private volatile boolean isForceStep;
    private volatile boolean disableDoNotStepIntoLibraries;
    @NotNull
    private final ConcurrentMap<Url, VirtualFile> urlToFileCache;
    private boolean processBreakpointConditionsAtIdeSide;
    private final ReadOnlyProperty<? super Object, ? extends XBreakpointHandler<?>[]> _breakpointHandlers$delegate;
    @NotNull
    private final C connection;
    private final XDebuggerEditorsProvider editorsProvider;
    private final XSmartStepIntoHandler<?> smartStepIntoHandler;
    @Nullable
    private final ExecutionResult executionResult;
    private static final /* synthetic */ PropertyMetadata[] $propertyMetadata;

    static {
        $kotlinClass = Reflection.createKotlinClass(DebugProcessImpl.class);
        $propertyMetadata = new PropertyMetadata[]{new PropertyMetadataImpl("_breakpointHandlers")};
    }

    @NotNull
    protected final AtomicBoolean getRepeatStepInto() {
        return this.repeatStepInto;
    }

    @Nullable
    protected final StepAction getLastStep() {
        return this.lastStep;
    }

    protected final void setLastStep(@JetValueParameter(name="<set-?>", type="?") @Nullable StepAction stepAction) {
        this.lastStep = stepAction;
    }

    @Nullable
    protected final CallFrame getLastCallFrame() {
        return this.lastCallFrame;
    }

    protected final void setLastCallFrame(@JetValueParameter(name="<set-?>", type="?") @Nullable CallFrame callFrame) {
        this.lastCallFrame = callFrame;
    }

    protected final boolean getIsForceStep() {
        return this.isForceStep;
    }

    protected final void setIsForceStep(@JetValueParameter(name="<set-?>") boolean bl) {
        this.isForceStep = bl;
    }

    protected final boolean getDisableDoNotStepIntoLibraries() {
        return this.disableDoNotStepIntoLibraries;
    }

    protected final void setDisableDoNotStepIntoLibraries(@JetValueParameter(name="<set-?>") boolean bl) {
        this.disableDoNotStepIntoLibraries = bl;
    }

    @NotNull
    protected final ConcurrentMap<Url, VirtualFile> getUrlToFileCache() {
        return this.urlToFileCache;
    }

    private final XBreakpointHandler<?>[] get_breakpointHandlers() {
        return (XBreakpointHandler[])this._breakpointHandlers$delegate.get((Object)this, $propertyMetadata[0]);
    }

    @Nullable
    protected final ProcessHandler getRealProcessHandler() {
        ExecutionResult executionResult = this.executionResult;
        return executionResult != null ? executionResult.getProcessHandler() : null;
    }

    @Nullable
    public final XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        return this.smartStepIntoHandler;
    }

    @NotNull
    public final XBreakpointHandler<?>[] getBreakpointHandlers() {
        return this.get_breakpointHandlers();
    }

    @NotNull
    public final XDebuggerEditorsProvider getEditorsProvider() {
        return this.editorsProvider;
    }

    public final void setProcessBreakpointConditionsAtIdeSide(@JetValueParameter(name="value") boolean value) {
        this.processBreakpointConditionsAtIdeSide = value;
    }

    @Nullable
    public final Vm getVm() {
        return ((VmConnection)this.connection).getVm();
    }

    @NotNull
    protected abstract XBreakpointHandler<?>[] createBreakpointHandlers();

    private final void updateLastCallFrame() {
        Object object = this.getVm();
        this.lastCallFrame = object != null && (object = object.getSuspendContextManager()) != null && (object = object.getContext()) != null ? object.getTopFrame() : null;
    }

    public final boolean checkCanPerformCommands() {
        return this.getVm() != null;
    }

    public final boolean isValuesCustomSorted() {
        return true;
    }

    public final void startStepOver() {
        this.updateLastCallFrame();
        this.continueVm(StepAction.OVER);
    }

    public final void startForceStepInto() {
        this.isForceStep = true;
        this.startStepInto();
    }

    public final void startStepInto() {
        this.updateLastCallFrame();
        this.continueVm(StepAction.IN);
    }

    public final void startStepOut() {
        if (this.isVmStepOutCorrect()) {
            this.lastCallFrame = null;
        } else {
            this.updateLastCallFrame();
        }
        this.continueVm(StepAction.OUT);
    }

    protected boolean isVmStepOutCorrect() {
        return true;
    }

    public final void resume() {
        this.continueVm(StepAction.CONTINUE);
    }

    protected final void continueVm(@JetValueParameter(name="stepAction") @NotNull StepAction stepAction) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)stepAction), (String)"stepAction");
        Vm vm = this.getVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        SuspendContextManager suspendContextManager = vm.getSuspendContextManager();
        if (stepAction == StepAction.CONTINUE) {
            if (suspendContextManager.getContext() == null) {
                return;
            }
            this.lastStep = null;
            this.lastCallFrame = null;
            this.urlToFileCache.clear();
            this.disableDoNotStepIntoLibraries = false;
        } else {
            this.lastStep = stepAction;
        }
        suspendContextManager.continueVm(stepAction, 1);
    }

    protected final void setOverlay() {
        Vm vm = this.getVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        vm.getSuspendContextManager().setOverlayMessage("Paused in debugger");
    }

    protected final void processBreakpoint(@JetValueParameter(name="suspendContext") @NotNull SuspendContext suspendContext, @JetValueParameter(name="breakpoint") @NotNull XBreakpoint<?> breakpoint, @JetValueParameter(name="xSuspendContext") @NotNull SuspendContextImpl xSuspendContext) {
        String condition;
        Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Intrinsics.checkParameterIsNotNull((Object)((Object)xSuspendContext), (String)"xSuspendContext");
        XExpression xExpression = breakpoint.getConditionExpression();
        String string = condition = xExpression != null ? xExpression.getExpression() : null;
        if (!this.processBreakpointConditionsAtIdeSide || condition == null) {
            this.processBreakpointLogExpressionAndSuspend(breakpoint, xSuspendContext, suspendContext);
        } else {
            xSuspendContext.evaluateExpression(condition).done((Consumer)new ContextDependentAsyncResultConsumer<String>(this, breakpoint, xSuspendContext, suspendContext, suspendContext){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint;
                final /* synthetic */ SuspendContextImpl $xSuspendContext;
                final /* synthetic */ SuspendContext $suspendContext;

                static {
                    $kotlinClass = Reflection.createKotlinClass(processBreakpoint.1.class);
                }

                protected void consume(@JetValueParameter(name="evaluationResult") @NotNull String evaluationResult, @JetValueParameter(name="vm") @NotNull Vm vm) {
                    Intrinsics.checkParameterIsNotNull((Object)evaluationResult, (String)"evaluationResult");
                    Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
                    if (Intrinsics.areEqual((Object)"false", (Object)evaluationResult)) {
                        this.this$0.resume();
                    } else {
                        DebugProcessImpl.access$processBreakpointLogExpressionAndSuspend$0(this.this$0, this.$breakpoint, this.$xSuspendContext, this.$suspendContext);
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$breakpoint = $captured_local_variable$1;
                    this.$xSuspendContext = $captured_local_variable$2;
                    this.$suspendContext = $captured_local_variable$3;
                    super($super_call_param$4);
                }
            }).rejected((Consumer)new ContextDependentAsyncResultConsumer<Throwable>(this, breakpoint, xSuspendContext, suspendContext, suspendContext){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint;
                final /* synthetic */ SuspendContextImpl $xSuspendContext;
                final /* synthetic */ SuspendContext $suspendContext;

                static {
                    $kotlinClass = Reflection.createKotlinClass(processBreakpoint.2.class);
                }

                protected void consume(@JetValueParameter(name="failure") @NotNull Throwable failure, @JetValueParameter(name="vm") @NotNull Vm vm) {
                    Intrinsics.checkParameterIsNotNull((Object)failure, (String)"failure");
                    Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
                    DebugProcessImpl.access$processBreakpointLogExpressionAndSuspend$0(this.this$0, this.$breakpoint, this.$xSuspendContext, this.$suspendContext);
                }
                {
                    this.this$0 = $outer;
                    this.$breakpoint = $captured_local_variable$1;
                    this.$xSuspendContext = $captured_local_variable$2;
                    this.$suspendContext = $captured_local_variable$3;
                    super($super_call_param$4);
                }
            });
        }
    }

    private final void processBreakpointLogExpressionAndSuspend(@JetValueParameter(name="breakpoint") XBreakpoint<?> breakpoint, @JetValueParameter(name="xSuspendContext") SuspendContextImpl xSuspendContext, @JetValueParameter(name="suspendContext") SuspendContext suspendContext) {
        String logExpression;
        XExpression xExpression = breakpoint.getLogExpressionObject();
        String string = logExpression = xExpression != null ? xExpression.getExpression() : null;
        if (logExpression == null) {
            this.breakpointReached(breakpoint, null, xSuspendContext);
        } else {
            xSuspendContext.evaluateExpression(logExpression).done((Consumer)new ContextDependentAsyncResultConsumer<String>(this, breakpoint, xSuspendContext, suspendContext){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint;
                final /* synthetic */ SuspendContextImpl $xSuspendContext;

                static {
                    $kotlinClass = Reflection.createKotlinClass(processBreakpointLogExpressionAndSuspend.1.class);
                }

                protected void consume(@JetValueParameter(name="logResult") @NotNull String logResult, @JetValueParameter(name="vm") @NotNull Vm vm) {
                    Intrinsics.checkParameterIsNotNull((Object)logResult, (String)"logResult");
                    Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
                    DebugProcessImpl.access$breakpointReached$1(this.this$0, this.$breakpoint, logResult, this.$xSuspendContext);
                }
                {
                    this.this$0 = $outer;
                    this.$breakpoint = $captured_local_variable$1;
                    this.$xSuspendContext = $captured_local_variable$2;
                    super($super_call_param$3);
                }
            }).rejected((Consumer)new ContextDependentAsyncResultConsumer<Throwable>(this, breakpoint, logExpression, xSuspendContext, suspendContext){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint;
                final /* synthetic */ String $logExpression;
                final /* synthetic */ SuspendContextImpl $xSuspendContext;

                static {
                    $kotlinClass = Reflection.createKotlinClass(processBreakpointLogExpressionAndSuspend.2.class);
                }

                protected void consume(@JetValueParameter(name="logResult") @NotNull Throwable logResult, @JetValueParameter(name="vm") @NotNull Vm vm) {
                    Intrinsics.checkParameterIsNotNull((Object)logResult, (String)"logResult");
                    Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
                    DebugProcessImpl.access$breakpointReached$1(this.this$0, this.$breakpoint, "Failed to evaluate expression: " + this.$logExpression, this.$xSuspendContext);
                }
                {
                    this.this$0 = $outer;
                    this.$breakpoint = $captured_local_variable$1;
                    this.$logExpression = $captured_local_variable$2;
                    this.$xSuspendContext = $captured_local_variable$3;
                    super($super_call_param$4);
                }
            });
        }
    }

    private final void breakpointReached(@JetValueParameter(name="breakpoint") XBreakpoint<?> breakpoint, @JetValueParameter(name="evaluatedLogExpression", type="?") String evaluatedLogExpression, @JetValueParameter(name="suspendContext") XSuspendContext suspendContext) {
        if (this.getSession().breakpointReached(breakpoint, evaluatedLogExpression, suspendContext)) {
            this.setOverlay();
        } else {
            this.resume();
        }
    }

    public final void startPausing() {
        ((VmConnection)this.connection).getVm().getSuspendContextManager().suspend().rejected((Consumer)new RejectErrorReporter(this.getSession(), "Cannot pause"));
    }

    @NotNull
    public final String getCurrentStateMessage() {
        return ((VmConnection)this.connection).getState().getMessage();
    }

    public final HyperlinkListener getCurrentStateHyperlinkListener() {
        return ((VmConnection)this.connection).getState().getMessageLinkListener();
    }

    @NotNull
    protected ProcessHandler doGetProcessHandler() {
        ExecutionResult executionResult = this.executionResult;
        if (executionResult == null || (executionResult = executionResult.getProcessHandler()) == null) {
            executionResult = (ProcessHandler)new DefaultDebugProcessHandler(){
                public static final /* synthetic */ KClass $kotlinClass;

                static {
                    $kotlinClass = Reflection.createKotlinClass(doGetProcessHandler.1.class);
                }

                public boolean isSilentlyDestroyOnClose() {
                    return true;
                }
            };
        }
        return executionResult;
    }

    public final void saveResolvedFile(@JetValueParameter(name="url") @NotNull Url url, @JetValueParameter(name="file") @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.urlToFileCache.putIfAbsent(url, file);
    }

    @NotNull
    public final C getConnection() {
        return this.connection;
    }

    @Nullable
    protected final ExecutionResult getExecutionResult() {
        return this.executionResult;
    }

    public DebugProcessImpl(@JetValueParameter(name="session") @NotNull XDebugSession session, @JetValueParameter(name="connection") @NotNull C connection, @JetValueParameter(name="editorsProvider") @NotNull XDebuggerEditorsProvider editorsProvider, @JetValueParameter(name="smartStepIntoHandler", type="?") @Nullable XSmartStepIntoHandler<?> smartStepIntoHandler, @JetValueParameter(name="executionResult", type="?") @Nullable ExecutionResult executionResult) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull(connection, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)editorsProvider, (String)"editorsProvider");
        super(session);
        this.connection = connection;
        this.editorsProvider = editorsProvider;
        this.smartStepIntoHandler = smartStepIntoHandler;
        this.executionResult = executionResult;
        this.repeatStepInto = new AtomicBoolean();
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.newConcurrentMap<Url, VirtualFile>()");
        this.urlToFileCache = concurrentMap;
        this._breakpointHandlers$delegate = Delegates.INSTANCE$.lazy((Function0)new Function0<XBreakpointHandler<?>[]>(this){
            final /* synthetic */ DebugProcessImpl this$0;

            @NotNull
            public final XBreakpointHandler<?>[] invoke() {
                return this.this$0.createBreakpointHandlers();
            }
            {
                this.this$0 = debugProcessImpl;
                super(0);
            }
        });
        ((VmConnection)this.connection).addListener(new SocketConnectionListener(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(1.class);
            }

            @Override
            public void statusChanged(@JetValueParameter(name="status") @NotNull ConnectionStatus status) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
                if (status == ConnectionStatus.DISCONNECTED || status == ConnectionStatus.DETACHED) {
                    if (status == ConnectionStatus.DETACHED && this.getRealProcessHandler() != null) {
                        this.getProcessHandler().detachProcess();
                    }
                    this.getSession().stop();
                } else {
                    this.getSession().rebuildViews();
                }
            }
        });
    }

    public static final /* synthetic */ void access$processBreakpointLogExpressionAndSuspend$0(@JetValueParameter(name="$this", type="?") DebugProcessImpl<C> $this, @JetValueParameter(name="breakpoint") @NotNull XBreakpoint<?> breakpoint, @JetValueParameter(name="xSuspendContext") @NotNull SuspendContextImpl xSuspendContext, @JetValueParameter(name="suspendContext") @NotNull SuspendContext suspendContext) {
        super.processBreakpointLogExpressionAndSuspend(breakpoint, xSuspendContext, suspendContext);
    }

    public static final /* synthetic */ void access$breakpointReached$1(@JetValueParameter(name="$this", type="?") DebugProcessImpl<C> $this, @JetValueParameter(name="breakpoint") @NotNull XBreakpoint<?> breakpoint, @JetValueParameter(name="evaluatedLogExpression", type="?") @Nullable String evaluatedLogExpression, @JetValueParameter(name="suspendContext") @NotNull XSuspendContext suspendContext) {
        super.breakpointReached(breakpoint, evaluatedLogExpression, suspendContext);
    }
}

