/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Consumer;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.ObsolescentConsumer;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeVariablesGroup;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.rpc.CommandProcessor;

class FunctionScopesValueGroup
extends XValueGroup {
    private final FunctionValue value;
    private final VariableContext variableContext;

    public FunctionScopesValueGroup(@NotNull FunctionValue value, @NotNull VariableContext variableContext) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/debugger/FunctionScopesValueGroup", "<init>"));
        }
        if (variableContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableContext", "org/jetbrains/debugger/FunctionScopesValueGroup", "<init>"));
        }
        super("Function scopes");
        this.value = value;
        this.variableContext = variableContext;
    }

    public void computeChildren(final @NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/debugger/FunctionScopesValueGroup", "computeChildren"));
        }
        node.setAlreadySorted(true);
        this.value.resolve().done((Consumer)new ObsolescentConsumer<FunctionValue>((Obsolescent)node){

            public void consume(FunctionValue value) {
                Scope[] scopes = value.getScopes();
                if (scopes == null || scopes.length == 0) {
                    node.addChildren(XValueChildrenList.EMPTY, true);
                } else {
                    ScopeVariablesGroup.createAndAddScopeList(node, Arrays.asList(scopes), FunctionScopesValueGroup.this.variableContext, null);
                }
            }
        }).rejected((Consumer)new Consumer<Throwable>(){

            public void consume(Throwable error) {
                Promise.logError((Logger)CommandProcessor.LOG, (Throwable)error);
                node.setErrorMessage(error.getMessage());
            }
        });
    }
}

