/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.config;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.generate.config.InsertNewMethodStrategy;

public class InsertAtCaretStrategy
implements InsertNewMethodStrategy {
    private static final InsertAtCaretStrategy instance = new InsertAtCaretStrategy();

    private InsertAtCaretStrategy() {
    }

    public static InsertAtCaretStrategy getInstance() {
        return instance;
    }

    @Override
    public PsiMethod insertNewMethod(PsiClass clazz, @NotNull PsiMethod newMethod, Editor editor) {
        if (newMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newMethod", "org/jetbrains/java/generate/config/InsertAtCaretStrategy", "insertNewMethod"));
        }
        int offset = editor != null ? editor.getCaretModel().getOffset() : clazz.getTextRange().getEndOffset() - 1;
        PsiGenerationInfo<PsiMethod> generationInfo = new PsiGenerationInfo<PsiMethod>(newMethod, false);
        GenerateMembersUtil.insertMembersAtOffset(clazz.getContainingFile(), offset, Arrays.asList(generationInfo));
        return generationInfo.getPsiMember();
    }

    public String toString() {
        return "At caret";
    }
}

