/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.annotations.NotNull;

public class JsCatchScope
extends JsScope {
    private final JsName name;

    public JsCatchScope(JsScope parent, @NotNull String ident) {
        if (ident == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ident", "com/google/dart/compiler/backend/js/ast/JsCatchScope", "<init>"));
        }
        super(parent, "Catch scope", null);
        this.name = new JsName(this, ident);
    }

    @Override
    @NotNull
    public JsName declareName(@NotNull String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/google/dart/compiler/backend/js/ast/JsCatchScope", "declareName"));
        }
        JsName jsName = this.getParent().declareName(identifier);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsCatchScope", "declareName"));
        }
        return jsName;
    }

    @Override
    public boolean hasOwnName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/google/dart/compiler/backend/js/ast/JsCatchScope", "hasOwnName"));
        }
        return this.findOwnName(name) != null;
    }

    @NotNull
    public JsCatchScope copy() {
        JsCatchScope jsCatchScope = new JsCatchScope(this.getParent(), this.name.getIdent());
        if (jsCatchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsCatchScope", "copy"));
        }
        return jsCatchScope;
    }

    @Override
    protected JsName findOwnName(@NotNull String ident) {
        if (ident == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ident", "com/google/dart/compiler/backend/js/ast/JsCatchScope", "findOwnName"));
        }
        return this.name.getIdent().equals(ident) ? this.name : null;
    }
}

