/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import com.sampullara.cli.Argument;
import java.io.PrintStream;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.ValueDescription;

class Usage {
    Usage() {
    }

    public static void print(@NotNull PrintStream target, @NotNull CommonCompilerArguments arguments2, boolean extraHelp) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/cli/common/Usage", "print"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/cli/common/Usage", "print"));
        }
        target.println("Usage: " + arguments2.executableScriptFileName() + " <options> <source files>");
        target.println("where " + (extraHelp ? "advanced" : "possible") + " options include:");
        for (Class<?> clazz = arguments2.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                String usage = Usage.fieldUsage(field, extraHelp);
                if (usage == null) continue;
                target.println(usage);
            }
        }
        if (extraHelp) {
            target.println();
            target.println("Advanced options are non-standard and may be changed or removed without any notice.");
        }
    }

    @Nullable
    private static String fieldUsage(@NotNull Field field, boolean extraHelp) {
        boolean extraOption;
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/kotlin/cli/common/Usage", "fieldUsage"));
        }
        Argument argument = field.getAnnotation(Argument.class);
        if (argument == null) {
            return null;
        }
        ValueDescription description = field.getAnnotation(ValueDescription.class);
        String value = argument.value();
        boolean bl = extraOption = value.startsWith("X") && value.length() > 1;
        if (extraHelp != extraOption) {
            return null;
        }
        String prefix = argument.prefix();
        StringBuilder sb = new StringBuilder("  ");
        sb.append(prefix);
        sb.append(value);
        if (!argument.alias().isEmpty()) {
            sb.append(" (");
            sb.append(prefix);
            sb.append(argument.alias());
            sb.append(")");
        }
        if (description != null) {
            sb.append(" ");
            sb.append(description.value());
        }
        while (sb.length() < 29) {
            sb.append(" ");
        }
        sb.append(argument.description());
        return sb.toString();
    }
}

