/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import kotlin.io.IoPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;

public interface MessageRenderer {
    public static final MessageRenderer XML = new MessageRenderer(){

        @Override
        public String renderPreamble() {
            return "<MESSAGES>";
        }

        @Override
        public String render(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
            if (severity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$1", "render"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$1", "render"));
            }
            if (location == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$1", "render"));
            }
            StringBuilder out = new StringBuilder();
            out.append("<").append(severity.toString());
            if (location.getPath() != null) {
                out.append(" path=\"").append(this.e(location.getPath())).append("\"");
                out.append(" line=\"").append(location.getLine()).append("\"");
                out.append(" column=\"").append(location.getColumn()).append("\"");
            }
            out.append(">");
            out.append(this.e(message));
            out.append("</").append(severity.toString()).append(">\n");
            return out.toString();
        }

        private String e(String str) {
            return StringUtil.escapeXml(str);
        }

        @Override
        public String renderConclusion() {
            return "</MESSAGES>";
        }
    };
    public static final MessageRenderer PLAIN_FULL_PATHS = new PlainText(){

        @Override
        @Nullable
        protected String getPath(@NotNull CompilerMessageLocation location) {
            if (location == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$2", "getPath"));
            }
            return location.getPath();
        }
    };
    public static final MessageRenderer PLAIN_RELATIVE_PATHS = new PlainText(){
        private final File cwd = new File(".").getAbsoluteFile();

        @Override
        @Nullable
        protected String getPath(@NotNull CompilerMessageLocation location) {
            if (location == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$3", "getPath"));
            }
            String path = location.getPath();
            return this.cwd == null || path == null ? path : IoPackage.relativePath(this.cwd, new File(path));
        }
    };

    public String renderPreamble();

    public String render(@NotNull CompilerMessageSeverity var1, @NotNull String var2, @NotNull CompilerMessageLocation var3);

    public String renderConclusion();

    public static abstract class PlainText
    implements MessageRenderer {
        @Override
        public String renderPreamble() {
            return "";
        }

        @Override
        public String render(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
            if (severity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$PlainText", "render"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$PlainText", "render"));
            }
            if (location == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$PlainText", "render"));
            }
            String path = this.getPath(location);
            String position = path == null ? "" : path + ": (" + location.getLine() + ", " + location.getColumn() + ") ";
            return (Object)((Object)severity) + ": " + position + message;
        }

        @Nullable
        protected abstract String getPath(@NotNull CompilerMessageLocation var1);

        @Override
        public String renderConclusion() {
            return "";
        }
    }
}

