/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BinaryOutputReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SvnProcessHandler
extends OSProcessHandler {
    private final boolean myForceUtf8;
    private final boolean myForceBinary;
    @NotNull
    private final ByteArrayOutputStream myBinaryOutput;

    public SvnProcessHandler(@NotNull Process process, boolean forceUtf8, boolean forceBinary) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/idea/svn/commandLine/SvnProcessHandler", "<init>"));
        }
        this(process, null, forceUtf8, forceBinary);
    }

    public SvnProcessHandler(@NotNull Process process, @Nullable String commandLine, boolean forceUtf8, boolean forceBinary) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/idea/svn/commandLine/SvnProcessHandler", "<init>"));
        }
        super(process, commandLine);
        this.myForceUtf8 = forceUtf8;
        this.myForceBinary = forceBinary;
        this.myBinaryOutput = new ByteArrayOutputStream();
    }

    @NotNull
    public ByteArrayOutputStream getBinaryOutput() {
        ByteArrayOutputStream byteArrayOutputStream = this.myBinaryOutput;
        if (byteArrayOutputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/SvnProcessHandler", "getBinaryOutput"));
        }
        return byteArrayOutputStream;
    }

    @Nullable
    public Charset getCharset() {
        return this.myForceUtf8 ? CharsetToolkit.UTF8_CHARSET : super.getCharset();
    }

    @NotNull
    protected BaseDataReader createOutputDataReader(BaseDataReader.SleepingPolicy sleepingPolicy) {
        if (this.myForceBinary) {
            SimpleBinaryOutputReader simpleBinaryOutputReader = new SimpleBinaryOutputReader(this.myProcess.getInputStream(), sleepingPolicy);
            if (simpleBinaryOutputReader == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/SvnProcessHandler", "createOutputDataReader"));
            }
            return simpleBinaryOutputReader;
        }
        BaseDataReader baseDataReader = super.createOutputDataReader(sleepingPolicy);
        if (baseDataReader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/SvnProcessHandler", "createOutputDataReader"));
        }
        return baseDataReader;
    }

    protected boolean useNonBlockingRead() {
        return false;
    }

    private class SimpleBinaryOutputReader
    extends BinaryOutputReader {
        public SimpleBinaryOutputReader(InputStream stream, BaseDataReader.SleepingPolicy sleepingPolicy) {
            if (stream == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "org/jetbrains/idea/svn/commandLine/SvnProcessHandler$SimpleBinaryOutputReader", "<init>"));
            }
            super(stream, sleepingPolicy);
            this.start();
        }

        protected void onBinaryAvailable(@NotNull byte[] data, int size) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/idea/svn/commandLine/SvnProcessHandler$SimpleBinaryOutputReader", "onBinaryAvailable"));
            }
            SvnProcessHandler.this.myBinaryOutput.write(data, 0, size);
        }

        protected Future<?> executeOnPooledThread(Runnable runnable) {
            return SvnProcessHandler.this.executeOnPooledThread(runnable);
        }
    }
}

