/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.RowIcon;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.idea.JetIcons;
import org.jetbrains.kotlin.psi.JetElement;

public final class JetDescriptorIconProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.kotlin.idea.JetDescriptorIconProvider");

    private JetDescriptorIconProvider() {
    }

    @NotNull
    public static Icon getIcon(@NotNull DeclarationDescriptor descriptor2, @Nullable PsiElement declaration, @Iconable.IconFlags int flags) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/JetDescriptorIconProvider", "getIcon"));
        }
        if (declaration != null && !(declaration instanceof JetElement)) {
            Icon icon = declaration.getIcon(flags);
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/JetDescriptorIconProvider", "getIcon"));
            }
            return icon;
        }
        Icon result2 = JetDescriptorIconProvider.getBaseIcon(descriptor2);
        if ((flags & 1) > 0) {
            RowIcon rowIcon = new RowIcon(2);
            rowIcon.setIcon(result2, 0);
            rowIcon.setIcon(JetDescriptorIconProvider.getVisibilityIcon(descriptor2), 1);
            result2 = rowIcon;
        }
        Icon icon = result2;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/JetDescriptorIconProvider", "getIcon"));
        }
        return icon;
    }

    private static Icon getVisibilityIcon(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/JetDescriptorIconProvider", "getVisibilityIcon"));
        }
        if (descriptor2 instanceof DeclarationDescriptorWithVisibility) {
            DeclarationDescriptorWithVisibility descriptorWithVisibility = (DeclarationDescriptorWithVisibility)descriptor2;
            Visibility visibility = descriptorWithVisibility.getVisibility();
            if (visibility == Visibilities.PUBLIC) {
                return PlatformIcons.PUBLIC_ICON;
            }
            if (visibility == Visibilities.PROTECTED) {
                return PlatformIcons.PROTECTED_ICON;
            }
            if (Visibilities.isPrivate(visibility)) {
                return PlatformIcons.PRIVATE_ICON;
            }
            if (visibility == Visibilities.INTERNAL) {
                return PlatformIcons.PACKAGE_LOCAL_ICON;
            }
        }
        return null;
    }

    private static Icon getBaseIcon(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/JetDescriptorIconProvider", "getBaseIcon"));
        }
        if (descriptor2 instanceof PackageFragmentDescriptor || descriptor2 instanceof PackageViewDescriptor) {
            return PlatformIcons.PACKAGE_ICON;
        }
        if (descriptor2 instanceof FunctionDescriptor) {
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)descriptor2;
            if (functionDescriptor.getExtensionReceiverParameter() != null) {
                return JetIcons.EXTENSION_FUNCTION;
            }
            if (descriptor2.getContainingDeclaration() instanceof ClassDescriptor) {
                if (Modality.ABSTRACT == functionDescriptor.getModality()) {
                    return PlatformIcons.ABSTRACT_METHOD_ICON;
                }
                return PlatformIcons.METHOD_ICON;
            }
            return JetIcons.FUNCTION;
        }
        if (descriptor2 instanceof ClassDescriptor) {
            switch (((ClassDescriptor)descriptor2).getKind()) {
                case INTERFACE: {
                    return JetIcons.TRAIT;
                }
                case ENUM_CLASS: {
                    return JetIcons.ENUM;
                }
                case ENUM_ENTRY: {
                    return JetIcons.ENUM;
                }
                case ANNOTATION_CLASS: {
                    return PlatformIcons.ANNOTATION_TYPE_ICON;
                }
                case OBJECT: {
                    return JetIcons.OBJECT;
                }
                case CLASS: {
                    return JetIcons.CLASS;
                }
            }
            LOG.warn("No icon for descriptor: " + descriptor2);
            return null;
        }
        if (descriptor2 instanceof ValueParameterDescriptor) {
            return JetIcons.PARAMETER;
        }
        if (descriptor2 instanceof LocalVariableDescriptor) {
            return ((VariableDescriptor)descriptor2).isVar() ? JetIcons.VAR : JetIcons.VAL;
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            return ((VariableDescriptor)descriptor2).isVar() ? JetIcons.FIELD_VAR : JetIcons.FIELD_VAL;
        }
        if (descriptor2 instanceof TypeParameterDescriptor) {
            return PlatformIcons.CLASS_ICON;
        }
        LOG.warn("No icon for descriptor: " + descriptor2);
        return null;
    }
}

