/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.unwrap;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.unwrap.KotlinUnwrapRemoveBase;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;

public abstract class KotlinComponentUnwrapper
extends KotlinUnwrapRemoveBase {
    public KotlinComponentUnwrapper(String key) {
        super(key);
    }

    @Nullable
    protected abstract JetExpression getExpressionToUnwrap(@NotNull JetElement var1);

    @NotNull
    protected JetElement getEnclosingElement(@NotNull JetElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinComponentUnwrapper", "getEnclosingElement"));
        }
        JetElement jetElement = element;
        if (jetElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinComponentUnwrapper", "getEnclosingElement"));
        }
        return jetElement;
    }

    public boolean isApplicableTo(PsiElement e) {
        if (!(e instanceof JetElement)) {
            return false;
        }
        JetExpression expressionToUnwrap = this.getExpressionToUnwrap((JetElement)e);
        return expressionToUnwrap != null && this.canExtractExpression(expressionToUnwrap, (JetElement)this.getEnclosingElement((JetElement)e).getParent());
    }

    protected void doUnwrap(PsiElement element, KotlinUnwrapRemoveBase.Context context2) throws IncorrectOperationException {
        JetElement targetElement = (JetElement)element;
        JetExpression expressionToUnwrap = this.getExpressionToUnwrap(targetElement);
        assert (expressionToUnwrap != null);
        JetElement enclosingElement = this.getEnclosingElement(targetElement);
        context2.extractFromExpression(expressionToUnwrap, enclosingElement);
        context2.delete((PsiElement)enclosingElement);
    }
}

