/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ClassFileViewProvider;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.decompiler.KotlinJavaScriptMetaFileType;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class DecompilerPackage$DecompiledUtils$cecda1c3 {
    public static final boolean isKotlinJvmCompiledFile(@JetValueParameter(name="file") @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String string = file.getExtension();
        JavaClassFileType javaClassFileType = JavaClassFileType.INSTANCE;
        if (javaClassFileType == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual((Object)string, (Object)javaClassFileType.getDefaultExtension()) ^ true) {
            return false;
        }
        KotlinJvmBinaryClass kotlinJvmBinaryClass = KotlinBinaryClassCache.getKotlinBinaryClass(file);
        KotlinClassHeader header = kotlinJvmBinaryClass != null ? kotlinJvmBinaryClass.getClassHeader() : null;
        return header != null && Intrinsics.areEqual((Object)((Object)header.getSyntheticClassKind()), (Object)((Object)JvmAnnotationNames.KotlinSyntheticClass.Kind.TRAIT_IMPL)) ^ true && Intrinsics.areEqual((Object)((Object)header.getSyntheticClassKind()), (Object)((Object)JvmAnnotationNames.KotlinSyntheticClass.Kind.LOCAL_TRAIT_IMPL)) ^ true;
    }

    public static final boolean isKotlinJsMetaFile(@JetValueParameter(name="file") @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getFileType(), (Object)KotlinJavaScriptMetaFileType.INSTANCE$);
    }

    public static final boolean isKotlinWithCompatibleAbiVersion(@JetValueParameter(name="file") @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!DecompilerPackage$DecompiledUtils$cecda1c3.isKotlinJvmCompiledFile(file)) {
            return false;
        }
        KotlinJvmBinaryClass kotlinJvmBinaryClass = KotlinBinaryClassCache.getKotlinBinaryClass(file);
        KotlinClassHeader header = kotlinJvmBinaryClass != null ? kotlinJvmBinaryClass.getClassHeader() : null;
        return header != null && header.getIsCompatibleAbiVersion();
    }

    public static final boolean isKotlinInternalCompiledFile(@JetValueParameter(name="file") @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!DecompilerPackage$DecompiledUtils$cecda1c3.isKotlinJvmCompiledFile(file)) {
            return false;
        }
        if (ClassFileViewProvider.isInnerClass((VirtualFile)file)) {
            return true;
        }
        Object object = KotlinBinaryClassCache.getKotlinBinaryClass(file);
        if (object == null || (object = object.getClassHeader()) == null) {
            return false;
        }
        Object header = object;
        return Intrinsics.areEqual((Object)((Object)((KotlinClassHeader)header).getKind()), (Object)((Object)KotlinClassHeader.Kind.SYNTHETIC_CLASS)) || Intrinsics.areEqual((Object)((Object)((KotlinClassHeader)header).getKind()), (Object)((Object)KotlinClassHeader.Kind.CLASS)) && ((KotlinClassHeader)header).getClassKind() != null && Intrinsics.areEqual((Object)((Object)((KotlinClassHeader)header).getClassKind()), (Object)((Object)JvmAnnotationNames.KotlinClass.Kind.CLASS)) ^ true;
    }

    public static final boolean isKotlinJavaScriptInternalCompiledFile(@JetValueParameter(name="file") @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return DecompilerPackage$DecompiledUtils$cecda1c3.isKotlinJsMetaFile(file) && KotlinPackage.contains$default((String)file.getNameWithoutExtension(), (char)'.', (boolean)false, (int)2);
    }
}

