/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetWhenEntry;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.psi.PsiPackage;

public class AddWhenElseBranchFix
extends JetIntentionAction<JetWhenExpression> {
    private static final String ELSE_ENTRY_TEXT = "else -> {}";

    public AddWhenElseBranchFix(@NotNull JetWhenExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/AddWhenElseBranchFix", "<init>"));
        }
        super(element);
    }

    @NotNull
    public String getText() {
        String string = JetBundle.message("add.when.else.branch.action", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddWhenElseBranchFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("add.when.else.branch.action.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddWhenElseBranchFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/AddWhenElseBranchFix", "isAvailable"));
        }
        return super.isAvailable(project, editor, file) && ((JetWhenExpression)this.element).getCloseBrace() != null;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/AddWhenElseBranchFix", "invoke"));
        }
        PsiElement whenCloseBrace = ((JetWhenExpression)this.element).getCloseBrace();
        assert (whenCloseBrace != null) : "isAvailable should check if close brace exist";
        JetPsiFactory psiFactory = PsiPackage.JetPsiFactory((PsiElement)file);
        JetWhenEntry entry = psiFactory.createWhenEntry(ELSE_ENTRY_TEXT);
        PsiElement insertedBranch = ((JetWhenExpression)this.element).addBefore((PsiElement)entry, whenCloseBrace);
        ((JetWhenExpression)this.element).addAfter(psiFactory.createNewLine(), insertedBranch);
        JetWhenEntry insertedWhenEntry = (JetWhenEntry)CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement((PsiElement)insertedBranch);
        TextRange textRange = insertedWhenEntry.getTextRange();
        int indexOfOpenBrace = insertedWhenEntry.getText().indexOf(123);
        editor.getCaretModel().moveToOffset(textRange.getStartOffset() + indexOfOpenBrace + 1);
    }

    public static JetSingleIntentionActionFactory createFactory() {
        return new JetSingleIntentionActionFactory(){

            @Override
            @Nullable
            public JetIntentionAction createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/AddWhenElseBranchFix$1", "createAction"));
                }
                PsiElement element = diagnostic.getPsiElement();
                JetWhenExpression whenExpression2 = (JetWhenExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JetWhenExpression.class, (boolean)false);
                if (whenExpression2 == null) {
                    return null;
                }
                return new AddWhenElseBranchFix(whenExpression2);
            }
        };
    }
}

