/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionReturnTypeFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeParameterTypeFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeVariableTypeFix;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

public class ChangeFunctionLiteralReturnTypeFix
extends JetIntentionAction<JetFunctionLiteralExpression> {
    private final JetType type;
    private final JetTypeReference functionLiteralReturnTypeRef;
    private IntentionAction appropriateQuickFix;

    public ChangeFunctionLiteralReturnTypeFix(@NotNull JetFunctionLiteralExpression functionLiteralExpression, @NotNull JetType type2) {
        JetTypeReference parentFunctionReturnTypeRef;
        JetType parentFunctionReturnType;
        ValueArgument valueArgument;
        JetParameter correspondingParameter;
        if (functionLiteralExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionLiteralExpression", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix", "<init>"));
        }
        super(functionLiteralExpression);
        this.appropriateQuickFix = null;
        this.type = type2;
        this.functionLiteralReturnTypeRef = functionLiteralExpression.getFunctionLiteral().getTypeReference();
        BindingContext context2 = ResolvePackage.analyzeFully(functionLiteralExpression.getContainingJetFile());
        JetType functionLiteralType = context2.getType(functionLiteralExpression);
        assert (functionLiteralType != null) : "Type of function literal not available in binding context";
        ClassDescriptor functionClass = KotlinBuiltIns.getInstance().getFunction(functionLiteralType.getArguments().size() - 1);
        LinkedList<JetType> functionClassTypeParameters = new LinkedList<JetType>();
        for (TypeProjection typeProjection : functionLiteralType.getArguments()) {
            functionClassTypeParameters.add(typeProjection.getType());
        }
        functionClassTypeParameters.remove(functionClassTypeParameters.size() - 1);
        functionClassTypeParameters.add(type2);
        JetType eventualFunctionLiteralType = TypeUtils.substituteParameters(functionClass, functionClassTypeParameters);
        JetProperty correspondingProperty = (JetProperty)PsiTreeUtil.getParentOfType((PsiElement)functionLiteralExpression, JetProperty.class);
        if (correspondingProperty != null && QuickFixUtil.canEvaluateTo(correspondingProperty.getInitializer(), functionLiteralExpression)) {
            JetTypeReference correspondingPropertyTypeRef = correspondingProperty.getTypeReference();
            JetType propertyType = context2.get(BindingContext.TYPE, correspondingPropertyTypeRef);
            if (propertyType != null && !JetTypeChecker.DEFAULT.isSubtypeOf(eventualFunctionLiteralType, propertyType)) {
                this.appropriateQuickFix = new ChangeVariableTypeFix(correspondingProperty, eventualFunctionLiteralType);
            }
            return;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getParentResolvedCall(functionLiteralExpression, context2, true);
        if (resolvedCall != null && (correspondingParameter = QuickFixUtil.getParameterDeclarationForValueArgument(resolvedCall, valueArgument = CallUtilPackage.getValueArgumentForExpression(resolvedCall.getCall(), functionLiteralExpression))) != null) {
            JetTypeReference correspondingParameterTypeRef = correspondingParameter.getTypeReference();
            JetType parameterType = context2.get(BindingContext.TYPE, correspondingParameterTypeRef);
            if (parameterType != null && !JetTypeChecker.DEFAULT.isSubtypeOf(eventualFunctionLiteralType, parameterType)) {
                this.appropriateQuickFix = new ChangeParameterTypeFix(correspondingParameter, eventualFunctionLiteralType);
            }
            return;
        }
        JetFunction parentFunction = (JetFunction)PsiTreeUtil.getParentOfType((PsiElement)functionLiteralExpression, JetFunction.class, (boolean)true);
        if (parentFunction != null && QuickFixUtil.canFunctionOrGetterReturnExpression(parentFunction, functionLiteralExpression) && (parentFunctionReturnType = context2.get(BindingContext.TYPE, parentFunctionReturnTypeRef = parentFunction.getTypeReference())) != null && !JetTypeChecker.DEFAULT.isSubtypeOf(eventualFunctionLiteralType, parentFunctionReturnType)) {
            this.appropriateQuickFix = new ChangeFunctionReturnTypeFix(parentFunction, eventualFunctionLiteralType);
        }
    }

    @NotNull
    public String getText() {
        if (this.appropriateQuickFix != null) {
            String string = this.appropriateQuickFix.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix", "getText"));
            }
            return string;
        }
        String string = JetBundle.message("change.function.literal.return.type", IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.renderType(this.type));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("change.type.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix", "isAvailable"));
        }
        return super.isAvailable(project, editor, file) && (this.functionLiteralReturnTypeRef != null || this.appropriateQuickFix != null && this.appropriateQuickFix.isAvailable(project, editor, file));
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix", "invoke"));
        }
        if (this.functionLiteralReturnTypeRef != null) {
            JetTypeReference newTypeRef = PsiPackage.JetPsiFactory((PsiElement)file).createType(IdeDescriptorRenderers.SOURCE_CODE.renderType(this.type));
            newTypeRef = (JetTypeReference)this.functionLiteralReturnTypeRef.replace((PsiElement)newTypeRef);
            ShortenReferences.DEFAULT.process(newTypeRef);
        }
        if (this.appropriateQuickFix != null && this.appropriateQuickFix.isAvailable(project, editor, (PsiFile)file)) {
            this.appropriateQuickFix.invoke(project, editor, (PsiFile)file);
        }
    }

    @NotNull
    public static JetSingleIntentionActionFactory createFactoryForExpectedOrAssignmentTypeMismatch() {
        JetSingleIntentionActionFactory jetSingleIntentionActionFactory = new JetSingleIntentionActionFactory(){

            @Override
            @Nullable
            public IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix$1", "createAction"));
                }
                JetFunctionLiteralExpression functionLiteralExpression = QuickFixUtil.getParentElementOfType(diagnostic, JetFunctionLiteralExpression.class);
                if (functionLiteralExpression == null) {
                    return null;
                }
                return new ChangeFunctionLiteralReturnTypeFix(functionLiteralExpression, KotlinBuiltIns.getInstance().getUnitType());
            }
        };
        if (jetSingleIntentionActionFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix", "createFactoryForExpectedOrAssignmentTypeMismatch"));
        }
        return jetSingleIntentionActionFactory;
    }
}

