/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.JetLanguage;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetVisitor;

public class JetElementImpl
extends ASTWrapperPsiElement
implements JetElement {
    public JetElementImpl(@NotNull ASTNode node2) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetElementImpl", "<init>"));
        }
        super(node2);
    }

    @NotNull
    public Language getLanguage() {
        JetLanguage jetLanguage = JetLanguage.INSTANCE;
        if (jetLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetElementImpl", "getLanguage"));
        }
        return jetLanguage;
    }

    public String toString() {
        return this.getNode().getElementType().toString();
    }

    public final void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetElementImpl", "accept"));
        }
        if (visitor2 instanceof JetVisitor) {
            this.accept((JetVisitor)visitor2, null);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    @Override
    @NotNull
    public JetFile getContainingJetFile() {
        PsiFile file = this.getContainingFile();
        assert (file instanceof JetFile) : "JetElement not inside JetFile: " + file + " " + file.getText();
        JetFile jetFile = (JetFile)file;
        if (jetFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetElementImpl", "getContainingJetFile"));
        }
        return jetFile;
    }

    @Override
    public <D> void acceptChildren(@NotNull JetVisitor<Void, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetElementImpl", "acceptChildren"));
        }
        JetPsiUtil.visitChildren(this, visitor2, data2);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetElementImpl", "accept"));
        }
        return visitor2.visitJetElement(this, data2);
    }

    public PsiReference getReference() {
        PsiReference[] references = this.getReferences();
        if (references.length == 1) {
            return references[0];
        }
        return null;
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, (PsiReferenceService.Hints)PsiReferenceService.Hints.NO_HINTS);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetElementImpl", "getReferences"));
        }
        return psiReferenceArray;
    }
}

