/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.idea.JetFileType;
import org.jetbrains.kotlin.idea.JetLanguage;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetAnnotated;
import org.jetbrains.kotlin.psi.JetAnnotation;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDeclarationContainer;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetElementImplStub;
import org.jetbrains.kotlin.psi.JetFileAnnotationList;
import org.jetbrains.kotlin.psi.JetImportDirective;
import org.jetbrains.kotlin.psi.JetImportList;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetPackageDirective;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetScript;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetPlaceHolderStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;

public class JetFile
extends PsiFileBase
implements JetDeclarationContainer,
JetAnnotated,
JetElement,
PsiClassOwner {
    private final boolean isCompiled;

    public JetFile(FileViewProvider viewProvider, boolean compiled) {
        super(viewProvider, (Language)JetLanguage.INSTANCE);
        this.isCompiled = compiled;
    }

    public FileASTNode getNode() {
        return super.getNode();
    }

    public boolean isCompiled() {
        return this.isCompiled;
    }

    @NotNull
    public FileType getFileType() {
        JetFileType jetFileType = JetFileType.INSTANCE;
        if (jetFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetFile", "getFileType"));
        }
        return jetFileType;
    }

    public String toString() {
        return "JetFile: " + this.getName();
    }

    @Override
    @NotNull
    public List<JetDeclaration> getDeclarations() {
        KotlinFileStub stub = this.getStub();
        if (stub != null) {
            List<PsiElement> list = Arrays.asList(stub.getChildrenByType(JetStubElementTypes.DECLARATION_TYPES, JetDeclaration.ARRAY_FACTORY));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetFile", "getDeclarations"));
            }
            return list;
        }
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, JetDeclaration.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetFile", "getDeclarations"));
        }
        return list;
    }

    @Nullable
    public JetImportList getImportList() {
        return this.findChildByTypeOrClass(JetStubElementTypes.IMPORT_LIST, JetImportList.class);
    }

    @Nullable
    public JetFileAnnotationList getFileAnnotationList() {
        return this.findChildByTypeOrClass(JetStubElementTypes.FILE_ANNOTATION_LIST, JetFileAnnotationList.class);
    }

    @Nullable
    public <T extends JetElementImplStub<? extends StubElement<?>>> T findChildByTypeOrClass(@NotNull JetPlaceHolderStubElementType<T> elementType, @NotNull Class<T> elementClass) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/kotlin/psi/JetFile", "findChildByTypeOrClass"));
        }
        if (elementClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementClass", "org/jetbrains/kotlin/psi/JetFile", "findChildByTypeOrClass"));
        }
        KotlinFileStub stub = this.getStub();
        if (stub != null) {
            StubElement importListStub = stub.findChildStubByType(elementType);
            return (T)(importListStub != null ? (JetElementImplStub)importListStub.getPsi() : null);
        }
        return (T)((JetElementImplStub)this.findChildByClass(elementClass));
    }

    @NotNull
    public List<JetImportDirective> getImportDirectives() {
        JetImportList importList = this.getImportList();
        List<JetImportDirective> list = importList != null ? importList.getImports() : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetFile", "getImportDirectives"));
        }
        return list;
    }

    @Nullable
    public JetImportDirective findImportByAlias(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/psi/JetFile", "findImportByAlias"));
        }
        for (JetImportDirective directive : this.getImportDirectives()) {
            if (!name2.equals(directive.getAliasName())) continue;
            return directive;
        }
        return null;
    }

    @Nullable
    public JetPackageDirective getPackageDirective() {
        KotlinFileStub stub = this.getStub();
        if (stub != null) {
            StubElement packageDirectiveStub = stub.findChildStubByType(JetStubElementTypes.PACKAGE_DIRECTIVE);
            return packageDirectiveStub != null ? (JetPackageDirective)packageDirectiveStub.getPsi() : null;
        }
        ASTNode ast = this.getNode().findChildByType(JetNodeTypes.PACKAGE_DIRECTIVE);
        return ast != null ? (JetPackageDirective)ast.getPsi() : null;
    }

    @Deprecated
    @NotNull
    public String getPackageName() {
        String string = this.getPackageFqName().asString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetFile", "getPackageName"));
        }
        return string;
    }

    @NotNull
    public FqName getPackageFqName() {
        KotlinFileStub stub = this.getStub();
        if (stub != null) {
            FqName fqName2 = stub.getPackageFqName();
            if (fqName2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetFile", "getPackageFqName"));
            }
            return fqName2;
        }
        FqName fqName3 = this.getPackageFqNameByTree();
        if (fqName3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetFile", "getPackageFqName"));
        }
        return fqName3;
    }

    @NotNull
    public FqName getPackageFqNameByTree() {
        JetPackageDirective packageDirective = this.getPackageDirective();
        if (packageDirective == null) {
            FqName fqName2 = FqName.ROOT;
            if (fqName2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetFile", "getPackageFqNameByTree"));
            }
            return fqName2;
        }
        FqName fqName3 = packageDirective.getFqName();
        if (fqName3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetFile", "getPackageFqNameByTree"));
        }
        return fqName3;
    }

    @Nullable
    public KotlinFileStub getStub() {
        return (KotlinFileStub)super.getStub();
    }

    @NotNull
    public PsiClass[] getClasses() {
        if (PsiClass.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetFile", "getClasses"));
        }
        return PsiClass.EMPTY_ARRAY;
    }

    public void setPackageName(String packageName) {
    }

    @Nullable
    public JetScript getScript() {
        return (JetScript)PsiTreeUtil.getChildOfType((PsiElement)this, JetScript.class);
    }

    public boolean isScript() {
        KotlinFileStub stub = this.getStub();
        if (stub != null) {
            return stub.isScript();
        }
        return this.isScriptByTree();
    }

    public boolean isScriptByTree() {
        return this.getScript() != null;
    }

    @NotNull
    public String getName() {
        String string = super.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetFile", "getName"));
        }
        return string;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetFile", "accept"));
        }
        if (visitor2 instanceof JetVisitor) {
            this.accept((JetVisitor)visitor2, null);
        } else {
            visitor2.visitFile((PsiFile)this);
        }
    }

    @Override
    @NotNull
    public JetFile getContainingJetFile() {
        JetFile jetFile = this;
        if (jetFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetFile", "getContainingJetFile"));
        }
        return jetFile;
    }

    @Override
    public <D> void acceptChildren(@NotNull JetVisitor<Void, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetFile", "acceptChildren"));
        }
        JetPsiUtil.visitChildren(this, visitor2, data2);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetFile", "accept"));
        }
        return visitor2.visitJetFile(this, data2);
    }

    @Override
    @NotNull
    public List<JetAnnotation> getAnnotations() {
        JetFileAnnotationList fileAnnotationList = this.getFileAnnotationList();
        if (fileAnnotationList == null) {
            List<JetAnnotation> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetFile", "getAnnotations"));
            }
            return list;
        }
        List<JetAnnotation> list = fileAnnotationList.getAnnotations();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetFile", "getAnnotations"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<JetAnnotationEntry> getAnnotationEntries() {
        JetFileAnnotationList fileAnnotationList = this.getFileAnnotationList();
        if (fileAnnotationList == null) {
            List<JetAnnotationEntry> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetFile", "getAnnotationEntries"));
            }
            return list;
        }
        List<JetAnnotationEntry> list = fileAnnotationList.getAnnotationEntries();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetFile", "getAnnotationEntries"));
        }
        return list;
    }

    @NotNull
    public List<JetAnnotationEntry> getDanglingAnnotations() {
        KotlinFileStub stub = this.getStub();
        Object[] danglingModifierLists = stub == null ? (JetModifierList[])this.findChildrenByClass(JetModifierList.class) : (JetModifierList[])stub.getChildrenByType((IElementType)JetStubElementTypes.MODIFIER_LIST, JetStubElementTypes.MODIFIER_LIST.getArrayFactory());
        List list = KotlinPackage.flatMap((Object[])danglingModifierLists, (Function1)new Function1<JetModifierList, Iterable<JetAnnotationEntry>>(){

            public Iterable<JetAnnotationEntry> invoke(JetModifierList modifierList) {
                return modifierList.getAnnotationEntries();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetFile", "getDanglingAnnotations"));
        }
        return list;
    }
}

