/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.JetImportDirective;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.resolve.ImportPath;

public class JetImportsFactory {
    private Project project;
    private final Map<ImportPath, JetImportDirective> importsCache = Maps.newHashMap();

    @Inject
    public void setProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/psi/JetImportsFactory", "setProject"));
        }
        this.importsCache.clear();
        this.project = project;
    }

    @NotNull
    public JetImportDirective createImportDirective(@NotNull ImportPath importPath) {
        if (importPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importPath", "org/jetbrains/kotlin/psi/JetImportsFactory", "createImportDirective"));
        }
        JetImportDirective directive = this.importsCache.get(importPath);
        if (directive != null) {
            JetImportDirective jetImportDirective = directive;
            if (jetImportDirective == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetImportsFactory", "createImportDirective"));
            }
            return jetImportDirective;
        }
        JetImportDirective createdDirective = PsiPackage.JetPsiFactory(this.project).createImportDirective(importPath);
        this.importsCache.put(importPath, createdDirective);
        JetImportDirective jetImportDirective = createdDirective;
        if (jetImportDirective == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetImportsFactory", "createImportDirective"));
        }
        return jetImportDirective;
    }

    @NotNull
    public Collection<JetImportDirective> createImportDirectives(@NotNull Collection<ImportPath> importPaths) {
        if (importPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importPaths", "org/jetbrains/kotlin/psi/JetImportsFactory", "createImportDirectives"));
        }
        Collection collection = Collections2.transform(importPaths, (Function)new Function<ImportPath, JetImportDirective>(){

            public JetImportDirective apply(@Nullable ImportPath path) {
                assert (path != null);
                return JetImportsFactory.this.createImportDirective(path);
            }
        });
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetImportsFactory", "createImportDirectives"));
        }
        return collection;
    }
}

