/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.stubs.KotlinAnnotationEntryStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexServiceFactory;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinAnnotationEntryStubImpl;

public class JetAnnotationEntryElementType
extends JetStubElementType<KotlinAnnotationEntryStub, JetAnnotationEntry> {
    public JetAnnotationEntryElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/psi/stubs/elements/JetAnnotationEntryElementType", "<init>"));
        }
        super(debugName, JetAnnotationEntry.class, KotlinAnnotationEntryStub.class);
    }

    public KotlinAnnotationEntryStub createStub(@NotNull JetAnnotationEntry psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/kotlin/psi/stubs/elements/JetAnnotationEntryElementType", "createStub"));
        }
        Name shortName = JetPsiUtil.getShortName(psi);
        String resultName = shortName != null ? shortName.asString() : psi.getText();
        boolean hasValueArguments = psi.getValueArgumentList() != null;
        return new KotlinAnnotationEntryStubImpl((StubElement<? extends PsiElement>)parentStub, StringRef.fromString((String)resultName), hasValueArguments);
    }

    public void serialize(@NotNull KotlinAnnotationEntryStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/stubs/elements/JetAnnotationEntryElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/psi/stubs/elements/JetAnnotationEntryElementType", "serialize"));
        }
        dataStream.writeName(stub.getShortName());
        dataStream.writeBoolean(stub.hasValueArguments());
    }

    @NotNull
    public KotlinAnnotationEntryStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/psi/stubs/elements/JetAnnotationEntryElementType", "deserialize"));
        }
        StringRef text = dataStream.readName();
        boolean hasValueArguments = dataStream.readBoolean();
        KotlinAnnotationEntryStubImpl kotlinAnnotationEntryStubImpl = new KotlinAnnotationEntryStubImpl((StubElement<? extends PsiElement>)parentStub, text, hasValueArguments);
        if (kotlinAnnotationEntryStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/stubs/elements/JetAnnotationEntryElementType", "deserialize"));
        }
        return kotlinAnnotationEntryStubImpl;
    }

    @Override
    public void indexStub(@NotNull KotlinAnnotationEntryStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/stubs/elements/JetAnnotationEntryElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/kotlin/psi/stubs/elements/JetAnnotationEntryElementType", "indexStub"));
        }
        StubIndexServiceFactory.getInstance().indexAnnotation(stub, sink);
    }
}

