/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.intention;

import com.intellij.codeInsight.daemon.quickFix.ExternalLibraryDescriptor;
import com.intellij.codeInsight.daemon.quickFix.ExternalLibraryResolver;
import com.intellij.openapi.module.Module;
import com.intellij.util.PathUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testng.annotations.Test;

public class TestNGExternalLibraryResolver
extends ExternalLibraryResolver {
    private static final Set<String> TEST_NG_ANNOTATIONS = ContainerUtil.set((Object[])new String[]{"Test", "BeforeClass", "BeforeGroups", "BeforeMethod", "BeforeSuite", "BeforeTest", "AfterClass", "AfterGroups", "AfterMethod", "AfterSuite", "AfterTest", "Configuration"});
    private static final ExternalLibraryDescriptor TESTNG_DESCRIPTOR = new ExternalLibraryDescriptor("org.testng", "testng", null){

        @NotNull
        public List<String> locateLibraryClassesRoots(@NotNull Module contextModule) {
            if (contextModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextModule", "com/theoryinpractice/testng/intention/TestNGExternalLibraryResolver$1", "locateLibraryClassesRoots"));
            }
            List<String> list = Collections.singletonList(PathUtil.getJarPathForClass(Test.class));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/intention/TestNGExternalLibraryResolver$1", "locateLibraryClassesRoots"));
            }
            return list;
        }
    };

    @Nullable
    public ExternalLibraryResolver.ExternalClassResolveResult resolveClass(@NotNull String shortClassName, @NotNull ThreeState isAnnotation) {
        if (shortClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortClassName", "com/theoryinpractice/testng/intention/TestNGExternalLibraryResolver", "resolveClass"));
        }
        if (isAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isAnnotation", "com/theoryinpractice/testng/intention/TestNGExternalLibraryResolver", "resolveClass"));
        }
        if (TEST_NG_ANNOTATIONS.contains(shortClassName)) {
            return new ExternalLibraryResolver.ExternalClassResolveResult("org.testng.annotations." + shortClassName, TESTNG_DESCRIPTOR);
        }
        return null;
    }
}

