/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.annotations.NonNull;
import com.android.ddmlib.Client;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.DeviceMonitor;
import com.android.ddmlib.HandleAppName;
import com.android.ddmlib.HandleHeap;
import com.android.ddmlib.HandleHello;
import com.android.ddmlib.HandleNativeHeap;
import com.android.ddmlib.HandleProfiling;
import com.android.ddmlib.HandleTest;
import com.android.ddmlib.HandleThread;
import com.android.ddmlib.HandleViewDebug;
import com.android.ddmlib.HandleWait;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.MonitorThread;
import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class AndroidDebugBridge {
    private static final int ADB_VERSION_MICRO_MIN = 20;
    private static final int ADB_VERSION_MICRO_MAX = -1;
    private static final Pattern sAdbVersion = Pattern.compile("^.*(\\d+)\\.(\\d+)\\.(\\d+)$");
    private static final String ADB = "adb";
    private static final String DDMS = "ddms";
    private static final String SERVER_PORT_ENV_VAR = "ANDROID_ADB_SERVER_PORT";
    static final String DEFAULT_ADB_HOST = "127.0.0.1";
    static final int DEFAULT_ADB_PORT = 5037;
    private static int sAdbServerPort = 0;
    private static InetAddress sHostAddr;
    private static InetSocketAddress sSocketAddr;
    private static AndroidDebugBridge sThis;
    private static boolean sInitialized;
    private static boolean sClientSupport;
    private String mAdbOsLocation = null;
    private boolean mVersionCheck;
    private boolean mStarted = false;
    private DeviceMonitor mDeviceMonitor;
    private static final ArrayList<IDebugBridgeChangeListener> sBridgeListeners;
    private static final ArrayList<IDeviceChangeListener> sDeviceListeners;
    private static final ArrayList<IClientChangeListener> sClientListeners;
    private static final Object sLock;

    public static synchronized void initIfNeeded(boolean clientSupport) {
        if (sInitialized) {
            return;
        }
        AndroidDebugBridge.init(clientSupport);
    }

    public static synchronized void init(boolean clientSupport) {
        if (sInitialized) {
            throw new IllegalStateException("AndroidDebugBridge.init() has already been called.");
        }
        sInitialized = true;
        sClientSupport = clientSupport;
        AndroidDebugBridge.initAdbSocketAddr();
        MonitorThread monitorThread = MonitorThread.createInstance();
        monitorThread.start();
        HandleHello.register(monitorThread);
        HandleAppName.register(monitorThread);
        HandleTest.register(monitorThread);
        HandleThread.register(monitorThread);
        HandleHeap.register(monitorThread);
        HandleWait.register(monitorThread);
        HandleProfiling.register(monitorThread);
        HandleNativeHeap.register(monitorThread);
        HandleViewDebug.register(monitorThread);
    }

    public static synchronized void terminate() {
        MonitorThread monitorThread;
        if (sThis != null && AndroidDebugBridge.sThis.mDeviceMonitor != null) {
            AndroidDebugBridge.sThis.mDeviceMonitor.stop();
            AndroidDebugBridge.sThis.mDeviceMonitor = null;
        }
        if ((monitorThread = MonitorThread.getInstance()) != null) {
            monitorThread.quit();
        }
        sInitialized = false;
    }

    static boolean getClientSupport() {
        return sClientSupport;
    }

    public static InetSocketAddress getSocketAddress() {
        return sSocketAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AndroidDebugBridge createBridge() {
        Object object = sLock;
        synchronized (object) {
            IDebugBridgeChangeListener[] listenersCopy;
            if (sThis != null) {
                return sThis;
            }
            try {
                sThis = new AndroidDebugBridge();
                sThis.start();
            }
            catch (InvalidParameterException e) {
                sThis = null;
            }
            for (IDebugBridgeChangeListener listener : listenersCopy = sBridgeListeners.toArray(new IDebugBridgeChangeListener[sBridgeListeners.size()])) {
                try {
                    listener.bridgeChanged(sThis);
                }
                catch (Exception e) {
                    Log.e(DDMS, e);
                }
            }
            return sThis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AndroidDebugBridge createBridge(String osLocation, boolean forceNewBridge) {
        Object object = sLock;
        synchronized (object) {
            IDebugBridgeChangeListener[] listenersCopy;
            if (sThis != null) {
                if (AndroidDebugBridge.sThis.mAdbOsLocation != null && AndroidDebugBridge.sThis.mAdbOsLocation.equals(osLocation) && !forceNewBridge) {
                    return sThis;
                }
                sThis.stop();
            }
            try {
                sThis = new AndroidDebugBridge(osLocation);
                sThis.start();
            }
            catch (InvalidParameterException e) {
                sThis = null;
            }
            for (IDebugBridgeChangeListener listener : listenersCopy = sBridgeListeners.toArray(new IDebugBridgeChangeListener[sBridgeListeners.size()])) {
                try {
                    listener.bridgeChanged(sThis);
                }
                catch (Exception e) {
                    Log.e(DDMS, e);
                }
            }
            return sThis;
        }
    }

    public static AndroidDebugBridge getBridge() {
        return sThis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disconnectBridge() {
        Object object = sLock;
        synchronized (object) {
            if (sThis != null) {
                IDebugBridgeChangeListener[] listenersCopy;
                sThis.stop();
                sThis = null;
                for (IDebugBridgeChangeListener listener : listenersCopy = sBridgeListeners.toArray(new IDebugBridgeChangeListener[sBridgeListeners.size()])) {
                    try {
                        listener.bridgeChanged(sThis);
                    }
                    catch (Exception e) {
                        Log.e(DDMS, e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDebugBridgeChangeListener(IDebugBridgeChangeListener listener) {
        Object object = sLock;
        synchronized (object) {
            if (!sBridgeListeners.contains(listener)) {
                sBridgeListeners.add(listener);
                if (sThis != null) {
                    try {
                        listener.bridgeChanged(sThis);
                    }
                    catch (Exception e) {
                        Log.e(DDMS, e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDebugBridgeChangeListener(IDebugBridgeChangeListener listener) {
        Object object = sLock;
        synchronized (object) {
            sBridgeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDeviceChangeListener(IDeviceChangeListener listener) {
        Object object = sLock;
        synchronized (object) {
            if (!sDeviceListeners.contains(listener)) {
                sDeviceListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDeviceChangeListener(IDeviceChangeListener listener) {
        Object object = sLock;
        synchronized (object) {
            sDeviceListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addClientChangeListener(IClientChangeListener listener) {
        Object object = sLock;
        synchronized (object) {
            if (!sClientListeners.contains(listener)) {
                sClientListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeClientChangeListener(IClientChangeListener listener) {
        Object object = sLock;
        synchronized (object) {
            sClientListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDevice[] getDevices() {
        Object object = sLock;
        synchronized (object) {
            if (this.mDeviceMonitor != null) {
                return this.mDeviceMonitor.getDevices();
            }
        }
        return new IDevice[0];
    }

    public boolean hasInitialDeviceList() {
        if (this.mDeviceMonitor != null) {
            return this.mDeviceMonitor.hasInitialDeviceList();
        }
        return false;
    }

    public void setSelectedClient(Client selectedClient) {
        MonitorThread monitorThread = MonitorThread.getInstance();
        if (monitorThread != null) {
            monitorThread.setSelectedClient(selectedClient);
        }
    }

    public boolean isConnected() {
        MonitorThread monitorThread = MonitorThread.getInstance();
        if (this.mDeviceMonitor != null && monitorThread != null) {
            return this.mDeviceMonitor.isMonitoring() && monitorThread.getState() != Thread.State.TERMINATED;
        }
        return false;
    }

    public int getConnectionAttemptCount() {
        if (this.mDeviceMonitor != null) {
            return this.mDeviceMonitor.getConnectionAttemptCount();
        }
        return -1;
    }

    public int getRestartAttemptCount() {
        if (this.mDeviceMonitor != null) {
            return this.mDeviceMonitor.getRestartAttemptCount();
        }
        return -1;
    }

    private AndroidDebugBridge(String osLocation) throws InvalidParameterException {
        if (osLocation == null || osLocation.isEmpty()) {
            throw new InvalidParameterException();
        }
        this.mAdbOsLocation = osLocation;
        this.checkAdbVersion();
    }

    private AndroidDebugBridge() {
    }

    private void checkAdbVersion() {
        String line;
        int status;
        this.mVersionCheck = false;
        if (this.mAdbOsLocation == null) {
            return;
        }
        String[] command = new String[]{this.mAdbOsLocation, "version"};
        Log.d(DDMS, String.format("Checking '%1$s version'", this.mAdbOsLocation));
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            boolean exists = new File(this.mAdbOsLocation).exists();
            String msg = exists ? String.format("Unexpected exception '%1$s' while attempting to get adb version from '%2$s'", e.getMessage(), this.mAdbOsLocation) : "Unable to locate adb.\nPlease use SDK Manager and check if Android SDK platform-tools are installed.";
            Log.logAndDisplay(Log.LogLevel.ERROR, ADB, msg);
            return;
        }
        ArrayList<String> errorOutput = new ArrayList<String>();
        ArrayList<String> stdOutput = new ArrayList<String>();
        try {
            status = this.grabProcessOutput(process, errorOutput, stdOutput, true);
        }
        catch (InterruptedException e) {
            return;
        }
        if (status != 0) {
            StringBuilder builder = new StringBuilder("'adb version' failed!");
            for (String error : errorOutput) {
                builder.append('\n');
                builder.append(error);
            }
            Log.logAndDisplay(Log.LogLevel.ERROR, ADB, builder.toString());
        }
        boolean versionFound = false;
        Iterator<String> iterator = stdOutput.iterator();
        while (iterator.hasNext() && !(versionFound = this.scanVersionLine(line = iterator.next()))) {
        }
        if (!versionFound) {
            iterator = errorOutput.iterator();
            while (iterator.hasNext() && !(versionFound = this.scanVersionLine(line = iterator.next()))) {
            }
        }
        if (!versionFound) {
            StringBuilder builder = new StringBuilder("Failed to parse the output of 'adb version':\n");
            builder.append("Standard Output was:\n");
            for (String line2 : stdOutput) {
                builder.append(line2);
                builder.append('\n');
            }
            builder.append("\nError Output was:\n");
            for (String line2 : errorOutput) {
                builder.append(line2);
                builder.append('\n');
            }
            Log.logAndDisplay(Log.LogLevel.ERROR, ADB, builder.toString());
        }
    }

    private boolean scanVersionLine(String line) {
        Matcher matcher;
        if (line != null && (matcher = sAdbVersion.matcher(line)).matches()) {
            int majorVersion = Integer.parseInt(matcher.group(1));
            int minorVersion = Integer.parseInt(matcher.group(2));
            int microVersion = Integer.parseInt(matcher.group(3));
            if (microVersion < 20) {
                String message = String.format("Required minimum version of adb: %1$d.%2$d.%3$d.Current version is %1$d.%2$d.%4$d", majorVersion, minorVersion, 20, microVersion);
                Log.logAndDisplay(Log.LogLevel.ERROR, ADB, message);
            } else {
                this.mVersionCheck = true;
            }
            return true;
        }
        return false;
    }

    boolean start() {
        if (!(this.mAdbOsLocation == null || sAdbServerPort == 0 || this.mVersionCheck && this.startAdb())) {
            return false;
        }
        this.mStarted = true;
        this.mDeviceMonitor = new DeviceMonitor(this);
        this.mDeviceMonitor.start();
        return true;
    }

    boolean stop() {
        if (!this.mStarted) {
            return false;
        }
        if (this.mDeviceMonitor != null) {
            this.mDeviceMonitor.stop();
            this.mDeviceMonitor = null;
        }
        if (!this.stopAdb()) {
            return false;
        }
        this.mStarted = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restart() {
        if (this.mAdbOsLocation == null) {
            Log.e(ADB, "Cannot restart adb when AndroidDebugBridge is created without the location of adb.");
            return false;
        }
        if (sAdbServerPort == 0) {
            Log.e(ADB, "ADB server port for restarting AndroidDebugBridge is not set.");
            return false;
        }
        if (!this.mVersionCheck) {
            Log.logAndDisplay(Log.LogLevel.ERROR, ADB, "Attempting to restart adb, but version check failed!");
            return false;
        }
        AndroidDebugBridge androidDebugBridge = this;
        synchronized (androidDebugBridge) {
            this.stopAdb();
            boolean restart = this.startAdb();
            if (restart && this.mDeviceMonitor == null) {
                this.mDeviceMonitor = new DeviceMonitor(this);
                this.mDeviceMonitor.start();
            }
            return restart;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deviceConnected(IDevice device) {
        IDeviceChangeListener[] listenersCopy = null;
        IDeviceChangeListener[] iDeviceChangeListenerArray = sLock;
        synchronized (sLock) {
            listenersCopy = sDeviceListeners.toArray(new IDeviceChangeListener[sDeviceListeners.size()]);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (IDeviceChangeListener listener : listenersCopy) {
                try {
                    listener.deviceConnected(device);
                }
                catch (Exception e) {
                    Log.e(DDMS, e);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deviceDisconnected(IDevice device) {
        IDeviceChangeListener[] listenersCopy = null;
        IDeviceChangeListener[] iDeviceChangeListenerArray = sLock;
        synchronized (sLock) {
            listenersCopy = sDeviceListeners.toArray(new IDeviceChangeListener[sDeviceListeners.size()]);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (IDeviceChangeListener listener : listenersCopy) {
                try {
                    listener.deviceDisconnected(device);
                }
                catch (Exception e) {
                    Log.e(DDMS, e);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deviceChanged(IDevice device, int changeMask) {
        IDeviceChangeListener[] listenersCopy = null;
        IDeviceChangeListener[] iDeviceChangeListenerArray = sLock;
        synchronized (sLock) {
            listenersCopy = sDeviceListeners.toArray(new IDeviceChangeListener[sDeviceListeners.size()]);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            for (IDeviceChangeListener listener : listenersCopy) {
                try {
                    listener.deviceChanged(device, changeMask);
                }
                catch (Exception e) {
                    Log.e(DDMS, e);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clientChanged(Client client, int changeMask) {
        IClientChangeListener[] listenersCopy = null;
        IClientChangeListener[] iClientChangeListenerArray = sLock;
        synchronized (sLock) {
            listenersCopy = sClientListeners.toArray(new IClientChangeListener[sClientListeners.size()]);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            for (IClientChangeListener listener : listenersCopy) {
                try {
                    listener.clientChanged(client, changeMask);
                }
                catch (Exception e) {
                    Log.e(DDMS, e);
                }
            }
            return;
        }
    }

    DeviceMonitor getDeviceMonitor() {
        return this.mDeviceMonitor;
    }

    synchronized boolean startAdb() {
        if (this.mAdbOsLocation == null) {
            Log.e(ADB, "Cannot start adb when AndroidDebugBridge is created without the location of adb.");
            return false;
        }
        if (sAdbServerPort == 0) {
            Log.w(ADB, "ADB server port for starting AndroidDebugBridge is not set.");
            return false;
        }
        int status = -1;
        Object[] command = this.getAdbLaunchCommand("start-server");
        String commandString = Joiner.on((char)',').join(command);
        try {
            String adbHostValue;
            Log.d(DDMS, String.format("Launching '%1$s' to ensure ADB is running.", commandString));
            ProcessBuilder processBuilder = new ProcessBuilder((String[])command);
            if (DdmPreferences.getUseAdbHost() && (adbHostValue = DdmPreferences.getAdbHostValue()) != null && !adbHostValue.isEmpty()) {
                Map<String, String> env = processBuilder.environment();
                env.put("ADBHOST", adbHostValue);
            }
            Process proc = processBuilder.start();
            ArrayList<String> errorOutput = new ArrayList<String>();
            ArrayList<String> stdOutput = new ArrayList<String>();
            status = this.grabProcessOutput(proc, errorOutput, stdOutput, false);
        }
        catch (IOException ioe) {
            Log.e(DDMS, "Unable to run 'adb': " + ioe.getMessage());
        }
        catch (InterruptedException ie) {
            Log.e(DDMS, "Unable to run 'adb': " + ie.getMessage());
        }
        if (status != 0) {
            Log.e(DDMS, String.format("'%1$s' failed -- run manually if necessary", commandString));
            return false;
        }
        Log.d(DDMS, String.format("'%1$s' succeeded", commandString));
        return true;
    }

    private String[] getAdbLaunchCommand(String option) {
        ArrayList<String> command = new ArrayList<String>(4);
        command.add(this.mAdbOsLocation);
        if (sAdbServerPort != 5037) {
            command.add("-P");
            command.add(Integer.toString(sAdbServerPort));
        }
        command.add(option);
        return command.toArray(new String[command.size()]);
    }

    private synchronized boolean stopAdb() {
        if (this.mAdbOsLocation == null) {
            Log.e(ADB, "Cannot stop adb when AndroidDebugBridge is created without the location of adb.");
            return false;
        }
        if (sAdbServerPort == 0) {
            Log.e(ADB, "ADB server port for restarting AndroidDebugBridge is not set");
            return false;
        }
        int status = -1;
        Object[] command = this.getAdbLaunchCommand("kill-server");
        try {
            Process proc = Runtime.getRuntime().exec((String[])command);
            status = proc.waitFor();
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String commandString = Joiner.on((char)',').join(command);
        if (status != 0) {
            Log.w(DDMS, String.format("'%1$s' failed -- run manually if necessary", commandString));
            return false;
        }
        Log.d(DDMS, String.format("'%1$s' succeeded", commandString));
        return true;
    }

    private int grabProcessOutput(final Process process, final ArrayList<String> errorOutput, final ArrayList<String> stdOutput, boolean waitForReaders) throws InterruptedException {
        assert (errorOutput != null);
        assert (stdOutput != null);
        Thread t1 = new Thread(""){

            @Override
            public void run() {
                InputStreamReader is = new InputStreamReader(process.getErrorStream());
                BufferedReader errReader = new BufferedReader(is);
                try {
                    String line;
                    while ((line = errReader.readLine()) != null) {
                        Log.e(AndroidDebugBridge.ADB, line);
                        errorOutput.add(line);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        Thread t2 = new Thread(""){

            @Override
            public void run() {
                InputStreamReader is = new InputStreamReader(process.getInputStream());
                BufferedReader outReader = new BufferedReader(is);
                try {
                    String line;
                    while ((line = outReader.readLine()) != null) {
                        Log.d(AndroidDebugBridge.ADB, line);
                        stdOutput.add(line);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        t1.start();
        t2.start();
        if (waitForReaders) {
            try {
                t1.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                t2.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return process.waitFor();
    }

    static Object getLock() {
        return sLock;
    }

    private static void initAdbSocketAddr() {
        try {
            sAdbServerPort = AndroidDebugBridge.getAdbServerPort();
            sHostAddr = InetAddress.getByName(DEFAULT_ADB_HOST);
            sSocketAddr = new InetSocketAddress(sHostAddr, sAdbServerPort);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    private static int getAdbServerPort() {
        String msg;
        Integer prop = Integer.getInteger(SERVER_PORT_ENV_VAR);
        if (prop != null) {
            try {
                return AndroidDebugBridge.validateAdbServerPort(prop.toString());
            }
            catch (IllegalArgumentException e) {
                msg = String.format("Invalid value (%1$s) for ANDROID_ADB_SERVER_PORT system property.", prop);
                Log.w(DDMS, msg);
            }
        }
        try {
            String env = System.getenv(SERVER_PORT_ENV_VAR);
            if (env != null) {
                return AndroidDebugBridge.validateAdbServerPort(env);
            }
        }
        catch (SecurityException ex) {
            Log.w(DDMS, "No access to env variables allowed by current security manager. If you've set ANDROID_ADB_SERVER_PORT: it's being ignored.");
        }
        catch (IllegalArgumentException e) {
            msg = String.format("Invalid value (%1$s) for ANDROID_ADB_SERVER_PORT environment variable (%2$s).", prop, e.getMessage());
            Log.w(DDMS, msg);
        }
        return 5037;
    }

    private static int validateAdbServerPort(@NonNull String adbServerPort) throws IllegalArgumentException {
        try {
            int port = Integer.decode(adbServerPort);
            if (port <= 0 || port >= 65535) {
                throw new IllegalArgumentException("Should be > 0 and < 65535");
            }
            return port;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Not a valid port number");
        }
    }

    static {
        sInitialized = false;
        sBridgeListeners = new ArrayList();
        sDeviceListeners = new ArrayList();
        sClientListeners = new ArrayList();
        sLock = sBridgeListeners;
    }

    public static interface IClientChangeListener {
        public void clientChanged(Client var1, int var2);
    }

    public static interface IDeviceChangeListener {
        public void deviceConnected(IDevice var1);

        public void deviceDisconnected(IDevice var1);

        public void deviceChanged(IDevice var1, int var2);
    }

    public static interface IDebugBridgeChangeListener {
        public void bridgeChanged(AndroidDebugBridge var1);
    }
}

