/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.Interpreter;

public class ControlFlowGraph {
    private Map<AbstractInsnNode, Node> mNodeMap;
    private static Map<Object, String> sIds = null;
    private static int sNextId = 1;

    @NonNull
    public static ControlFlowGraph create(@Nullable ControlFlowGraph initial, @NonNull ClassNode classNode, @NonNull MethodNode method) throws AnalyzerException {
        final ControlFlowGraph graph = initial != null ? initial : new ControlFlowGraph();
        final InsnList instructions = method.instructions;
        graph.mNodeMap = Maps.newHashMapWithExpectedSize((int)instructions.size());
        Analyzer analyzer = new Analyzer((Interpreter)new BasicInterpreter()){

            protected void newControlFlowEdge(int insn, int successor) {
                AbstractInsnNode from = instructions.get(insn);
                AbstractInsnNode to = instructions.get(successor);
                graph.add(from, to);
            }

            protected boolean newControlFlowExceptionEdge(int insn, TryCatchBlockNode tcb) {
                AbstractInsnNode from = instructions.get(insn);
                graph.exception(from, tcb);
                return super.newControlFlowExceptionEdge(insn, tcb);
            }

            protected boolean newControlFlowExceptionEdge(int insn, int successor) {
                AbstractInsnNode from = instructions.get(insn);
                AbstractInsnNode to = instructions.get(successor);
                graph.exception(from, to);
                return super.newControlFlowExceptionEdge(insn, successor);
            }
        };
        analyzer.analyze(classNode.name, method);
        return graph;
    }

    protected void add(@NonNull AbstractInsnNode from, @NonNull AbstractInsnNode to) {
        this.getNode(from).addSuccessor(this.getNode(to));
    }

    protected void exception(@NonNull AbstractInsnNode from, @NonNull AbstractInsnNode to) {
    }

    protected void exception(@NonNull AbstractInsnNode from, @NonNull TryCatchBlockNode tcb) {
        LabelNode start = tcb.start;
        LabelNode end = tcb.end;
        Node handlerNode = this.getNode((AbstractInsnNode)tcb.handler);
        for (LabelNode curr = start; curr != end && curr != null; curr = curr.getNext()) {
            if (curr.getType() != 5) continue;
            if (tcb.type == null) {
                this.getNode((AbstractInsnNode)curr).addSuccessor(handlerNode);
            }
            this.getNode((AbstractInsnNode)curr).addExceptionPath(handlerNode);
        }
    }

    @NonNull
    public Node getNode(@NonNull AbstractInsnNode instruction) {
        Node node = this.mNodeMap.get(instruction);
        if (node == null) {
            node = new Node(instruction);
            this.mNodeMap.put(instruction, node);
        }
        return node;
    }

    @NonNull
    public String toString(@Nullable Node start) {
        AbstractInsnNode curr;
        StringBuilder sb = new StringBuilder(400);
        if (start != null) {
            curr = start.instruction;
        } else {
            if (this.mNodeMap.isEmpty()) {
                return "<empty>";
            }
            curr = this.mNodeMap.keySet().iterator().next();
            while (curr.getPrevious() != null) {
                curr = curr.getPrevious();
            }
        }
        while (curr != null) {
            Node node = this.mNodeMap.get(curr);
            if (node != null) {
                sb.append(node.toString(true));
            }
            curr = curr.getNext();
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(null);
    }

    private static String getId(Object object) {
        String id;
        if (sIds == null) {
            sIds = Maps.newHashMap();
        }
        if ((id = sIds.get(object)) == null) {
            id = Integer.toString(sNextId++);
            sIds.put(object, id);
        }
        return id;
    }

    public static class Node {
        public final AbstractInsnNode instruction;
        public final List<Node> successors = new ArrayList<Node>(2);
        public final List<Node> exceptions = new ArrayList<Node>(1);
        public int visit;

        public Node(@NonNull AbstractInsnNode instruction) {
            this.instruction = instruction;
        }

        void addSuccessor(@NonNull Node node) {
            if (!this.successors.contains(node)) {
                this.successors.add(node);
            }
        }

        void addExceptionPath(@NonNull Node node) {
            if (!this.exceptions.contains(node)) {
                this.exceptions.add(node);
            }
        }

        @NonNull
        public String toString(boolean includeAdjacent) {
            StringBuilder sb = new StringBuilder(100);
            sb.append(ControlFlowGraph.getId(this.instruction));
            sb.append(':');
            if (this.instruction instanceof LabelNode) {
                sb.append("LABEL");
            } else if (this.instruction instanceof LineNumberNode) {
                sb.append("LINENUMBER ").append(((LineNumberNode)this.instruction).line);
            } else if (this.instruction instanceof FrameNode) {
                sb.append("FRAME");
            } else {
                int opcode = this.instruction.getOpcode();
                boolean printed = false;
                try {
                    Class<?> cls = Class.forName("org.objectweb.asm.util");
                    Field field = cls.getField("OPCODES");
                    String[] OPCODES = (String[])field.get(null);
                    printed = true;
                    if (opcode > 0 && opcode <= OPCODES.length) {
                        sb.append(OPCODES[opcode]);
                        if (this.instruction.getType() == 5) {
                            sb.append('(').append(((MethodInsnNode)this.instruction).name).append(')');
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!printed) {
                    if (this.instruction.getType() == 5) {
                        sb.append('(').append(((MethodInsnNode)this.instruction).name).append(')');
                    } else {
                        sb.append(this.instruction.toString());
                    }
                }
            }
            if (includeAdjacent) {
                if (this.successors != null && !this.successors.isEmpty()) {
                    sb.append(" Next:");
                    for (Node successor : this.successors) {
                        sb.append(' ');
                        sb.append(successor.toString(false));
                    }
                }
                if (this.exceptions != null && !this.exceptions.isEmpty()) {
                    sb.append(" Exceptions:");
                    for (Node exception : this.exceptions) {
                        sb.append(' ');
                        sb.append(exception.toString(false));
                    }
                }
                sb.append('\n');
            }
            return sb.toString();
        }
    }
}

