/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.configurations.DeviceMenuAction;
import com.android.tools.idea.wizard.FormFactorApiComboBox;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormFactorUtils {
    public static final String INCLUDE_FORM_FACTOR = "included";
    public static final String ATTR_MODULE_NAME = "projectName";

    public static ScopedStateStore.Key<FormFactorApiComboBox.AndroidTargetComboBoxItem> getTargetComboBoxKey(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/wizard/FormFactorUtils", "getTargetComboBoxKey"));
        }
        return ScopedStateStore.createKey(formFactor.id + "minApi" + "combo", ScopedStateStore.Scope.STEP, FormFactorApiComboBox.AndroidTargetComboBoxItem.class);
    }

    public static ScopedStateStore.Key<Integer> getMinApiLevelKey(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/wizard/FormFactorUtils", "getMinApiLevelKey"));
        }
        return ScopedStateStore.createKey(formFactor.id + "minApiLevel", ScopedStateStore.Scope.WIZARD, Integer.class);
    }

    public static ScopedStateStore.Key<String> getMinApiKey(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/wizard/FormFactorUtils", "getMinApiKey"));
        }
        return ScopedStateStore.createKey(formFactor.id + "minApi", ScopedStateStore.Scope.WIZARD, String.class);
    }

    public static ScopedStateStore.Key<String> getBuildApiKey(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/wizard/FormFactorUtils", "getBuildApiKey"));
        }
        return ScopedStateStore.createKey(formFactor.id + "buildApiString", ScopedStateStore.Scope.WIZARD, String.class);
    }

    public static ScopedStateStore.Key<Integer> getTargetApiLevelKey(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/wizard/FormFactorUtils", "getTargetApiLevelKey"));
        }
        return ScopedStateStore.createKey(formFactor.id + "targetApi", ScopedStateStore.Scope.WIZARD, Integer.class);
    }

    public static ScopedStateStore.Key<String> getTargetApiStringKey(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/wizard/FormFactorUtils", "getTargetApiStringKey"));
        }
        return ScopedStateStore.createKey(formFactor.id + "targetApiString", ScopedStateStore.Scope.WIZARD, String.class);
    }

    public static ScopedStateStore.Key<Integer> getBuildApiLevelKey(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/wizard/FormFactorUtils", "getBuildApiLevelKey"));
        }
        return ScopedStateStore.createKey(formFactor.id + "buildApi", ScopedStateStore.Scope.WIZARD, Integer.class);
    }

    public static ScopedStateStore.Key<String> getLanguageLevelKey(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/wizard/FormFactorUtils", "getLanguageLevelKey"));
        }
        return ScopedStateStore.createKey(formFactor.id + "javaVersion", ScopedStateStore.Scope.WIZARD, String.class);
    }

    public static ScopedStateStore.Key<Boolean> getInclusionKey(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/wizard/FormFactorUtils", "getInclusionKey"));
        }
        return ScopedStateStore.createKey(formFactor.id + INCLUDE_FORM_FACTOR, ScopedStateStore.Scope.WIZARD, Boolean.class);
    }

    public static ScopedStateStore.Key<String> getModuleNameKey(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/wizard/FormFactorUtils", "getModuleNameKey"));
        }
        return ScopedStateStore.createKey(formFactor.id + ATTR_MODULE_NAME, ScopedStateStore.Scope.WIZARD, String.class);
    }

    public static Map<String, Object> scrubFormFactorPrefixes(@NotNull FormFactor formFactor, @NotNull Map<String, Object> values) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/wizard/FormFactorUtils", "scrubFormFactorPrefixes"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/android/tools/idea/wizard/FormFactorUtils", "scrubFormFactorPrefixes"));
        }
        HashMap toReturn = Maps.newHashMapWithExpectedSize((int)values.size());
        for (String key : values.keySet()) {
            if (key.startsWith(formFactor.id)) {
                toReturn.put(key.substring(formFactor.id.length()), values.get(key));
                continue;
            }
            toReturn.put(key, values.get(key));
        }
        return toReturn;
    }

    public static String getPropertiesComponentMinSdkKey(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/wizard/FormFactorUtils", "getPropertiesComponentMinSdkKey"));
        }
        return formFactor.id + "minApi";
    }

    @NotNull
    public static String getModuleName(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/wizard/FormFactorUtils", "getModuleName"));
        }
        String name = formFactor.id.replaceAll("[/\\\\?%*:|\"<>]", "");
        name = name.replaceAll("\\s", "_");
        String string = name.toLowerCase();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/FormFactorUtils", "getModuleName"));
        }
        return string;
    }

    public static Predicate<FormFactorApiComboBox.AndroidTargetComboBoxItem> getMinSdkComboBoxFilter(final @NotNull FormFactor formFactor, final int minSdkLevel) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/wizard/FormFactorUtils", "getMinSdkComboBoxFilter"));
        }
        return new Predicate<FormFactorApiComboBox.AndroidTargetComboBoxItem>(){

            public boolean apply(@Nullable FormFactorApiComboBox.AndroidTargetComboBoxItem input) {
                if (input == null) {
                    return false;
                }
                if (!formFactor.myApiWhitelist.isEmpty()) {
                    for (String filterItem : formFactor.myApiWhitelist) {
                        if (!FormFactorUtils.matches(filterItem, input)) continue;
                        return true;
                    }
                    return false;
                }
                for (String filterItem : formFactor.myApiBlacklist) {
                    if (!FormFactorUtils.matches(filterItem, input)) continue;
                    return false;
                }
                return input.apiLevel >= minSdkLevel || input.target != null && input.target.getVersion().isPreview();
            }
        };
    }

    private static boolean matches(@NotNull String filterItem, @NotNull FormFactorApiComboBox.AndroidTargetComboBoxItem input) {
        if (filterItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterItem", "com/android/tools/idea/wizard/FormFactorUtils", "matches"));
        }
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/android/tools/idea/wizard/FormFactorUtils", "matches"));
        }
        if (Integer.toString(input.apiLevel).equals(filterItem)) {
            return true;
        }
        return input.target != null && input.target.getName().contains(filterItem);
    }

    @Nullable
    public static Icon getFormFactorsImage(JComponent component, boolean requireEmulator) {
        int width = 0;
        int height = 0;
        for (DeviceMenuAction.FormFactor formFactor : DeviceMenuAction.FormFactor.values()) {
            Icon icon = formFactor.getLargeIcon();
            height = icon.getIconHeight();
            if (requireEmulator && !formFactor.hasEmulator()) continue;
            width += formFactor.getLargeIcon().getIconWidth();
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphics = image.createGraphics();
        int x = 0;
        for (DeviceMenuAction.FormFactor formFactor : DeviceMenuAction.FormFactor.values()) {
            if (requireEmulator && !formFactor.hasEmulator()) continue;
            Icon icon = formFactor.getLargeIcon();
            icon.paintIcon(component, graphics, x, 0);
            x += icon.getIconWidth();
        }
        if (graphics != null) {
            graphics.dispose();
            return new ImageIcon(image);
        }
        return null;
    }

    public static class FormFactor {
        public static final FormFactor MOBILE = new FormFactor("Mobile", DeviceMenuAction.FormFactor.MOBILE, "Phone and Tablet", 15, Lists.newArrayList((Object[])new String[]{"20", "Glass", "Google APIs"}), null);
        public static final FormFactor WEAR = new FormFactor("Wear", DeviceMenuAction.FormFactor.WEAR, "Wear", 21, null, Lists.newArrayList((Object[])new String[]{"20", "21"}));
        public static final FormFactor GLASS = new FormFactor("Glass", DeviceMenuAction.FormFactor.GLASS, "Glass", 19, null, Lists.newArrayList((Object[])new String[]{"Glass"}));
        public static final FormFactor TV = new FormFactor("TV", DeviceMenuAction.FormFactor.TV, "TV", 21, Lists.newArrayList((Object[])new String[]{"20"}), null);
        private static final Map<String, FormFactor> myFormFactors = new ImmutableMap.Builder().put((Object)FormFactor.MOBILE.id, (Object)MOBILE).put((Object)FormFactor.WEAR.id, (Object)WEAR).put((Object)FormFactor.GLASS.id, (Object)GLASS).put((Object)FormFactor.TV.id, (Object)TV).build();
        public final String id;
        @Nullable
        private String displayName;
        public final int defaultApi;
        @NotNull
        private final List<String> myApiBlacklist;
        @NotNull
        private final List<String> myApiWhitelist;
        @NotNull
        private final DeviceMenuAction.FormFactor myEnumValue;

        FormFactor(@NotNull String id, @NotNull DeviceMenuAction.FormFactor enumValue, @Nullable String displayName, int defaultApi, @Nullable List<String> apiBlacklist, @Nullable List<String> apiWhitelist) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/idea/wizard/FormFactorUtils$FormFactor", "<init>"));
            }
            if (enumValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumValue", "com/android/tools/idea/wizard/FormFactorUtils$FormFactor", "<init>"));
            }
            this.id = id;
            this.myEnumValue = enumValue;
            this.displayName = displayName;
            this.defaultApi = defaultApi;
            this.myApiBlacklist = apiBlacklist != null ? apiBlacklist : Collections.emptyList();
            this.myApiWhitelist = apiWhitelist != null ? apiWhitelist : Collections.emptyList();
        }

        @Nullable
        public static FormFactor get(@NotNull String id) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/idea/wizard/FormFactorUtils$FormFactor", "get"));
            }
            if (myFormFactors.containsKey(id)) {
                return myFormFactors.get(id);
            }
            return new FormFactor(id, DeviceMenuAction.FormFactor.MOBILE, id, 1, null, null);
        }

        public String toString() {
            return this.displayName == null ? this.id : this.displayName;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.myEnumValue.getIcon64();
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/FormFactorUtils$FormFactor", "getIcon"));
            }
            return icon;
        }

        @NotNull
        public Icon getLargeIcon() {
            Icon icon = this.myEnumValue.getLargeIcon();
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/FormFactorUtils$FormFactor", "getLargeIcon"));
            }
            return icon;
        }

        public static Iterator<FormFactor> iterator() {
            return myFormFactors.values().iterator();
        }
    }
}

