/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.swing.layoutlib;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.LayoutLibrary;
import com.android.ide.common.rendering.RenderSecurityManager;
import com.android.ide.common.rendering.api.ActionBarCallback;
import com.android.ide.common.rendering.api.AssetRepository;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.IImageFactory;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.IProjectCallback;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.AssetRepositoryImpl;
import com.android.tools.idea.rendering.LayoutlibCallback;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderSecurityManagerFactory;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.swing.layoutlib.InitializationException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.Graphics2DDelegate;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.uipreview.RenderingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphicsLayoutRenderer {
    private static final Logger LOG = Logger.getInstance((String)GraphicsLayoutRenderer.class.getName());
    private final LayoutLibrary myLayoutLibrary;
    private final SessionParams mySessionParams;
    private final FakeImageFactory myImageFactory;
    private final DynamicHardwareConfig myHardwareConfig;
    private final Object myCredential;
    private final RenderSecurityManager mySecurityManager;
    private boolean myInvalidate;
    private RenderSession myRenderSession;

    private GraphicsLayoutRenderer(@NotNull LayoutLibrary layoutLib, @NotNull SessionParams sessionParams, @NotNull RenderSecurityManager securityManager, @NotNull DynamicHardwareConfig hardwareConfig, @NotNull ILayoutPullParser parser) {
        if (layoutLib == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutLib", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "<init>"));
        }
        if (sessionParams == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionParams", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "<init>"));
        }
        if (securityManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "securityManager", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "<init>"));
        }
        if (hardwareConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hardwareConfig", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "<init>"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "<init>"));
        }
        this.myCredential = new Object();
        this.myLayoutLibrary = layoutLib;
        this.mySecurityManager = securityManager;
        this.myHardwareConfig = hardwareConfig;
        this.mySessionParams = sessionParams;
        this.myImageFactory = new FakeImageFactory();
        this.mySessionParams.setImageFactory((IImageFactory)this.myImageFactory);
    }

    @NotNull
    protected static GraphicsLayoutRenderer create(@NotNull AndroidFacet facet, @NotNull AndroidPlatform platform, @NotNull IAndroidTarget target, @NotNull Project project, @NotNull Configuration configuration, @NotNull ILayoutPullParser parser) throws InitializationException {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "create"));
        }
        if (platform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platform", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "create"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "create"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "create"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "create"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "create"));
        }
        Module module = facet.getModule();
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.get(facet);
        LayoutLibrary layoutLib = null;
        try {
            layoutLib = platform.getSdkData().getTargetData(target).getLayoutLibrary(project);
            if (layoutLib == null) {
                throw new InitializationException("getLayoutLibrary() returned null");
            }
        }
        catch (RenderingException e) {
            throw new InitializationException(e);
        }
        catch (IOException e) {
            throw new InitializationException(e);
        }
        AppResourceRepository appResources = AppResourceRepository.getAppResources(facet, true);
        RenderLogger logger = new RenderLogger("theme_editor", module);
        final ActionBarCallback actionBarCallback = new ActionBarCallback();
        LayoutlibCallback layoutlibCallback = new LayoutlibCallback(layoutLib, appResources, module, facet, logger, new Object(), null, null){

            @Override
            public ActionBarCallback getActionBarCallback() {
                return actionBarCallback;
            }
        };
        HardwareConfigHelper hardwareConfigHelper = new HardwareConfigHelper(configuration.getDevice());
        DynamicHardwareConfig hardwareConfig = new DynamicHardwareConfig(hardwareConfigHelper.getConfig());
        SessionParams params = new SessionParams(parser, SessionParams.RenderingMode.NORMAL, (Object)module, (HardwareConfig)hardwareConfig, (RenderResources)configuration.getResourceResolver(), (IProjectCallback)layoutlibCallback, moduleInfo.getTargetSdkVersion().getApiLevel(), moduleInfo.getMinSdkVersion().getApiLevel(), (LayoutLog)logger, target instanceof CompatibilityRenderTarget ? target.getVersion().getApiLevel() : 0);
        params.setForceNoDecor();
        params.setAssetRepository((AssetRepository)new AssetRepositoryImpl(facet));
        RenderSecurityManager mySecurityManager = RenderSecurityManagerFactory.create(module, platform);
        GraphicsLayoutRenderer graphicsLayoutRenderer = new GraphicsLayoutRenderer(layoutLib, params, mySecurityManager, hardwareConfig, parser);
        if (graphicsLayoutRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "create"));
        }
        return graphicsLayoutRenderer;
    }

    @Nullable
    public static GraphicsLayoutRenderer create(@NotNull PsiFile layoutFile, @NotNull Configuration configuration, @NotNull ILayoutPullParser parser) throws InitializationException {
        if (layoutFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutFile", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "create"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "create"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "create"));
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)layoutFile);
        if (facet == null) {
            return null;
        }
        Module module = facet.getModule();
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        IAndroidTarget target = configuration.getTarget();
        if (target == null) {
            return null;
        }
        if (sdk == null || !AndroidSdkUtils.isAndroidSdk(sdk)) {
            return null;
        }
        AndroidSdkAdditionalData data = (AndroidSdkAdditionalData)sdk.getSdkAdditionalData();
        if (data == null) {
            return null;
        }
        AndroidPlatform platform = data.getAndroidPlatform();
        if (platform == null) {
            return null;
        }
        return GraphicsLayoutRenderer.create(facet, platform, target, module.getProject(), configuration, parser);
    }

    public void setSize(Dimension dimen) {
        this.myHardwareConfig.setScreenSize(dimen.width, dimen.height);
        this.myInvalidate = true;
    }

    public void render(@NotNull Graphics2D graphics) {
        if (graphics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "render"));
        }
        this.myImageFactory.setGraphics(graphics);
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                Result result = null;
                GraphicsLayoutRenderer.this.mySecurityManager.setActive(true, GraphicsLayoutRenderer.this.myCredential);
                try {
                    if (GraphicsLayoutRenderer.this.myRenderSession == null) {
                        GraphicsLayoutRenderer.this.myRenderSession = GraphicsLayoutRenderer.this.initRenderSession();
                        return;
                    }
                    result = GraphicsLayoutRenderer.this.myRenderSession.render(250L, true);
                }
                finally {
                    GraphicsLayoutRenderer.this.mySecurityManager.setActive(false, GraphicsLayoutRenderer.this.myCredential);
                }
                if (result != null && result.getStatus() != Result.Status.SUCCESS) {
                    LOG.error(result.getException());
                }
            }
        });
        this.myInvalidate = false;
    }

    @Nullable
    private RenderSession initRenderSession() {
        RenderSession session = this.myLayoutLibrary.createSession(this.mySessionParams);
        Result result = session.getResult();
        if (!result.isSuccess() && result.getStatus() == Result.Status.ERROR_TIMEOUT) {
            throw new RuntimeException("createSession ERROR_TIMEOUT.");
        }
        return session;
    }

    static class DynamicHardwareConfig
    extends HardwareConfig {
        private int myWidth;
        private int myHeight;

        public DynamicHardwareConfig(HardwareConfig delegate) {
            super(delegate.getScreenWidth(), delegate.getScreenHeight(), delegate.getDensity(), delegate.getXdpi(), delegate.getYdpi(), delegate.getScreenSize(), delegate.getOrientation(), delegate.hasSoftwareButtons());
            this.myWidth = delegate.getScreenWidth();
            this.myHeight = delegate.getScreenHeight();
        }

        public void setScreenSize(int width, int height) {
            this.myWidth = width;
            this.myHeight = height;
        }

        public int getScreenWidth() {
            return this.myWidth;
        }

        public int getScreenHeight() {
            return this.myHeight;
        }
    }

    static class FakeImageFactory
    implements IImageFactory {
        private Graphics myGraphics;

        FakeImageFactory() {
        }

        public void setGraphics(@NotNull Graphics graphics) {
            if (graphics == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer$FakeImageFactory", "setGraphics"));
            }
            this.myGraphics = graphics;
        }

        public BufferedImage getImage(final int w, final int h) {
            return new BufferedImage(1, 1, 12){

                @Override
                public Graphics2D createGraphics() {
                    Graphics2DDelegate g = new Graphics2DDelegate((Graphics2D)FakeImageFactory.this.myGraphics.create(0, 0, w, h)){

                        public void setTransform(AffineTransform Tx) {
                        }
                    };
                    return g;
                }

                @Override
                public int getWidth() {
                    return w;
                }

                @Override
                public int getHeight() {
                    return h;
                }
            };
        }
    }
}

