/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.intellij.ProjectTopics;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.JavaLanguageLevelPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.containers.HashSet;
import com.intellij.util.messages.MessageBus;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.annotations.NotNull;

public class AndroidSdkLanguageLevelPusher
extends AbstractProjectComponent {
    private volatile Set<Sdk> myUsedAndroidSdks;

    protected AndroidSdkLanguageLevelPusher(@NotNull Project project, final @NotNull MessageBus messageBus) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/AndroidSdkLanguageLevelPusher", "<init>"));
        }
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "org/jetbrains/android/AndroidSdkLanguageLevelPusher", "<init>"));
        }
        super(project);
        this.myUsedAndroidSdks = Collections.emptySet();
        StartupManager.getInstance((Project)project).registerPreStartupActivity(new Runnable(){

            @Override
            public void run() {
                AndroidSdkLanguageLevelPusher.this.updateLanguageLevelForAllUsedSdks();
                messageBus.connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

                    public void rootsChanged(ModuleRootEvent event) {
                        AndroidSdkLanguageLevelPusher.this.updateLanguageLevelForAllUsedSdks();
                    }
                });
            }
        });
    }

    private void updateLanguageLevelForAllUsedSdks() {
        Set newUsedSdks = null;
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (sdk == null || !(sdk.getSdkType() instanceof AndroidSdkType)) continue;
            if (newUsedSdks == null) {
                newUsedSdks = new HashSet();
            }
            if (!newUsedSdks.add(sdk) || this.myUsedAndroidSdks.contains(sdk)) continue;
            AndroidSdkLanguageLevelPusher.updateSdkLanguageLevel(this.myProject, sdk);
        }
        if (newUsedSdks != null) {
            this.myUsedAndroidSdks = newUsedSdks;
        }
    }

    private static void updateSdkLanguageLevel(final @NotNull Project project, @NotNull Sdk sdk) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/AndroidSdkLanguageLevelPusher", "updateSdkLanguageLevel"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/android/AndroidSdkLanguageLevelPusher", "updateSdkLanguageLevel"));
        }
        final JavaLanguageLevelPusher javaPusher = new JavaLanguageLevelPusher();
        for (VirtualFile root : sdk.getRootProvider().getFiles(OrderRootType.SOURCES)) {
            if (!root.isValid()) continue;
            final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
            VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/AndroidSdkLanguageLevelPusher$2", "visitFile"));
                    }
                    if (fileTypeManager.isFileIgnored(file)) {
                        return false;
                    }
                    if (file.isDirectory()) {
                        PushedFilePropertiesUpdater.getInstance((Project)project).findAndUpdateValue(file, (FilePropertyPusher)javaPusher, (Object)LanguageLevel.HIGHEST);
                    }
                    return true;
                }
            });
        }
    }
}

