/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomExtender;
import com.intellij.util.xml.reflect.DomExtension;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.animation.AndroidAnimationUtils;
import org.jetbrains.android.dom.animation.AnimationElement;
import org.jetbrains.android.dom.animator.AndroidAnimatorUtil;
import org.jetbrains.android.dom.animator.AnimatorElement;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.dom.attrs.StyleableDefinition;
import org.jetbrains.android.dom.color.ColorDomElement;
import org.jetbrains.android.dom.color.ColorStateListItem;
import org.jetbrains.android.dom.converters.CompositeConverter;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.drawable.AndroidDrawableDomUtil;
import org.jetbrains.android.dom.drawable.AnimatedStateListTransition;
import org.jetbrains.android.dom.drawable.AnimatedVectorTarget;
import org.jetbrains.android.dom.drawable.AnimationListItem;
import org.jetbrains.android.dom.drawable.DrawableDomElement;
import org.jetbrains.android.dom.drawable.DrawableStateListItem;
import org.jetbrains.android.dom.drawable.LayerListItem;
import org.jetbrains.android.dom.drawable.LevelListItem;
import org.jetbrains.android.dom.drawable.VectorClipPath;
import org.jetbrains.android.dom.drawable.VectorGroup;
import org.jetbrains.android.dom.drawable.VectorPath;
import org.jetbrains.android.dom.layout.Fragment;
import org.jetbrains.android.dom.layout.Include;
import org.jetbrains.android.dom.layout.LayoutElement;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.layout.Tag;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.ManifestElement;
import org.jetbrains.android.dom.menu.MenuElement;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.transition.ArcMotion;
import org.jetbrains.android.dom.transition.AutoTransition;
import org.jetbrains.android.dom.transition.ChangeBounds;
import org.jetbrains.android.dom.transition.ChangeClipBounds;
import org.jetbrains.android.dom.transition.ChangeImageTransform;
import org.jetbrains.android.dom.transition.ChangeScroll;
import org.jetbrains.android.dom.transition.ChangeTransform;
import org.jetbrains.android.dom.transition.Explode;
import org.jetbrains.android.dom.transition.Fade;
import org.jetbrains.android.dom.transition.PathMotion;
import org.jetbrains.android.dom.transition.PatternPathMotion;
import org.jetbrains.android.dom.transition.Recolor;
import org.jetbrains.android.dom.transition.Slide;
import org.jetbrains.android.dom.transition.Target;
import org.jetbrains.android.dom.transition.Targets;
import org.jetbrains.android.dom.transition.TransitionDomElement;
import org.jetbrains.android.dom.transition.TransitionSet;
import org.jetbrains.android.dom.transition.TransitionTag;
import org.jetbrains.android.dom.xml.AndroidXmlResourcesUtil;
import org.jetbrains.android.dom.xml.Intent;
import org.jetbrains.android.dom.xml.PreferenceElement;
import org.jetbrains.android.dom.xml.XmlResourceElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.SimpleClassMapConstructor;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.SystemResourceManager;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDomExtender
extends DomExtender<AndroidDomElement> {
    private static final String[] LAYOUT_ATTRIBUTES_SUFS = new String[]{"_Layout", "_MarginLayout", "_Cell"};
    private static final MyAttributeProcessor ourLayoutAttrsProcessor = new MyAttributeProcessor(){

        @Override
        public void process(@NotNull XmlName attrName, @NotNull DomExtension extension, @NotNull DomElement element) {
            if (attrName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "org/jetbrains/android/dom/AndroidDomExtender$1", "process"));
            }
            if (extension == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/android/dom/AndroidDomExtender$1", "process"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/dom/AndroidDomExtender$1", "process"));
            }
            String localName = attrName.getLocalName();
            if (!"layout_width".equals(localName) && !"layout_height".equals(localName)) {
                return;
            }
            if ((element instanceof LayoutViewElement || element instanceof Fragment) && "http://schemas.android.com/apk/res/android".equals(attrName.getNamespaceKey())) {
                String tagName;
                XmlElement xmlElement = element.getXmlElement();
                XmlTag tag = xmlElement instanceof XmlTag ? (XmlTag)xmlElement : null;
                String string = tagName = tag != null ? tag.getName() : null;
                if (!("merge".equals(tagName) || "TableRow".equals(tagName) || "include".equals(tagName) || "requestFocus".equals(tagName) || "tag".equals(tagName) || tag != null && tag.getAttribute("style") != null)) {
                    String parentTagName;
                    XmlTag parentTag = tag != null ? tag.getParentTag() : null;
                    String string2 = parentTagName = parentTag != null ? parentTag.getName() : null;
                    if (!("TableRow".equals(parentTagName) || "TableLayout".equals(parentTagName) || "merge".equals(parentTagName) || "GridLayout".equals(parentTagName) || "android.support.v7.widget.GridLayout".equals(parentTagName))) {
                        extension.addCustomAnnotation((Annotation)((Object)new MyRequired()));
                    }
                }
            }
        }
    };

    public boolean supportsStubs() {
        return false;
    }

    @Nullable
    public static String getNamespaceKeyByResourcePackage(@NotNull AndroidFacet facet, @Nullable String resPackage) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/dom/AndroidDomExtender", "getNamespaceKeyByResourcePackage"));
        }
        if (resPackage == null) {
            String aPackage;
            if (facet.getProperties().LIBRARY_PROJECT || facet.isGradleProject()) {
                return "http://schemas.android.com/apk/res-auto";
            }
            Manifest manifest = facet.getManifest();
            if (manifest != null && (aPackage = (String)manifest.getPackage().getValue()) != null && aPackage.length() > 0) {
                return "http://schemas.android.com/apk/res/" + aPackage;
            }
        } else if (resPackage.equals("android")) {
            return "http://schemas.android.com/apk/res/android";
        }
        return null;
    }

    protected static void registerStyleableAttributes(DomElement element, @NotNull StyleableDefinition[] styleables, @Nullable String namespace, MyCallback callback, MyAttributeProcessor processor, Set<XmlName> skippedAttrSet) {
        if (styleables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleables", "org/jetbrains/android/dom/AndroidDomExtender", "registerStyleableAttributes"));
        }
        for (StyleableDefinition styleable : styleables) {
            for (AttributeDefinition attrDef : styleable.getAttributes()) {
                String attrName = attrDef.getName();
                if (skippedAttrSet.contains(new XmlName(attrName, namespace))) continue;
                skippedAttrSet.add(new XmlName(attrName, namespace));
                AndroidDomExtender.registerAttribute(attrDef, styleable.getName(), namespace, callback, processor, element);
            }
        }
    }

    private static boolean mustBeSoft(@NotNull Converter converter, Collection<AttributeFormat> formats) {
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "org/jetbrains/android/dom/AndroidDomExtender", "mustBeSoft"));
        }
        if (converter instanceof CompositeConverter || converter instanceof ResourceReferenceConverter) {
            return false;
        }
        return formats.size() > 1;
    }

    private static void registerAttribute(@NotNull AttributeDefinition attrDef, @Nullable String parentStyleableName, String namespaceKey, MyCallback callback, @Nullable MyAttributeProcessor processor, @NotNull DomElement element) {
        if (attrDef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrDef", "org/jetbrains/android/dom/AndroidDomExtender", "registerAttribute"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/dom/AndroidDomExtender", "registerAttribute"));
        }
        XmlName xmlName = new XmlName(attrDef.getName(), namespaceKey);
        DomExtension extension = callback.processAttribute(xmlName, attrDef, parentStyleableName);
        if (extension == null) {
            return;
        }
        Converter converter = AndroidDomUtil.getSpecificConverter(xmlName, element);
        if (converter == null) {
            converter = AndroidDomUtil.getConverter(attrDef);
        }
        if (converter != null) {
            extension.setConverter(converter, AndroidDomExtender.mustBeSoft(converter, attrDef.getFormats()));
        }
        if (processor != null) {
            processor.process(xmlName, extension, element);
        }
    }

    protected static void registerAttributes(AndroidFacet facet, DomElement element, @NotNull String[] styleableNames, MyCallback callback, MyAttributeProcessor processor, Set<XmlName> skipNames) {
        if (styleableNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleableNames", "org/jetbrains/android/dom/AndroidDomExtender", "registerAttributes"));
        }
        AndroidDomExtender.registerAttributes(facet, element, styleableNames, null, callback, processor, skipNames);
        AndroidDomExtender.registerAttributes(facet, element, styleableNames, "android", callback, processor, skipNames);
    }

    private static StyleableDefinition[] getStyleables(@NotNull AttributeDefinitions definitions, @NotNull String[] names) {
        if (definitions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definitions", "org/jetbrains/android/dom/AndroidDomExtender", "getStyleables"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "org/jetbrains/android/dom/AndroidDomExtender", "getStyleables"));
        }
        ArrayList<StyleableDefinition> styleables = new ArrayList<StyleableDefinition>();
        for (String name : names) {
            StyleableDefinition styleable = definitions.getStyleableByName(name);
            if (styleable == null) continue;
            styleables.add(styleable);
        }
        return styleables.toArray(new StyleableDefinition[styleables.size()]);
    }

    protected static void registerAttributes(AndroidFacet facet, DomElement element, @NotNull String styleableName, @Nullable String resPackage, MyCallback callback, Set<XmlName> skipNames) {
        if (styleableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleableName", "org/jetbrains/android/dom/AndroidDomExtender", "registerAttributes"));
        }
        AndroidDomExtender.registerAttributes(facet, element, new String[]{styleableName}, resPackage, callback, null, skipNames);
    }

    protected static void registerAttributes(AndroidFacet facet, DomElement element, @NotNull String[] styleableNames, @Nullable String resPackage, MyCallback callback, MyAttributeProcessor processor, Set<XmlName> skipNames) {
        if (styleableNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleableNames", "org/jetbrains/android/dom/AndroidDomExtender", "registerAttributes"));
        }
        ResourceManager manager = facet.getResourceManager(resPackage);
        if (manager == null) {
            return;
        }
        AttributeDefinitions attrDefs = manager.getAttributeDefinitions();
        if (attrDefs == null) {
            return;
        }
        StyleableDefinition[] styleables = AndroidDomExtender.getStyleables(attrDefs, styleableNames);
        AndroidDomExtender.registerAttributes(facet, element, styleables, resPackage, callback, processor, skipNames);
    }

    private static void registerAttributes(AndroidFacet facet, DomElement element, StyleableDefinition[] styleables, String resPackage, MyCallback callback, MyAttributeProcessor processor, Set<XmlName> skipNames) {
        String namespace = AndroidDomExtender.getNamespaceKeyByResourcePackage(facet, resPackage);
        AndroidDomExtender.registerStyleableAttributes(element, styleables, namespace, callback, processor, skipNames);
    }

    @NotNull
    private static Class getValueClass(@Nullable AttributeFormat format) {
        if (format == null) {
            if (String.class == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/AndroidDomExtender", "getValueClass"));
            }
            return String.class;
        }
        switch (format) {
            case Boolean: {
                Class<Boolean> clazz = Boolean.TYPE;
                if (clazz == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/AndroidDomExtender", "getValueClass"));
                }
                return clazz;
            }
            case Reference: 
            case Dimension: 
            case Color: {
                if (ResourceValue.class == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/AndroidDomExtender", "getValueClass"));
                }
                return ResourceValue.class;
            }
        }
        if (String.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/AndroidDomExtender", "getValueClass"));
        }
        return String.class;
    }

    protected static void registerAttributesForClassAndSuperclasses(AndroidFacet facet, DomElement element, PsiClass c, MyCallback callback, MyAttributeProcessor processor, Set<XmlName> skipNames) {
        while (c != null) {
            String styleableName = c.getName();
            if (styleableName != null) {
                AndroidDomExtender.registerAttributes(facet, element, new String[]{styleableName}, callback, processor, skipNames);
            }
            c = AndroidDomExtender.getSuperclass(c);
        }
    }

    @Nullable
    protected static PsiClass getSuperclass(final @NotNull PsiClass c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/android/dom/AndroidDomExtender", "getSuperclass"));
        }
        return (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            @Nullable
            public PsiClass compute() {
                return c.isValid() ? c.getSuperClass() : null;
            }
        });
    }

    private static boolean isPreference(@NotNull Map<String, PsiClass> preferenceClassMap, @NotNull PsiClass c) {
        if (preferenceClassMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferenceClassMap", "org/jetbrains/android/dom/AndroidDomExtender", "isPreference"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/android/dom/AndroidDomExtender", "isPreference"));
        }
        PsiClass preferenceClass = preferenceClassMap.get("Preference");
        return preferenceClass != null && (preferenceClass == c || c.isInheritor(preferenceClass, true));
    }

    public static void registerExtensionsForXmlResources(AndroidFacet facet, XmlTag tag, XmlResourceElement element, MyCallback callback, Set<String> registeredSubtags, Set<XmlName> skipAttrNames) {
        String tagName = tag.getName();
        String styleableName = AndroidXmlResourcesUtil.SPECIAL_STYLEABLE_NAMES.get(tagName);
        if (styleableName != null) {
            String[] stringArray;
            if (element instanceof Intent) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "action";
            } else {
                stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
            }
            String[] attrsToSkip = stringArray;
            HashSet<XmlName> newSkipAttrNames = new HashSet<XmlName>();
            for (String attrName : attrsToSkip) {
                newSkipAttrNames.add(new XmlName(attrName, "http://schemas.android.com/apk/res/android"));
            }
            AndroidDomExtender.registerAttributes(facet, (DomElement)element, styleableName, "android", callback, newSkipAttrNames);
        }
        if (tagName.equals("searchable")) {
            AndroidDomExtender.registerSubtags("actionkey", XmlResourceElement.class, callback, registeredSubtags);
        }
        if (tagName.equals("Keyboard")) {
            AndroidDomExtender.registerSubtags("Row", XmlResourceElement.class, callback, registeredSubtags);
        } else if (tagName.equals("Row")) {
            AndroidDomExtender.registerSubtags("Key", XmlResourceElement.class, callback, registeredSubtags);
        }
        if (tagName.equals("device-admin")) {
            AndroidDomExtender.registerSubtags("uses-policies", XmlResourceElement.class, callback, registeredSubtags);
        } else if (tagName.equals("uses-policies")) {
            AndroidDomExtender.registerSubtags("limit-password", XmlResourceElement.class, callback, registeredSubtags);
            AndroidDomExtender.registerSubtags("watch-login", XmlResourceElement.class, callback, registeredSubtags);
            AndroidDomExtender.registerSubtags("reset-password", XmlResourceElement.class, callback, registeredSubtags);
            AndroidDomExtender.registerSubtags("force-lock", XmlResourceElement.class, callback, registeredSubtags);
            AndroidDomExtender.registerSubtags("wipe-data", XmlResourceElement.class, callback, registeredSubtags);
            AndroidDomExtender.registerSubtags("expire-password", XmlResourceElement.class, callback, registeredSubtags);
            AndroidDomExtender.registerSubtags("encrypted-storage", XmlResourceElement.class, callback, registeredSubtags);
            AndroidDomExtender.registerSubtags("disable-camera", XmlResourceElement.class, callback, registeredSubtags);
        }
        if (tagName.equals("preference-headers")) {
            AndroidDomExtender.registerSubtags("header", PreferenceElement.class, callback, registeredSubtags);
        }
        Map<String, PsiClass> prefClassMap = AndroidDomExtender.getPreferencesClassMap(facet);
        String prefClassName = element.getXmlTag().getName();
        PsiClass c = prefClassMap.get(prefClassName);
        AndroidDomExtender.registerAttributesForClassAndSuperclasses(facet, element, c, callback, null, skipAttrNames);
        String suffix = "Preference";
        if (prefClassName.endsWith(suffix)) {
            String widgetClassName = prefClassName.substring(0, prefClassName.length() - suffix.length());
            PsiClass widgetClass = SimpleClassMapConstructor.findClassByTagName(facet, widgetClassName, "android.view.View");
            AndroidDomExtender.registerAttributesForClassAndSuperclasses(facet, element, widgetClass, callback, null, skipAttrNames);
        }
        if (c != null && AndroidDomExtender.isPreference(prefClassMap, c)) {
            AndroidDomExtender.registerClassNameSubtags(tag, prefClassMap, PreferenceElement.class, registeredSubtags, callback);
        }
    }

    @NotNull
    public static Map<String, PsiClass> getPreferencesClassMap(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/dom/AndroidDomExtender", "getPreferencesClassMap"));
        }
        Map<String, PsiClass> map = facet.getClassMap("android.preference.Preference", SimpleClassMapConstructor.getInstance());
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/AndroidDomExtender", "getPreferencesClassMap"));
        }
        return map;
    }

    public static void registerExtensionsForAnimation(final AndroidFacet facet, String tagName, AnimationElement element, MyCallback callback, Set<String> registeredSubtags, Set<XmlName> skipAttrNames) {
        if (tagName.equals("set")) {
            for (String subtagName : AndroidAnimationUtils.getPossibleChildren(facet)) {
                AndroidDomExtender.registerSubtags(subtagName, AnimationElement.class, callback, registeredSubtags);
            }
        }
        final String styleableName = AndroidAnimationUtils.getStyleableNameByTagName(tagName);
        final JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)facet.getModule().getProject());
        PsiClass c = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            @Nullable
            public PsiClass compute() {
                return facade.findClass("android.view.animation." + styleableName, facet.getModule().getModuleWithDependenciesAndLibrariesScope(true));
            }
        });
        if (c != null) {
            AndroidDomExtender.registerAttributesForClassAndSuperclasses(facet, element, c, callback, null, skipAttrNames);
        } else {
            AndroidDomExtender.registerAttributes(facet, (DomElement)element, styleableName, "android", callback, skipAttrNames);
            String layoutAnim = "LayoutAnimation";
            if (styleableName.endsWith(layoutAnim) && !styleableName.equals(layoutAnim)) {
                AndroidDomExtender.registerAttributes(facet, (DomElement)element, layoutAnim, "android", callback, skipAttrNames);
            }
            if (styleableName.endsWith("Animation")) {
                AndroidDomExtender.registerAttributes(facet, (DomElement)element, "Animation", "android", callback, skipAttrNames);
            }
        }
    }

    public static void registerExtensionsForAnimator(AndroidFacet facet, String tagName, AnimatorElement element, MyCallback callback, Set<String> registeredSubtags, Set<XmlName> skipAttrNames) {
        if (tagName.equals("set")) {
            for (String subtagName : AndroidAnimatorUtil.getPossibleChildren()) {
                AndroidDomExtender.registerSubtags(subtagName, AnimatorElement.class, callback, registeredSubtags);
            }
        }
        AndroidDomExtender.registerAttributes(facet, (DomElement)element, "Animator", "android", callback, skipAttrNames);
        String styleableName = AndroidAnimatorUtil.getStyleableNameByTagName(tagName);
        if (styleableName != null) {
            AndroidDomExtender.registerAttributes(facet, (DomElement)element, styleableName, "android", callback, skipAttrNames);
        }
    }

    public static Map<String, PsiClass> getViewClassMap(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/dom/AndroidDomExtender", "getViewClassMap"));
        }
        if (DumbService.isDumb((Project)facet.getModule().getProject())) {
            return Collections.emptyMap();
        }
        return facet.getClassMap("android.view.View", SimpleClassMapConstructor.getInstance());
    }

    private static String[] getClassNames(@NotNull Collection<PsiClass> classes) {
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "org/jetbrains/android/dom/AndroidDomExtender", "getClassNames"));
        }
        ArrayList<String> names = new ArrayList<String>();
        for (PsiClass aClass : classes) {
            names.add(aClass.getName());
        }
        return ArrayUtil.toStringArray(names);
    }

    private static void registerLayoutAttributes(AndroidFacet facet, DomElement element, XmlTag tag, MyCallback callback, MyAttributeProcessor processor, Set<XmlName> skipAttrNames) {
        String parentTagName;
        XmlTag parentTag = tag.getParentTag();
        Map<String, PsiClass> map = AndroidDomExtender.getViewClassMap(facet);
        if (parentTag != null && !"merge".equals(parentTagName = parentTag.getName())) {
            PsiClass c = map.get(parentTagName);
            while (c != null) {
                AndroidDomExtender.registerLayoutAttributes(facet, element, c, callback, processor, skipAttrNames);
                c = AndroidDomExtender.getSuperclass(c);
            }
            return;
        }
        for (String className : map.keySet()) {
            PsiClass c = map.get(className);
            AndroidDomExtender.registerLayoutAttributes(facet, element, c, callback, processor, skipAttrNames);
        }
    }

    private static void registerLayoutAttributes(AndroidFacet facet, DomElement element, PsiClass c, MyCallback callback, MyAttributeProcessor processor, Set<XmlName> skipAttrNames) {
        String styleableName = c.getName();
        if (styleableName != null) {
            for (String suf : LAYOUT_ATTRIBUTES_SUFS) {
                AndroidDomExtender.registerAttributes(facet, element, new String[]{styleableName + suf}, callback, processor, skipAttrNames);
            }
        }
    }

    public static void registerExtensionsForLayout(AndroidFacet facet, XmlTag tag, LayoutElement element, MyCallback callback, Set<String> registeredSubtags, Set<XmlName> skipAttrNames) {
        Map<String, PsiClass> map = AndroidDomExtender.getViewClassMap(facet);
        if (element instanceof Include) {
            for (String className : map.keySet()) {
                PsiClass c = map.get(className);
                AndroidDomExtender.registerLayoutAttributes(facet, (DomElement)element, c, callback, ourLayoutAttrsProcessor, skipAttrNames);
            }
            return;
        }
        if (element instanceof Fragment) {
            AndroidDomExtender.registerAttributes(facet, (DomElement)element, new String[]{"Fragment"}, callback, ourLayoutAttrsProcessor, skipAttrNames);
        } else {
            if (element instanceof Tag) {
                AndroidDomExtender.registerAttributes(facet, (DomElement)element, "ViewTag", "android", callback, skipAttrNames);
                return;
            }
            String tagName = tag.getName();
            if (!tagName.equals("view")) {
                PsiClass c = map.get(tagName);
                AndroidDomExtender.registerAttributesForClassAndSuperclasses(facet, element, c, callback, ourLayoutAttrsProcessor, skipAttrNames);
            } else {
                String[] styleableNames = AndroidDomExtender.getClassNames(map.values());
                AndroidDomExtender.registerAttributes(facet, (DomElement)element, styleableNames, callback, ourLayoutAttrsProcessor, skipAttrNames);
            }
        }
        AndroidDomExtender.registerLayoutAttributes(facet, (DomElement)element, tag, callback, ourLayoutAttrsProcessor, skipAttrNames);
        AndroidDomExtender.registerClassNameSubtags(tag, map, LayoutViewElement.class, registeredSubtags, callback);
    }

    private static void registerClassNameSubtags(XmlTag tag, Map<String, PsiClass> classMap, Type type, Set<String> registeredSubtags, MyCallback callback) {
        HashSet<String> allAllowedTags = new HashSet<String>();
        HashMap class2Name = new HashMap();
        for (String tagName : classMap.keySet()) {
            PsiClass aClass = classMap.get(tagName);
            if (AndroidUtils.isAbstract(aClass)) continue;
            allAllowedTags.add(tagName);
            String qName = aClass.getQualifiedName();
            String prevTagName = (String)class2Name.get(qName);
            if (prevTagName != null && tagName.indexOf(46) != -1) continue;
            class2Name.put(qName, tagName);
        }
        AndroidDomExtender.registerSubtags(callback, tag, allAllowedTags, class2Name.values(), registeredSubtags, type);
    }

    private static void registerSubtags(MyCallback callback, XmlTag tag, final Set<String> allowedTags, Collection<String> tagsToComplete, Set<String> registeredSubtags, Type type) {
        for (String tagName : tagsToComplete) {
            AndroidDomExtender.registerSubtags(tagName, type, callback, registeredSubtags);
        }
        AndroidDomExtender.registerExistingSubtags(tag, callback, new Processor<String>(){

            public boolean process(String s) {
                return allowedTags.contains(s);
            }
        }, type);
    }

    public static void registerExtensionsForManifest(AndroidFacet facet, String tagName, ManifestElement element, MyCallback callback, Set<String> registeredSubtags, Set<XmlName> skippedNames, boolean processStaticallyDefinedElements) {
        Set subtagSet;
        SystemResourceManager manager;
        String styleableName = AndroidManifestUtils.getStyleableNameForElement(element);
        if (styleableName == null) {
            styleableName = AndroidManifestUtils.getStyleableNameByTagName(tagName);
        }
        HashSet<XmlName> newSkippedNames = new HashSet<XmlName>(skippedNames);
        if (!processStaticallyDefinedElements) {
            for (String attrName : AndroidManifestUtils.getStaticallyDefinedAttrs(element)) {
                newSkippedNames.add(new XmlName(attrName, "http://schemas.android.com/apk/res/android"));
            }
        }
        if ((manager = facet.getSystemResourceManager()) == null) {
            return;
        }
        AttributeDefinitions attrDefs = manager.getAttributeDefinitions();
        if (attrDefs == null) {
            return;
        }
        StyleableDefinition styleable = attrDefs.getStyleableByName(styleableName);
        if (styleable == null) {
            return;
        }
        AndroidDomExtender.registerStyleableAttributes(element, new StyleableDefinition[]{styleable}, "http://schemas.android.com/apk/res/android", callback, new MyAttributeProcessor(){

            @Override
            public void process(@NotNull XmlName attrName, @NotNull DomExtension extension, @NotNull DomElement element) {
                if (attrName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "org/jetbrains/android/dom/AndroidDomExtender$5", "process"));
                }
                if (extension == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/android/dom/AndroidDomExtender$5", "process"));
                }
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/dom/AndroidDomExtender$5", "process"));
                }
                if (AndroidManifestUtils.isRequiredAttribute(attrName, element)) {
                    extension.addCustomAnnotation((Annotation)((Object)new MyRequired()));
                }
            }
        }, newSkippedNames);
        if (!processStaticallyDefinedElements) {
            subtagSet = new HashSet();
            Collections.addAll(subtagSet, AndroidManifestUtils.getStaticallyDefinedSubtags(element));
        } else {
            subtagSet = Collections.emptySet();
        }
        for (StyleableDefinition child : styleable.getChildren()) {
            String childTagName = AndroidManifestUtils.getTagNameByStyleableName(child.getName());
            if (childTagName == null || subtagSet.contains(childTagName)) continue;
            AndroidDomExtender.registerSubtags(childTagName, ManifestElement.class, callback, registeredSubtags);
        }
    }

    public static void processAttrsAndSubtags(@NotNull AndroidDomElement element, @NotNull MyCallback callback, @NotNull AndroidFacet facet, boolean processAllExistingAttrsFirst, boolean processStaticallyDefinedElements) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/dom/AndroidDomExtender", "processAttrsAndSubtags"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/android/dom/AndroidDomExtender", "processAttrsAndSubtags"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/dom/AndroidDomExtender", "processAttrsAndSubtags"));
        }
        try {
            XmlTag tag = element.getXmlTag();
            HashSet<XmlName> skippedAttributes = processAllExistingAttrsFirst ? AndroidDomExtender.registerExistingAttributes(facet, tag, callback, element) : new HashSet<XmlName>();
            String tagName = tag.getName();
            HashSet<String> registeredSubtags = new HashSet<String>();
            if (element instanceof ManifestElement) {
                AndroidDomExtender.registerExtensionsForManifest(facet, tagName, (ManifestElement)element, callback, registeredSubtags, skippedAttributes, processStaticallyDefinedElements);
            } else if (element instanceof LayoutElement) {
                AndroidDomExtender.registerExtensionsForLayout(facet, tag, (LayoutElement)element, callback, registeredSubtags, skippedAttributes);
            } else if (element instanceof AnimationElement) {
                AndroidDomExtender.registerExtensionsForAnimation(facet, tagName, (AnimationElement)element, callback, registeredSubtags, skippedAttributes);
            } else if (element instanceof AnimatorElement) {
                AndroidDomExtender.registerExtensionsForAnimator(facet, tagName, (AnimatorElement)element, callback, registeredSubtags, skippedAttributes);
            } else if (element instanceof MenuElement) {
                String styleableName = StringUtil.capitalize((String)tagName);
                if (!styleableName.equals("Menu")) {
                    styleableName = "Menu" + styleableName;
                }
                AndroidDomExtender.registerAttributes(facet, (DomElement)element, styleableName, "android", callback, skippedAttributes);
            } else if (element instanceof XmlResourceElement) {
                AndroidDomExtender.registerExtensionsForXmlResources(facet, tag, (XmlResourceElement)element, callback, registeredSubtags, skippedAttributes);
            } else if (element instanceof DrawableDomElement || element instanceof ColorDomElement) {
                AndroidDomExtender.registerExtensionsForDrawable(facet, tagName, element, callback, skippedAttributes);
            } else if (element instanceof TransitionDomElement) {
                AndroidDomExtender.registerExtensionsForTransition(facet, tagName, (TransitionDomElement)element, callback, registeredSubtags, skippedAttributes);
            }
            if (!processStaticallyDefinedElements) {
                Collections.addAll(registeredSubtags, AndroidDomUtil.getStaticallyDefinedSubtags(element));
            }
        }
        catch (MyStopException myStopException) {
            // empty catch block
        }
    }

    private static void registerExtensionsForDrawable(AndroidFacet facet, String tagName, AndroidDomElement element, MyCallback callback, Set<XmlName> skipAttrNames) {
        String specialStyleableName = AndroidDrawableDomUtil.SPECIAL_STYLEABLE_NAMES.get(tagName);
        if (specialStyleableName != null) {
            AndroidDomExtender.registerAttributes(facet, (DomElement)element, specialStyleableName, "android", callback, skipAttrNames);
        }
        if (element instanceof DrawableStateListItem || element instanceof ColorStateListItem) {
            AndroidDomExtender.registerAttributes(facet, (DomElement)element, "DrawableStates", "android", callback, skipAttrNames);
            AttributeDefinitions attrDefs = AndroidDomExtender.getAttrDefs(facet);
            if (attrDefs != null) {
                AndroidDomExtender.registerAttributes(facet, (DomElement)element, attrDefs.getStateStyleables(), "android", callback, null, skipAttrNames);
            }
        } else if (element instanceof LayerListItem) {
            AndroidDomExtender.registerAttributes(facet, (DomElement)element, "LayerDrawableItem", "android", callback, skipAttrNames);
        } else if (element instanceof LevelListItem) {
            AndroidDomExtender.registerAttributes(facet, (DomElement)element, "LevelListDrawableItem", "android", callback, skipAttrNames);
        } else if (element instanceof AnimationListItem) {
            AndroidDomExtender.registerAttributes(facet, (DomElement)element, "AnimationDrawableItem", "android", callback, skipAttrNames);
        } else if (element instanceof AnimatedStateListTransition) {
            AndroidDomExtender.registerAttributes(facet, (DomElement)element, "AnimatedStateListDrawableTransition", "android", callback, skipAttrNames);
        } else if (element instanceof VectorPath) {
            AndroidDomExtender.registerAttributes(facet, (DomElement)element, "VectorDrawablePath", "android", callback, skipAttrNames);
        } else if (element instanceof VectorGroup) {
            AndroidDomExtender.registerAttributes(facet, (DomElement)element, "VectorDrawableGroup", "android", callback, skipAttrNames);
        } else if (element instanceof VectorClipPath) {
            AndroidDomExtender.registerAttributes(facet, (DomElement)element, "VectorDrawableClipPath", "android", callback, skipAttrNames);
        } else if (element instanceof AnimatedVectorTarget) {
            AndroidDomExtender.registerAttributes(facet, (DomElement)element, "AnimatedVectorDrawableTarget", "android", callback, skipAttrNames);
        }
    }

    public static void registerExtensionsForTransition(AndroidFacet facet, String tagName, TransitionDomElement element, MyCallback callback, Set<String> registeredSubTags, Set<XmlName> skipAttrNames) {
        if (tagName.equals("fade")) {
            AndroidDomExtender.registerTransition(facet, element, callback, registeredSubTags, skipAttrNames, "Fade");
        } else if (tagName.equals("transitionSet")) {
            AndroidDomExtender.registerTransition(facet, element, callback, registeredSubTags, skipAttrNames, "TransitionSet");
            AndroidDomExtender.registerSubtags("transitionSet", TransitionSet.class, callback, registeredSubTags);
            AndroidDomExtender.registerSubtags("fade", Fade.class, callback, registeredSubTags);
            AndroidDomExtender.registerSubtags("changeBounds", ChangeBounds.class, callback, registeredSubTags);
            AndroidDomExtender.registerSubtags("slide", Slide.class, callback, registeredSubTags);
            AndroidDomExtender.registerSubtags("explode", Explode.class, callback, registeredSubTags);
            AndroidDomExtender.registerSubtags("changeImageTransform", ChangeImageTransform.class, callback, registeredSubTags);
            AndroidDomExtender.registerSubtags("changeTransform", ChangeTransform.class, callback, registeredSubTags);
            AndroidDomExtender.registerSubtags("changeClipBounds", ChangeClipBounds.class, callback, registeredSubTags);
            AndroidDomExtender.registerSubtags("autoTransition", AutoTransition.class, callback, registeredSubTags);
            AndroidDomExtender.registerSubtags("recolor", Recolor.class, callback, registeredSubTags);
            AndroidDomExtender.registerSubtags("changeScroll", ChangeScroll.class, callback, registeredSubTags);
            AndroidDomExtender.registerSubtags("arcMotion", ArcMotion.class, callback, registeredSubTags);
            AndroidDomExtender.registerSubtags("pathMotion", PathMotion.class, callback, registeredSubTags);
            AndroidDomExtender.registerSubtags("patternPathMotion", PatternPathMotion.class, callback, registeredSubTags);
        } else if (tagName.equals("transitionManager")) {
            AndroidDomExtender.registerSubtags("transition", TransitionTag.class, callback, registeredSubTags);
        } else if (tagName.equals("transition")) {
            AndroidDomExtender.registerAttributes(facet, (DomElement)element, "TransitionManager", "android", callback, skipAttrNames);
        } else if (tagName.equals("targets")) {
            AndroidDomExtender.registerSubtags("target", Target.class, callback, registeredSubTags);
        } else if (tagName.equals("target")) {
            AndroidDomExtender.registerAttributes(facet, (DomElement)element, "TransitionTarget", "android", callback, skipAttrNames);
        } else if (tagName.equals("slide")) {
            AndroidDomExtender.registerTransition(facet, element, callback, registeredSubTags, skipAttrNames, "Slide");
        } else if (tagName.equals("changeTransform")) {
            AndroidDomExtender.registerTransition(facet, element, callback, registeredSubTags, skipAttrNames, "ChangeTransform");
        } else if (tagName.equals("arcMotion")) {
            AndroidDomExtender.registerTransition(facet, element, callback, registeredSubTags, skipAttrNames, "ArcMotion");
        } else if (tagName.equals("patternPathMotion")) {
            AndroidDomExtender.registerTransition(facet, element, callback, registeredSubTags, skipAttrNames, "PatternPathMotion");
        } else if (tagName.equals("autoTransition") || tagName.equals("changeBounds") || tagName.equals("explode") || tagName.equals("changeImageTransform") || tagName.equals("changeClipBounds") || tagName.equals("recolor") || tagName.equals("changeScroll") || tagName.equals("pathMotion")) {
            AndroidDomExtender.registerTransition(facet, element, callback, registeredSubTags, skipAttrNames, null);
        }
    }

    public static void registerTransition(AndroidFacet facet, TransitionDomElement element, MyCallback callback, Set<String> registeredSubTags, Set<XmlName> skipAttrNames, @Nullable String specific) {
        AndroidDomExtender.registerAttributes(facet, (DomElement)element, "Transition", "android", callback, skipAttrNames);
        if (specific != null) {
            AndroidDomExtender.registerAttributes(facet, (DomElement)element, specific, "android", callback, skipAttrNames);
        }
        AndroidDomExtender.registerSubtags("targets", Targets.class, callback, registeredSubTags);
    }

    @Nullable
    private static AttributeDefinitions getAttrDefs(AndroidFacet facet) {
        SystemResourceManager manager = facet.getSystemResourceManager();
        return manager != null ? manager.getAttributeDefinitions() : null;
    }

    private static void registerSubtags(@NotNull String name, Type type, MyCallback callback, Set<String> registeredTags) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/dom/AndroidDomExtender", "registerSubtags"));
        }
        callback.processSubtag(new XmlName(name), type);
        registeredTags.add(name);
    }

    private static void registerExistingSubtags(@NotNull XmlTag tag, @NotNull MyCallback callback, @Nullable Processor<String> filter, @NotNull Type type) {
        XmlTag[] subtags;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/jetbrains/android/dom/AndroidDomExtender", "registerExistingSubtags"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/android/dom/AndroidDomExtender", "registerExistingSubtags"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/dom/AndroidDomExtender", "registerExistingSubtags"));
        }
        for (XmlTag subtag : subtags = tag.getSubTags()) {
            String localName = subtag.getLocalName();
            if (filter != null && !filter.process((Object)localName) || localName.endsWith(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED)) continue;
            callback.processSubtag(new XmlName(localName), type);
        }
    }

    @NotNull
    private static Set<XmlName> registerExistingAttributes(AndroidFacet facet, XmlTag tag, MyCallback callback, AndroidDomElement element) {
        XmlAttribute[] attrs;
        HashSet<XmlName> result = new HashSet<XmlName>();
        for (XmlAttribute attr : attrs = tag.getAttributes()) {
            AttributeDefinition attrDef;
            String localName = attr.getLocalName();
            if (localName.endsWith(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED) || "xmlns".equals(attr.getNamespacePrefix()) || (attrDef = AndroidDomUtil.getAttributeDefinition(facet, attr)) == null) continue;
            String namespace = attr.getNamespace();
            result.add(new XmlName(attr.getLocalName(), attr.getNamespace()));
            AndroidDomExtender.registerAttribute(attrDef, null, namespace.length() > 0 ? namespace : null, callback, null, element);
        }
        HashSet<XmlName> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/AndroidDomExtender", "registerExistingAttributes"));
        }
        return hashSet;
    }

    public void registerExtensions(@NotNull AndroidDomElement element, final @NotNull DomExtensionsRegistrar registrar) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/dom/AndroidDomExtender", "registerExtensions"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/android/dom/AndroidDomExtender", "registerExtensions"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(element);
        if (facet == null) {
            return;
        }
        AndroidDomExtender.processAttrsAndSubtags(element, new MyCallback(){

            @Override
            @Nullable
            public DomExtension processAttribute(@NotNull XmlName xmlName, @NotNull AttributeDefinition attrDef, @Nullable String parentStyleableName) {
                if (xmlName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlName", "org/jetbrains/android/dom/AndroidDomExtender$6", "processAttribute"));
                }
                if (attrDef == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrDef", "org/jetbrains/android/dom/AndroidDomExtender$6", "processAttribute"));
                }
                Set<AttributeFormat> formats = attrDef.getFormats();
                Class valueClass = formats.size() == 1 ? AndroidDomExtender.getValueClass(formats.iterator().next()) : String.class;
                registrar.registerAttributeChildExtension(xmlName, GenericAttributeValue.class);
                return registrar.registerGenericAttributeValueChildExtension(xmlName, (Type)valueClass);
            }

            @Override
            public void processSubtag(@NotNull XmlName xmlName, @NotNull Type type) {
                if (xmlName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlName", "org/jetbrains/android/dom/AndroidDomExtender$6", "processSubtag"));
                }
                if (type == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/dom/AndroidDomExtender$6", "processSubtag"));
                }
                registrar.registerCollectionChildrenExtension(xmlName, type);
            }
        }, facet, true, false);
    }

    public static class MyCallback {
        protected void stop() {
            throw new MyStopException();
        }

        @Nullable
        DomExtension processAttribute(@NotNull XmlName xmlName, @NotNull AttributeDefinition attrDef, @Nullable String parentStyleableName) {
            if (xmlName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlName", "org/jetbrains/android/dom/AndroidDomExtender$MyCallback", "processAttribute"));
            }
            if (attrDef == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrDef", "org/jetbrains/android/dom/AndroidDomExtender$MyCallback", "processAttribute"));
            }
            return null;
        }

        void processSubtag(@NotNull XmlName xmlName, @NotNull Type type) {
            if (xmlName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlName", "org/jetbrains/android/dom/AndroidDomExtender$MyCallback", "processSubtag"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/dom/AndroidDomExtender$MyCallback", "processSubtag"));
            }
        }
    }

    private static class MyStopException
    extends RuntimeException {
        private MyStopException() {
        }
    }

    private static class MyRequired
    implements Required {
        private MyRequired() {
        }

        public boolean value() {
            return true;
        }

        public boolean nonEmpty() {
            return true;
        }

        public boolean identifier() {
            return false;
        }

        public Class<? extends Annotation> annotationType() {
            return Required.class;
        }
    }

    private static interface MyAttributeProcessor {
        public void process(@NotNull XmlName var1, @NotNull DomExtension var2, @NotNull DomElement var3);
    }
}

