/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.logcat;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.List;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="AndroidConfiguredLogFilters", storages={@Storage(file="$WORKSPACE_FILE$")})
public class AndroidConfiguredLogFilters
implements PersistentStateComponent<AndroidConfiguredLogFilters> {
    private List<MyFilterEntry> myFilterEntries = new ArrayList<MyFilterEntry>();

    public AndroidConfiguredLogFilters getState() {
        return this;
    }

    public void loadState(AndroidConfiguredLogFilters state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public static AndroidConfiguredLogFilters getInstance(Project project) {
        return (AndroidConfiguredLogFilters)ServiceManager.getService((Project)project, AndroidConfiguredLogFilters.class);
    }

    @Tag(value="filters")
    @AbstractCollection(surroundWithTag=false)
    public List<MyFilterEntry> getFilterEntries() {
        return new ArrayList<MyFilterEntry>(this.myFilterEntries);
    }

    @Nullable
    public MyFilterEntry findFilterEntryByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/logcat/AndroidConfiguredLogFilters", "findFilterEntryByName"));
        }
        for (MyFilterEntry entry : this.myFilterEntries) {
            if (!name.equals(entry.getName())) continue;
            return entry;
        }
        return null;
    }

    @NotNull
    public MyFilterEntry createFilterForProcess(int pid) {
        MyFilterEntry entry = new MyFilterEntry();
        String pidString = Integer.toString(pid);
        entry.setName("Process id: " + pidString);
        entry.setPid(pidString);
        MyFilterEntry myFilterEntry = entry;
        if (myFilterEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/logcat/AndroidConfiguredLogFilters", "createFilterForProcess"));
        }
        return myFilterEntry;
    }

    @Nullable
    @Contract(value="!null, true -> !null")
    public MyFilterEntry getFilterForPackage(@NotNull String packageName, boolean createIfNotExist) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/android/logcat/AndroidConfiguredLogFilters", "getFilterForPackage"));
        }
        String filterName = "app: " + packageName;
        MyFilterEntry entry = this.findFilterEntryByName(filterName);
        if (entry != null) {
            return entry;
        }
        if (createIfNotExist) {
            entry = new MyFilterEntry();
            entry.setName(filterName);
            entry.setPackageNamePattern(packageName);
            this.myFilterEntries.add(entry);
        }
        return entry;
    }

    public void setFilterEntries(List<MyFilterEntry> filterEntries) {
        this.myFilterEntries = filterEntries;
    }

    @JdkConstants.PatternFlags
    static int getPatternCompileFlags(@NotNull String regex) {
        if (regex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regex", "org/jetbrains/android/logcat/AndroidConfiguredLogFilters", "getPatternCompileFlags"));
        }
        for (char c : regex.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            return 0;
        }
        return 2;
    }

    @Tag(value="filter")
    public static class MyFilterEntry {
        private String myName;
        private String myLogMessagePattern;
        private String myLogLevel;
        private String myLogTagPattern;
        private String myPid;
        private String myPackageNamePattern;

        public String getName() {
            return this.myName;
        }

        public String getLogMessagePattern() {
            return this.myLogMessagePattern;
        }

        public String getLogLevel() {
            return this.myLogLevel;
        }

        public String getLogTagPattern() {
            return this.myLogTagPattern;
        }

        public String getPid() {
            return this.myPid;
        }

        public void setName(String name) {
            this.myName = name;
        }

        public void setLogMessagePattern(String logMessagePattern) {
            this.myLogMessagePattern = logMessagePattern;
        }

        public void setLogLevel(String logLevel) {
            this.myLogLevel = logLevel;
        }

        public void setLogTagPattern(String logTagPattern) {
            this.myLogTagPattern = logTagPattern;
        }

        public void setPid(String pid) {
            this.myPid = pid;
        }

        public String getPackageNamePattern() {
            return this.myPackageNamePattern;
        }

        public void setPackageNamePattern(String packageNamePattern) {
            this.myPackageNamePattern = packageNamePattern;
        }
    }
}

