/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.descriptors;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.Validator;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.FxmlConstants;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxDefaultAttributeDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxDefaultPropertyElementDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyAttributeDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyElementDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxSetterAttributeDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxStaticPropertyAttributeDescriptor;

public class JavaFxClassBackedElementDescriptor
implements XmlElementDescriptor,
Validator<XmlTag> {
    private final PsiClass myPsiClass;
    private final String myName;

    public JavaFxClassBackedElementDescriptor(String name, XmlTag tag) {
        this(name, JavaFxPsiUtil.findPsiClass(name, (PsiElement)tag));
    }

    public JavaFxClassBackedElementDescriptor(String name, PsiClass aClass) {
        this.myName = name;
        this.myPsiClass = aClass;
    }

    public String getQualifiedName() {
        return this.myPsiClass != null ? this.myPsiClass.getQualifiedName() : this.getName();
    }

    public String getDefaultName() {
        return this.getName();
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context) {
        if (context != null && this.myPsiClass != null) {
            ArrayList<XmlElementDescriptor> children = new ArrayList<XmlElementDescriptor>();
            this.collectProperties(children, new Function<PsiMember, XmlElementDescriptor>(){

                public XmlElementDescriptor fun(PsiMember member) {
                    return new JavaFxPropertyElementDescriptor(JavaFxClassBackedElementDescriptor.this.myPsiClass, member instanceof PsiMethod ? PropertyUtil.getPropertyName((PsiMember)member) : member.getName(), false);
                }
            }, false);
            JavaFxPropertyElementDescriptor defaultPropertyDescriptor = this.getDefaultPropertyDescriptor();
            if (defaultPropertyDescriptor != null) {
                Collections.addAll(children, defaultPropertyDescriptor.getElementsDescriptors(context));
            } else {
                for (String name : FxmlConstants.FX_DEFAULT_ELEMENTS) {
                    children.add(new JavaFxDefaultPropertyElementDescriptor(name, null));
                }
            }
            JavaFxClassBackedElementDescriptor.collectStaticElementDescriptors(context, children);
            if (!children.isEmpty()) {
                return children.toArray(new XmlElementDescriptor[children.size()]);
            }
        }
        return XmlElementDescriptor.EMPTY_ARRAY;
    }

    private JavaFxPropertyElementDescriptor getDefaultPropertyDescriptor() {
        Object value;
        PsiAnnotationMemberValue defaultPropertyAttributeValue;
        PsiAnnotation defaultProperty = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)this.myPsiClass, Collections.singleton("javafx.beans.DefaultProperty"));
        if (defaultProperty != null && (defaultPropertyAttributeValue = defaultProperty.findAttributeValue("value")) instanceof PsiLiteralExpression && (value = ((PsiLiteralExpression)defaultPropertyAttributeValue).getValue()) instanceof String) {
            return new JavaFxPropertyElementDescriptor(this.myPsiClass, (String)value, false);
        }
        return null;
    }

    static void collectStaticAttributesDescriptors(@Nullable XmlTag context, List<XmlAttributeDescriptor> simpleAttrs) {
        if (context == null) {
            return;
        }
        JavaFxClassBackedElementDescriptor.collectParentStaticProperties(context.getParentTag(), simpleAttrs, new Function<PsiMethod, XmlAttributeDescriptor>(){

            public XmlAttributeDescriptor fun(PsiMethod method) {
                return new JavaFxSetterAttributeDescriptor(method, method.getContainingClass());
            }
        });
    }

    protected static void collectStaticElementDescriptors(XmlTag context, List<XmlElementDescriptor> children) {
        JavaFxClassBackedElementDescriptor.collectParentStaticProperties(context, children, new Function<PsiMethod, XmlElementDescriptor>(){

            public XmlElementDescriptor fun(PsiMethod method) {
                PsiClass aClass = method.getContainingClass();
                return new JavaFxPropertyElementDescriptor(aClass, PropertyUtil.getPropertyName((String)method.getName()), true);
            }
        });
    }

    private static <T> void collectParentStaticProperties(XmlTag context, List<T> children, Function<PsiMethod, T> factory) {
        for (XmlTag tag = context; tag != null; tag = tag.getParentTag()) {
            PsiElement element;
            XmlElementDescriptor descr = tag.getDescriptor();
            if (!(descr instanceof JavaFxClassBackedElementDescriptor) || !((element = descr.getDeclaration()) instanceof PsiClass)) continue;
            List setters = (List)CachedValuesManager.getCachedValue((PsiElement)element, (CachedValueProvider)new CachedValueProvider<List<PsiMethod>>(){

                @Nullable
                public CachedValueProvider.Result<List<PsiMethod>> compute() {
                    ArrayList<PsiMethod> meths = new ArrayList<PsiMethod>();
                    for (PsiMethod method : ((PsiClass)element).getAllMethods()) {
                        PsiParameter[] parameters;
                        if (!method.hasModifierProperty("static") || !method.getName().startsWith("set") || (parameters = method.getParameterList().getParameters()).length != 2 || !InheritanceUtil.isInheritor((PsiType)parameters[0].getType(), (String)"javafx.scene.Node")) continue;
                        meths.add(method);
                    }
                    return CachedValueProvider.Result.create(meths, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
                }
            });
            for (PsiMethod setter : setters) {
                children.add(factory.fun((Object)setter));
            }
        }
    }

    @Nullable
    public XmlElementDescriptor getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        String name = childTag.getName();
        if (FxmlConstants.FX_DEFAULT_ELEMENTS.contains(name)) {
            return new JavaFxDefaultPropertyElementDescriptor(name, childTag);
        }
        String shortName = StringUtil.getShortName((String)name);
        if (!name.equals(shortName)) {
            PsiMethod propertySetter = JavaFxPsiUtil.findPropertySetter(name, childTag);
            if (propertySetter != null) {
                return new JavaFxPropertyElementDescriptor(propertySetter.getContainingClass(), shortName, true);
            }
            Project project = childTag.getProject();
            if (JavaPsiFacade.getInstance((Project)project).findClass(name, GlobalSearchScope.allScope((Project)project)) == null) {
                return null;
            }
        }
        String parentTagName = contextTag.getName();
        if (this.myPsiClass != null && !"fx:define".equals(parentTagName)) {
            JavaFxPropertyElementDescriptor elementDescriptor = new JavaFxPropertyElementDescriptor(this.myPsiClass, name, false);
            if ("fx:root".equals(parentTagName)) {
                PsiField fieldByName = this.myPsiClass.findFieldByName(name, true);
                if (fieldByName != null) {
                    return elementDescriptor;
                }
            } else {
                XmlElementDescriptor childDescriptor;
                String defaultPropertyName;
                JavaFxPropertyElementDescriptor defaultPropertyDescriptor = this.getDefaultPropertyDescriptor();
                if (defaultPropertyDescriptor != null && StringUtil.equalsIgnoreCase((CharSequence)(defaultPropertyName = defaultPropertyDescriptor.getName()), (CharSequence)name) && !StringUtil.equals((CharSequence)defaultPropertyName, (CharSequence)name) && (childDescriptor = defaultPropertyDescriptor.getElementDescriptor(childTag, contextTag)) != null) {
                    return childDescriptor;
                }
                PsiElement declaration = elementDescriptor.getDeclaration();
                if (declaration != null) {
                    if (declaration instanceof PsiField && ((PsiField)declaration).getType() instanceof PsiPrimitiveType) {
                        return null;
                    }
                    return elementDescriptor;
                }
            }
        }
        return new JavaFxClassBackedElementDescriptor(name, childTag);
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        String name;
        if (context != null && Comparing.equal((String)(name = context.getName()), (String)this.getName()) && this.myPsiClass != null) {
            ArrayList<XmlAttributeDescriptor> simpleAttrs = new ArrayList<XmlAttributeDescriptor>();
            this.collectInstanceProperties(simpleAttrs);
            JavaFxClassBackedElementDescriptor.collectStaticAttributesDescriptors(context, simpleAttrs);
            for (String defaultProperty : FxmlConstants.FX_DEFAULT_PROPERTIES) {
                simpleAttrs.add((XmlAttributeDescriptor)new JavaFxDefaultAttributeDescriptor(defaultProperty, this.myPsiClass));
            }
            return simpleAttrs.isEmpty() ? XmlAttributeDescriptor.EMPTY : simpleAttrs.toArray(new XmlAttributeDescriptor[simpleAttrs.size()]);
        }
        return XmlAttributeDescriptor.EMPTY;
    }

    protected void collectInstanceProperties(List<XmlAttributeDescriptor> simpleAttrs) {
        this.collectProperties(simpleAttrs, new Function<PsiMember, XmlAttributeDescriptor>(){

            public XmlAttributeDescriptor fun(PsiMember member) {
                return new JavaFxPropertyAttributeDescriptor(member instanceof PsiMethod ? PropertyUtil.getPropertyName((PsiMember)member) : member.getName(), JavaFxClassBackedElementDescriptor.this.myPsiClass);
            }
        }, true);
    }

    private <T> void collectProperties(List<T> children, Function<PsiMember, T> factory, final boolean acceptPrimitive) {
        List fieldList;
        List list = fieldList = this.myPsiClass == null ? null : (List)CachedValuesManager.getCachedValue((PsiElement)this.myPsiClass, (CachedValueProvider)new CachedValueProvider<List<PsiMember>>(){

            @Nullable
            public CachedValueProvider.Result<List<PsiMember>> compute() {
                ArrayList<PsiField> acceptableFields = new ArrayList<PsiField>();
                PsiField[] fields = JavaFxClassBackedElementDescriptor.this.myPsiClass.getAllFields();
                if (fields.length > 0) {
                    for (PsiField psiField : fields) {
                        if (psiField.hasModifierProperty("static")) continue;
                        PsiType fieldType = psiField.getType();
                        if ((JavaFxPsiUtil.isReadOnly(JavaFxClassBackedElementDescriptor.this.myPsiClass, psiField) || !InheritanceUtil.isInheritor((PsiType)fieldType, (String)"javafx.beans.property.Property")) && !this.acceptablePropertyType(fieldType)) continue;
                        acceptableFields.add(psiField);
                    }
                }
                for (PsiField psiField : JavaFxClassBackedElementDescriptor.this.myPsiClass.getAllMethods()) {
                    if (!PropertyUtil.isSimplePropertySetter((PsiMethod)psiField) || psiField.hasModifierProperty("static")) continue;
                    String propertyName = PropertyUtil.getPropertyName((PsiMethod)psiField);
                    assert (propertyName != null);
                    PsiParameter[] parameters = psiField.getParameterList().getParameters();
                    if (parameters.length != 1 || JavaFxClassBackedElementDescriptor.this.myPsiClass.findFieldByName(propertyName, true) != null) continue;
                    PsiType propertyType = parameters[0].getType();
                    String suggestedGetterName = PropertyUtil.suggestGetterName((String)propertyName, (PsiType)propertyType);
                    if (JavaFxClassBackedElementDescriptor.this.myPsiClass.findMethodsByName(suggestedGetterName, true).length == 0 || !this.acceptablePropertyType(propertyType)) continue;
                    acceptableFields.add(psiField);
                }
                return CachedValueProvider.Result.create(acceptableFields, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }

            private boolean acceptablePropertyType(PsiType fieldType) {
                return fieldType.equalsToText("java.lang.String") || acceptPrimitive && fieldType instanceof PsiPrimitiveType || InheritanceUtil.isInheritor((PsiType)fieldType, (String)"javafx.collections.ObservableList") && JavaGenericsUtil.getCollectionItemType((PsiType)fieldType, (GlobalSearchScope)JavaFxClassBackedElementDescriptor.this.myPsiClass.getResolveScope()) != null || InheritanceUtil.isInheritor((PsiType)fieldType, (String)"javafx.event.EventHandler");
            }
        });
        if (fieldList != null) {
            for (PsiMember field : fieldList) {
                children.add(factory.fun((Object)field));
            }
        }
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(@NonNls String attributeName, @Nullable XmlTag context) {
        if (this.myPsiClass == null) {
            return null;
        }
        if (this.myPsiClass.findFieldByName(attributeName, true) == null) {
            if (FxmlConstants.FX_DEFAULT_PROPERTIES.contains(attributeName)) {
                return new JavaFxDefaultAttributeDescriptor(attributeName, this.myPsiClass);
            }
            PsiMethod propertySetter = JavaFxPsiUtil.findPropertySetter(attributeName, context);
            if (propertySetter != null) {
                return new JavaFxStaticPropertyAttributeDescriptor(propertySetter, attributeName);
            }
            PsiMethod getter = JavaFxPsiUtil.findPropertyGetter(attributeName, this.myPsiClass);
            if (getter != null) {
                return new JavaFxPropertyAttributeDescriptor(attributeName, this.myPsiClass);
            }
            return null;
        }
        return new JavaFxPropertyAttributeDescriptor(attributeName, this.myPsiClass);
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        return this.getAttributeDescriptor(attribute.getName(), attribute.getParent());
    }

    public XmlNSDescriptor getNSDescriptor() {
        return null;
    }

    @Nullable
    public XmlElementsGroup getTopGroup() {
        return null;
    }

    public int getContentType() {
        return -1;
    }

    @Nullable
    public String getDefaultValue() {
        return null;
    }

    public PsiElement getDeclaration() {
        return this.myPsiClass;
    }

    public String getName(PsiElement context) {
        return this.getName();
    }

    public String getName() {
        return this.myName;
    }

    public void init(PsiElement element) {
    }

    public Object[] getDependences() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public void validate(@NotNull XmlTag context, @NotNull Validator.ValidationHost host) {
        String message;
        XmlAttribute attribute;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxClassBackedElementDescriptor", "validate"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxClassBackedElementDescriptor", "validate"));
        }
        XmlTag parentTag = context.getParentTag();
        if (parentTag != null && (attribute = context.getAttribute("fx:controller")) != null) {
            host.addMessage((PsiElement)attribute.getNameElement(), "fx:controller can only be applied to root element", Validator.ValidationHost.ErrorType.ERROR);
        }
        PsiClass aClass = this.myPsiClass;
        XmlAttribute constAttr = context.getAttribute("fx:constant");
        if (constAttr != null) {
            PsiField constField = aClass.findFieldByName(constAttr.getValue(), false);
            if (constField != null) {
                aClass = PsiUtil.resolveClassInType((PsiType)constField.getType());
            }
        } else {
            XmlAttributeValue valueElement;
            XmlAttribute factoryAttr = context.getAttribute("fx:factory");
            if (factoryAttr != null && (valueElement = factoryAttr.getValueElement()) != null) {
                PsiElement staticFactoryMethod;
                PsiReference reference = valueElement.getReference();
                PsiElement psiElement = staticFactoryMethod = reference != null ? reference.resolve() : null;
                if (staticFactoryMethod instanceof PsiMethod && ((PsiMethod)staticFactoryMethod).getParameterList().getParametersCount() == 0 && ((PsiMethod)staticFactoryMethod).hasModifierProperty("static")) {
                    aClass = PsiUtil.resolveClassInType((PsiType)((PsiMethod)staticFactoryMethod).getReturnType());
                }
            }
        }
        String canCoerceError = JavaFxPsiUtil.isClassAcceptable(parentTag, aClass);
        if (canCoerceError != null) {
            host.addMessage(context.getNavigationElement(), canCoerceError, Validator.ValidationHost.ErrorType.ERROR);
        }
        if (aClass != null && aClass.isValid() && (message = JavaFxPsiUtil.isAbleToInstantiate(aClass)) != null) {
            host.addMessage((PsiElement)context, message, Validator.ValidationHost.ErrorType.ERROR);
        }
    }
}

