/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkout;

import com.intellij.dvcs.DvcsRememberedInputs;
import com.intellij.dvcs.ui.CloneDvcsDialog;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.project.Project;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitTask;
import git4idea.commands.GitTaskResult;
import git4idea.remote.GitRememberedInputs;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCloneDialog
extends CloneDvcsDialog {
    public GitCloneDialog(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/checkout/GitCloneDialog", "<init>"));
        }
        this(project, null);
    }

    public GitCloneDialog(@NotNull Project project, @Nullable String defaultUrl) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/checkout/GitCloneDialog", "<init>"));
        }
        super(project, "Git", ".git", defaultUrl);
    }

    protected boolean test(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "git4idea/checkout/GitCloneDialog", "test"));
        }
        GitLineHandler handler = new GitLineHandler(this.myProject, new File("."), GitCommand.LS_REMOTE);
        handler.setUrl(url);
        handler.addParameters(url, "master");
        GitTask task = new GitTask(this.myProject, handler, DvcsBundle.message((String)"clone.testing", (Object[])new Object[]{url}));
        GitTaskResult result = task.executeModal();
        return result.isOK();
    }

    @NotNull
    protected DvcsRememberedInputs getRememberedInputs() {
        DvcsRememberedInputs dvcsRememberedInputs = GitRememberedInputs.getInstance();
        if (dvcsRememberedInputs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkout/GitCloneDialog", "getRememberedInputs"));
        }
        return dvcsRememberedInputs;
    }

    protected String getDimensionServiceKey() {
        return "GitCloneDialog";
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.CloneRepository";
    }
}

