/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.TestClassFilter;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationUtil {
    public static boolean findAllTestClasses(final TestClassFilter testClassFilter, final Set<PsiClass> found) {
        PsiMethod[] suiteMethods;
        PsiManager manager = testClassFilter.getPsiManager();
        final Project project = manager.getProject();
        GlobalSearchScope projectScopeWithoutLibraries = GlobalSearchScope.projectScope((Project)project);
        final GlobalSearchScope scope = projectScopeWithoutLibraries.intersectWith(testClassFilter.getScope());
        ClassInheritorsSearch.search((PsiClass)testClassFilter.getBase(), (SearchScope)scope, (boolean)true, (boolean)true, (boolean)false).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)new PsiElementProcessor<PsiClass>(){

            public boolean execute(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/execution/ConfigurationUtil$1", "execute"));
                }
                if (testClassFilter.isAccepted(aClass)) {
                    found.add(aClass);
                }
                return true;
            }
        }));
        for (final PsiMethod method : suiteMethods = (PsiMethod[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiMethod[]>(){

            public PsiMethod[] compute() {
                return PsiShortNamesCache.getInstance((Project)project).getMethodsByName("suite", scope);
            }
        })) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    PsiClass containingClass = method.getContainingClass();
                    if (containingClass == null) {
                        return;
                    }
                    if (containingClass instanceof PsiAnonymousClass) {
                        return;
                    }
                    if (containingClass.hasModifierProperty("abstract")) {
                        return;
                    }
                    if (containingClass.getContainingClass() != null && !containingClass.hasModifierProperty("static")) {
                        return;
                    }
                    if (JUnitUtil.isSuiteMethod((PsiMethod)method) && testClassFilter.isAccepted(containingClass)) {
                        found.add(containingClass);
                    }
                }
            });
        }
        HashSet processed = ContainerUtil.newHashSet();
        boolean hasJunit4 = ConfigurationUtil.addAnnotatedMethodsAnSubclasses(manager, scope, testClassFilter, found, processed, "org.junit.Test", true);
        return hasJunit4 |= ConfigurationUtil.addAnnotatedMethodsAnSubclasses(manager, scope, testClassFilter, found, processed, "org.junit.runner.RunWith", false);
    }

    private static boolean addAnnotatedMethodsAnSubclasses(final PsiManager manager, final GlobalSearchScope scope, final TestClassFilter testClassFilter, final Set<PsiClass> found, final Set<PsiClass> processed, final String annotation, final boolean isMethod) {
        final Ref isJUnit4 = new Ref((Object)Boolean.FALSE);
        PsiClass testAnnotation = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            @Nullable
            public PsiClass compute() {
                return JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(annotation, GlobalSearchScope.allScope((Project)manager.getProject()));
            }
        });
        if (testAnnotation != null) {
            AnnotatedMembersSearch.search((PsiClass)testAnnotation, (SearchScope)GlobalSearchScope.allScope((Project)manager.getProject())).forEach((Processor)new Processor<PsiMember>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean process(PsiMember annotated) {
                    PsiClass containingClass;
                    AccessToken token = ReadAction.start();
                    try {
                        PsiClass psiClass = containingClass = annotated instanceof PsiClass ? (PsiClass)annotated : annotated.getContainingClass();
                        if (containingClass == null || annotated instanceof PsiMethod != isMethod) {
                            boolean bl = true;
                            return bl;
                        }
                        if (!processed.add(containingClass)) {
                            boolean bl = true;
                            return bl;
                        }
                        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)containingClass);
                        if (file != null && scope.contains(file) && testClassFilter.isAccepted(containingClass)) {
                            if (!found.add(containingClass)) {
                                boolean bl = true;
                                return bl;
                            }
                            isJUnit4.set((Object)Boolean.TRUE);
                        }
                    }
                    finally {
                        token.finish();
                    }
                    ClassInheritorsSearch.search((PsiClass)containingClass, (SearchScope)scope, (boolean)true, (boolean)true, (boolean)false).forEach((Processor)new ReadActionProcessor<PsiClass>(){

                        public boolean processInReadAction(PsiClass aClass) {
                            if (testClassFilter.isAccepted(aClass)) {
                                found.add(aClass);
                                processed.add(aClass);
                                isJUnit4.set((Object)Boolean.TRUE);
                            }
                            return true;
                        }
                    });
                    return true;
                }
            });
        }
        return (Boolean)isJUnit4.get();
    }
}

