/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.junit.InheritorChooser;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.PatternConfigurationProducer;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Iterator;
import java.util.List;

public class TestMethodConfigurationProducer
extends JUnitConfigurationProducer {
    protected boolean setupConfigurationFromContext(JUnitConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        if (((PatternConfigurationProducer)RunConfigurationProducer.getInstance(PatternConfigurationProducer.class)).isMultipleElementsSelected(context)) {
            return false;
        }
        Location contextLocation = context.getLocation();
        assert (contextLocation != null);
        MethodLocation methodLocation = TestMethodConfigurationProducer.getTestMethod(contextLocation);
        if (methodLocation == null) {
            return false;
        }
        if (contextLocation instanceof PsiMemberParameterizedLocation) {
            PsiClass containingClass;
            String paramSetName = ((PsiMemberParameterizedLocation)contextLocation).getParamSetName();
            if (paramSetName != null) {
                configuration.setProgramParameters(paramSetName);
            }
            if ((containingClass = ((PsiMemberParameterizedLocation)contextLocation).getContainingClass()) != null) {
                methodLocation = MethodLocation.elementInClass((PsiMethod)((PsiMethod)methodLocation.getPsiElement()), (PsiClass)containingClass);
            }
        }
        sourceElement.set((Object)methodLocation.getPsiElement());
        this.setupConfigurationModule(context, (ModuleBasedConfiguration)configuration);
        Module originalModule = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        configuration.beMethodConfiguration((Location<PsiMethod>)methodLocation);
        configuration.restoreOriginalModule(originalModule);
        JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, contextLocation);
        configuration.setForkMode("none");
        return true;
    }

    private static Location<PsiMethod> getTestMethod(Location<?> location) {
        Iterator iterator = location.getAncestors(PsiMethod.class, false);
        while (iterator.hasNext()) {
            Location methodLocation = (Location)iterator.next();
            if (!JUnitUtil.isTestMethod((Location)methodLocation, (boolean)false)) continue;
            return methodLocation;
        }
        return null;
    }

    public void onFirstRun(final ConfigurationFromContext fromContext, ConfigurationContext context, Runnable performRunnable) {
        PsiClass containingClass;
        InheritorChooser inheritorChooser = new InheritorChooser(){

            protected void runForClasses(List<PsiClass> classes, PsiMethod method, ConfigurationContext context, Runnable performRunnable) {
                ((JUnitConfiguration)fromContext.getConfiguration()).bePatternConfiguration(classes, method);
                super.runForClasses(classes, method, context, performRunnable);
            }

            protected void runForClass(PsiClass aClass, PsiMethod psiMethod, ConfigurationContext context, Runnable performRunnable) {
                Project project = psiMethod.getProject();
                MethodLocation methodLocation = new MethodLocation(project, psiMethod, PsiLocation.fromPsiElement((PsiElement)aClass));
                ((JUnitConfiguration)fromContext.getConfiguration()).beMethodConfiguration((Location<PsiMethod>)methodLocation);
                super.runForClass(aClass, psiMethod, context, performRunnable);
            }
        };
        PsiMethod psiMethod = (PsiMethod)fromContext.getSourceElement();
        if (inheritorChooser.runMethodInAbstractClass(context, performRunnable, psiMethod, containingClass = psiMethod.getContainingClass(), this.getConditionToSearchForInheritors())) {
            return;
        }
        super.onFirstRun(fromContext, context, performRunnable);
    }
}

