/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.keychain;

import com.intellij.openapi.util.PasswordUtil;
import gnu.trove.THashMap;
import java.util.Map;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.keychain.Credentials;
import org.jetbrains.keychain.CredentialsStore;
import org.jetbrains.keychain.OSXKeychainLibrary;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\t\u0006)\u0019rj\u001d-De\u0016$WM\u001c;jC2\u001c8\u000b^8sK*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(\u0002C6fs\u000eD\u0017-\u001b8\u000b!\r\u0013X\rZ3oi&\fGn]*u_J,'B\u0002\u001fj]&$hHC\u0006tKJ4\u0018nY3OC6,'BB*ue&twM\u0003\u0004l_Rd\u0017N\u001c\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'\u0002F1dG>,h\u000e\u001e+p\u0007J,G-\u001a8uS\u0006d7O\u0003\u0005U\u0011\u0006\u001c\b.T1q\u0015\r9g.\u001e\u0006\u0006iJ|g/\u001a\u0006\f\u0007J,G-\u001a8uS\u0006d7OC\u0005CsR,\u0017I\u001d:bs*\u0019q-\u001a;\u000b\t!|7\u000f\u001e\u0006\u000bgND7*Z=GS2,'BD4fiN+'O^5dK:\u000bW.\u001a\u0006\u0006e\u0016\u001cX\r\u001e\u0006\u0005+:LGO\u0003\u0003tCZ,'bC2sK\u0012,g\u000e^5bYNT\u0011bQ8na\u0006t\u0017n\u001c8s\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQa\u0001\u0003\u0002\u0011\u0001a\u0001!B\u0002\u0005\u0003!\u0011A\u0002A\u0003\u0002\u0011\u0011)1\u0001\"\u0002\t\b1\u0001Q!\u0001E\u0005\u000b\t!9\u0001C\u0003\u0006\u0005\u0011!\u0001rA\u0003\u0002\u0011\u001b)!\u0001B\u0003\t\u000f\u0015\u0019A1\u0002\u0005\u0007\u0019\u0001)1\u0001B\u0001\t\u00101\u0001QA\u0001C\u0006\u0011\u0019)1\u0001\"\u0002\t\u00111\u0001QA\u0001\u0003\u0002\u0011\u001f)1\u0001\"\u0002\t\u00171\u0001A\u0001\u0001G\u0002!3I\"!B\u0001\t\u0005qeQf\u0005\u0003b\ta-\u0011EC\u0003\u0002\u0011\u0019I1!\u0003\u0002\u0006\u0003!\u0019\u0011bA\u0005\u0003\u000b\u0005Ai!V\u0002\u0005\u000b\r!Y!C\u0001\t\u000f5bA!\u0019\u0003\u0019\u0007\u0005\u0012Q!\u0001E\b+\u000e)Q\u0001\u0002\u0003\u0004\u0013\t!\u0019\u0001$\u0001.@\u0011Y\u0001\u0014CO\b\t\u0001A\u0011\"D\u0002\u0006\u0003!\u0019A\u0012\u0001)\u0004\u0001u=A\u0001\u0001E\n\u001b\r)\u0011\u0001C\u0002\r\u0002A\u001b\t!I\u0002\u0006\u0003!5A\u0012A)\u0004\u000f\u0011E\u0011\"\u0001\u0005\t\u001b\u0005AI!D\u0001\t\n5*B!\u0001\r\u000b;\u001f!\u0001\u0001c\u0005\u000e\u0007\u0015\t\u0001b\u0001G\u0001!\u000e\u0001\u0011EA\u0003\u0002\u0011\u001f\t6A\u0002\u0003\u000b\u0013\t!\u0019\u0001$\u0001\u000e\u0003!%Qf\u0005\u0003\f1+ij\u0001\u0002\u0001\t\u00135\u0011Q!\u0001\u0005\u0004!\u000e\u0001\u0011EA\u0003\u0002\u0011#\t6!\u0002C\u000b\u0013\u0005!\u0001!D\u0001\t\n5BCa\u0003M\f;\u001f!\u0001\u0001C\u0005\u000e\u0007\u0015\t\u0001b\u0001G\u0001!\u000e\u0001QT\u0002\u0003\u0001\u00111i!!B\u0001\t\u000eA\u001b\t!h\u0004\u0005\u0001!MQbA\u0003\u0002\u0011\ra\t\u0001U\u0002\u0002C\t)\u0011\u0001#\u0005R\u0007%!9\"C\u0001\u0005\u00015\t\u0001\u0012B\u0007\u0002\u0011!i\u0011\u0001#\u00036*\u0015\u001dBa9\u0001\u0019\u0006u5A\u0001\u0001\u0005\u0004\u001b\t)\u0011\u0001C\u0002Q\u0007\u0001\t#!B\u0001\t\u0004E\u001bQ\u0001\"\u0002\n\u0003\u0011\u0001Q\"\u0001E\u0005"})
public final class OsXCredentialsStore
implements CredentialsStore {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    public static final byte[] SSH;
    private final byte[] serviceName;
    private final THashMap<String, Credentials> accountToCredentials;
    public static final Companion Companion;
    @Deprecated
    public static final Companion OBJECT$;

    static {
        $kotlinClass = Reflection.createKotlinClass(OsXCredentialsStore.class);
        OBJECT$ = Companion = org.jetbrains.keychain.OsXCredentialsStore$Companion.access$init$0();
        SSH = KotlinPackage.toByteArray$default((String)"SSH", null, (int)1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Credentials get(@JetValueParameter(name="host", type="?") @Nullable String host, @JetValueParameter(name="sshKeyFile", type="?") @Nullable String sshKeyFile) {
        if (host == null) {
            return null;
        }
        String string = sshKeyFile;
        if (string == null) {
            string = host;
        }
        String accountName = string;
        Credentials credentials = (Credentials)this.accountToCredentials.get((Object)accountName);
        if (credentials != null) {
            return credentials;
        }
        String string2 = OSXKeychainLibrary.Companion.findGenericPassword(this.getServiceName(sshKeyFile), accountName);
        if (string2 == null) {
            return null;
        }
        String data2 = string2;
        if (sshKeyFile == null) {
            int separatorIndex = KotlinPackage.indexOf$default((String)data2, (char)'@', (int)0, (boolean)false, (int)6);
            if (separatorIndex <= 0) return null;
            String username = PasswordUtil.decodePassword((String)KotlinPackage.substring((String)data2, (int)0, (int)separatorIndex));
            String password = PasswordUtil.decodePassword((String)KotlinPackage.substring((String)data2, (int)(separatorIndex + 1)));
            credentials = new Credentials(username, password);
        } else {
            credentials = new Credentials(sshKeyFile, data2);
        }
        KotlinPackage.set((Map)((Map)this.accountToCredentials), (Object)accountName, (Object)credentials);
        return credentials;
    }

    private final byte[] getServiceName(@JetValueParameter(name="sshKeyFile", type="?") String sshKeyFile) {
        return sshKeyFile == null ? this.serviceName : Companion.getSSH();
    }

    @Override
    public void save(@JetValueParameter(name="host", type="?") @Nullable String host, @JetValueParameter(name="credentials") @NotNull Credentials credentials, @JetValueParameter(name="sshKeyFile", type="?") @Nullable String sshKeyFile) {
        String string;
        String accountName;
        Credentials oldCredentials;
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        String string2 = sshKeyFile;
        if (string2 == null && (string2 = host) == null) {
            Intrinsics.throwNpe();
        }
        if (credentials.equals(oldCredentials = (Credentials)this.accountToCredentials.put((Object)(accountName = string2), (Object)credentials))) {
            return;
        }
        if (sshKeyFile == null) {
            string = PasswordUtil.encodePassword((String)credentials.getId()) + "@" + PasswordUtil.encodePassword((String)credentials.getToken());
        } else {
            string = credentials.getToken();
            if (string == null) {
                Intrinsics.throwNpe();
            }
        }
        String data2 = string;
        OSXKeychainLibrary.Companion.saveGenericPassword(this.getServiceName(sshKeyFile), accountName, data2);
    }

    @Override
    public void reset(@JetValueParameter(name="host") @NotNull String host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        if (this.accountToCredentials.remove((Object)host) != null) {
            OSXKeychainLibrary.Companion.deleteGenericPassword(this.serviceName, host);
        }
    }

    public OsXCredentialsStore(@JetValueParameter(name="serviceName") @NotNull String serviceName) {
        Intrinsics.checkParameterIsNotNull((Object)serviceName, (String)"serviceName");
        this.serviceName = KotlinPackage.toByteArray$default((String)serviceName, null, (int)1);
        this.accountToCredentials = new THashMap();
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"`\u0015%\u0019u.\u001c9b]&|gNC\nPgb\u001b%/\u001a3f]RL\u0017\r\\:Ti>\u0014XMC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\u0011-,\u0017p\u00195bS:T1!\u00118z\u0015\u0019Yw\u000e\u001e7j]*\u00191k\u0015%\u000b\u0013\tKH/Z!se\u0006L(BB4fiN\u001b\u0006\n\u000e\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0019A!\u0001E\u0001\u0019\u0001)1\u0001b\u0001\t\u00011\u0001Q!\u0001\u0005\u0004\u000b\r!)\u0001#\u0002\r\u0001\u0015\u0019AQ\u0001\u0005\u0005\u0019\u0001!19\u0001\u0007\u00033\t)\u0011\u0001C\u0002.%\u0011\u0001G\u0001g\u0002\"\u0005\u0015\t\u0001rA+\u0004\u0017\u0015)AqA\u0005\u0003\t\u0007a\t\u0001$\u0001\u000e\t\u0011%\u0011B\u0001C\u0002\u0019\u0003)\u0004\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        @NotNull
        public final byte[] getSSH() {
            return SSH;
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ Companion access$init$0() {
            return new Companion();
        }
    }
}

