/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Time;
import java.io.File;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.MyPrettyPrinter;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class SettingsRepositoryPackage$IcsSettings$fc6165a3 {
    static final int DEFAULT_COMMIT_DELAY = 600000;

    public static final int getDEFAULT_COMMIT_DELAY() {
        return DEFAULT_COMMIT_DELAY;
    }

    public static final void saveSettings(@JetValueParameter(name="settings") @NotNull IcsSettings settings, @JetValueParameter(name="settingsFile") @NotNull File settingsFile) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)settingsFile, (String)"settingsFile");
        byte[] serialized = new ObjectMapper().writer((PrettyPrinter)new MyPrettyPrinter()).writeValueAsBytes((Object)settings);
        if (serialized.length <= 2) {
            FileUtil.delete((File)settingsFile);
        } else {
            FileUtil.writeToFile((File)settingsFile, (byte[])serialized);
        }
    }

    @NotNull
    public static final IcsSettings loadSettings(@JetValueParameter(name="settingsFile") @NotNull File settingsFile) {
        Intrinsics.checkParameterIsNotNull((Object)settingsFile, (String)"settingsFile");
        if (!settingsFile.exists()) {
            return new IcsSettings();
        }
        IcsSettings settings = (IcsSettings)new ObjectMapper().readValue(settingsFile, IcsSettings.class);
        if (settings.getCommitDelay() <= 0) {
            settings.setCommitDelay(DEFAULT_COMMIT_DELAY);
        }
        IcsSettings icsSettings = settings;
        Intrinsics.checkExpressionValueIsNotNull((Object)icsSettings, (String)"settings");
        return icsSettings;
    }

    static {
        DEFAULT_COMMIT_DELAY = 10 * Time.MINUTE;
    }
}

