/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import java.util.List;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationArgumentVisitor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.CompileTimeConstant;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import org.jetbrains.annotations.NotNull;

public class ArrayValue
extends CompileTimeConstant<List<CompileTimeConstant<?>>> {
    private final JetType type;

    public ArrayValue(@NotNull List<CompileTimeConstant<?>> value, @NotNull JetType type2, boolean canBeUsedInAnnotations, boolean usesVariableAsConstant) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "kotlin/reflect/jvm/internal/impl/resolve/constants/ArrayValue", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "kotlin/reflect/jvm/internal/impl/resolve/constants/ArrayValue", "<init>"));
        }
        super(value, canBeUsedInAnnotations, false, usesVariableAsConstant);
        assert (KotlinBuiltIns.isArray(type2) || KotlinBuiltIns.isPrimitiveArray(type2)) : "Type should be an array, but was " + type2 + ": " + value;
        this.type = type2;
    }

    @Override
    @NotNull
    public List<CompileTimeConstant<?>> getValue() {
        List value = (List)super.getValue();
        assert (value != null) : "Guaranteed by constructor";
        List list = value;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/resolve/constants/ArrayValue", "getValue"));
        }
        return list;
    }

    @Override
    @NotNull
    public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
        if (kotlinBuiltIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinBuiltIns", "kotlin/reflect/jvm/internal/impl/resolve/constants/ArrayValue", "getType"));
        }
        JetType jetType = this.type;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/resolve/constants/ArrayValue", "getType"));
        }
        return jetType;
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor, D data2) {
        return visitor.visitArrayValue(this, data2);
    }

    public String toString() {
        return ((List)this.value).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayValue that = (ArrayValue)o;
        if (this.value == null) {
            return that.value == null;
        }
        int i = 0;
        for (CompileTimeConstant thisObject : (List)this.value) {
            if (!thisObject.equals(((List)that.value).get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.value == null) {
            return hashCode;
        }
        for (CompileTimeConstant o : (List)this.value) {
            hashCode += o.hashCode();
        }
        return hashCode;
    }
}

