/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.module;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.ide.util.projectWizard.JavaModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.build.PluginBuildConfiguration;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdk;
import org.jetbrains.idea.devkit.run.PluginConfigurationType;

public class PluginModuleBuilder
extends JavaModuleBuilder {
    @NonNls
    private static final String META_INF = "META-INF";
    @NonNls
    private static final String PLUGIN_XML = "plugin.xml";

    public ModuleType getModuleType() {
        return PluginModuleType.getInstance();
    }

    public void setupRootModel(ModifiableRootModel rootModel) throws ConfigurationException {
        super.setupRootModel(rootModel);
        final String defaultPluginXMLLocation = this.getModuleFileDirectory() + '/' + META_INF + '/' + PLUGIN_XML;
        final Module module = rootModel.getModule();
        final Project project = module.getProject();
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                VirtualFile file;
                PluginBuildConfiguration buildConfiguration = PluginBuildConfiguration.getInstance(module);
                if (buildConfiguration != null) {
                    buildConfiguration.setPluginXmlPathAndCreateDescriptorIfDoesntExist(defaultPluginXMLLocation);
                }
                if ((file = LocalFileSystem.getInstance().findFileByPath(defaultPluginXMLLocation)) != null) {
                    FileEditorManager.getInstance((Project)project).openFile(file, true);
                }
            }
        });
    }

    @Nullable
    public Module commitModule(@NotNull Project project, @Nullable ModifiableModuleModel model) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/devkit/module/PluginModuleBuilder", "commitModule"));
        }
        Module module = super.commitModule(project, model);
        if (module != null) {
            RunManager runManager = RunManager.getInstance((Project)project);
            RunnerAndConfigurationSettings configuration = runManager.createRunConfiguration(DevKitBundle.message("run.configuration.title", new Object[0]), new PluginConfigurationType().getConfigurationFactories()[0]);
            runManager.addConfiguration(configuration, false);
            runManager.setSelectedConfiguration(configuration);
        }
        return module;
    }

    public boolean isSuitableSdkType(SdkTypeId sdk) {
        return sdk == IdeaJdk.getInstance();
    }

    public String getParentGroup() {
        return "Java";
    }

    public int getWeight() {
        return 0;
    }

    public ModuleWizardStep modifyProjectTypeStep(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsStep", "org/jetbrains/idea/devkit/module/PluginModuleBuilder", "modifyProjectTypeStep"));
        }
        return StdModuleTypes.JAVA.modifyProjectTypeStep(settingsStep, (ModuleBuilder)this);
    }
}

