/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationArgumentVisitor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.CompileTimeConstant;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import org.jetbrains.annotations.NotNull;

public class StringValue
extends CompileTimeConstant<String> {
    public StringValue(String value, boolean canBeUsedInAnnotations, boolean usesVariableAsConstant) {
        super(value, canBeUsedInAnnotations, false, usesVariableAsConstant);
    }

    @Override
    @NotNull
    public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
        if (kotlinBuiltIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinBuiltIns", "kotlin/reflect/jvm/internal/impl/resolve/constants/StringValue", "getType"));
        }
        JetType jetType = kotlinBuiltIns.getStringType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/resolve/constants/StringValue", "getType"));
        }
        return jetType;
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor, D data2) {
        return visitor.visitStringValue(this, data2);
    }

    public String toString() {
        return "\"" + (String)this.value + "\"";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringValue that = (StringValue)o;
        return !(this.value != null ? !((String)this.value).equals(that.value) : that.value != null);
    }

    public int hashCode() {
        return this.value != null ? ((String)this.value).hashCode() : 0;
    }
}

