/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.ClassFinder;
import com.intellij.TestCaseLoader;
import com.intellij.TestRecorder;
import com.intellij.idea.Bombed;
import com.intellij.idea.RecordExecution;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.TeamCityLogger;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.tests.ExternalClasspathClassLoader;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;

public class TestAll
implements Test {
    private static final int SAVE_MEMORY_SNAPSHOT = 1;
    private static final int START_GUARD = 2;
    private static final int RUN_GC = 4;
    private static final int CHECK_MEMORY = 8;
    private static final int FILTER_CLASSES = 16;
    public static int ourMode;
    private static final boolean PERFORMANCE_TESTS_ONLY;
    private static final boolean INCLUDE_PERFORMANCE_TESTS;
    private static final boolean INCLUDE_UNCONVENTIONALLY_NAMED_TESTS;
    private static final int MAX_FAILURE_TEST_COUNT = 150;
    private static final Filter PERFORMANCE_ONLY;
    private static final Filter NO_PERFORMANCE;
    private final TestCaseLoader myTestCaseLoader;
    private long myStartTime;
    private boolean myInterruptedByOutOfTime;
    private long myLastTestStartTime;
    private String myLastTestClass;
    private int myRunTests = -1;
    private boolean mySavingMemorySnapshot;
    private int myLastTestTestMethodCount;
    private TestRecorder myTestRecorder;
    private static List<Throwable> outClassLoadingProblems;

    public TestAll(String packageRoot) throws Throwable {
        this(packageRoot, TestAll.getClassRoots());
    }

    public TestAll(String packageRoot, String ... classRoots) throws IOException, ClassNotFoundException {
        String classFilterName = "tests/testGroups.properties";
        if (Boolean.getBoolean("idea.ignore.predefined.groups") || (ourMode & 0x10) == 0) {
            classFilterName = "";
        }
        this.myTestCaseLoader = new TestCaseLoader(classFilterName);
        this.myTestCaseLoader.addFirstTest(Class.forName("_FirstInSuiteTest"));
        this.myTestCaseLoader.addLastTest(Class.forName("_LastInSuiteTest"));
        TestAll.fillTestCases(this.myTestCaseLoader, packageRoot, classRoots);
        outClassLoadingProblems.addAll(this.myTestCaseLoader.getClassLoadingErrors());
    }

    public static List<Throwable> getLoadingClassProblems() {
        return outClassLoadingProblems;
    }

    public static String[] getClassRoots() {
        String testRoots = System.getProperty("test.roots");
        if (testRoots != null) {
            System.out.println("Collecting tests from roots specified by test.roots property: " + testRoots);
            return testRoots.split(";");
        }
        Object[] roots = ExternalClasspathClassLoader.getRoots();
        if (roots != null) {
            if (Comparing.equal((String)System.getProperty("idea.skip.community.tests"), (String)"true")) {
                System.out.println("Skipping community tests");
                Set<String> set = TestAll.normalizePaths((String[])roots);
                set.removeAll(TestAll.normalizePaths(ExternalClasspathClassLoader.getExcludeRoots()));
                roots = ArrayUtil.toStringArray(set);
            }
            System.out.println("Collecting tests from roots specified by classpath.file property: " + Arrays.toString(roots));
            return roots;
        }
        ClassLoader loader = TestAll.class.getClassLoader();
        if (loader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)loader).getURLs();
            Object[] classLoaderRoots = new String[urls.length];
            for (int i = 0; i < urls.length; ++i) {
                classLoaderRoots[i] = VfsUtilCore.urlToPath((String)VfsUtilCore.convertFromUrl((URL)urls[i]));
            }
            System.out.println("Collecting tests from " + Arrays.toString(classLoaderRoots));
            return classLoaderRoots;
        }
        return System.getProperty("java.class.path").split(File.pathSeparator);
    }

    private static Set<String> normalizePaths(String[] array) {
        LinkedHashSet<String> answer = new LinkedHashSet<String>(array.length);
        for (String path : array) {
            answer.add(path.replace('\\', '/'));
        }
        return answer;
    }

    public static void fillTestCases(TestCaseLoader testCaseLoader, String packageRoot, String ... classRoots) throws IOException {
        long before = System.currentTimeMillis();
        for (String classRoot : classRoots) {
            int oldCount = testCaseLoader.getClasses().size();
            File classRootFile = new File(FileUtil.toSystemDependentName((String)classRoot));
            ClassFinder classFinder = new ClassFinder(classRootFile, packageRoot, INCLUDE_UNCONVENTIONALLY_NAMED_TESTS);
            testCaseLoader.loadTestCases(classRootFile.getName(), classFinder.getClasses());
            int newCount = testCaseLoader.getClasses().size();
            if (newCount == oldCount) continue;
            System.out.println("Loaded " + (newCount - oldCount) + " tests from class root " + classRoot);
        }
        if (testCaseLoader.getClasses().size() == 1) {
            testCaseLoader.clearClasses();
        }
        long after = System.currentTimeMillis();
        String message = "Number of test classes found: " + testCaseLoader.getClasses().size() + " time to load: " + (after - before) / 1000L + "s.";
        System.out.println(message);
        TestAll.log(message);
    }

    public int countTestCases() {
        int count = 0;
        for (Class aClass : this.myTestCaseLoader.getClasses()) {
            Test test = TestAll.getTest(aClass);
            if (test == null) continue;
            count += test.countTestCases();
        }
        return count;
    }

    private void beforeFirstTest() {
        if ((ourMode & 2) != 0) {
            Thread timeAndMemoryGuard = new Thread("Time and Memory Guard"){

                @Override
                public void run() {
                    TestAll.log("Starting Time and Memory Guard");
                    while (true) {
                        try {
                            Thread currentThread;
                            while (true) {
                                try {
                                    Thread.sleep(10000L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                if (TestAll.this.myLastTestStartTime == 0L) continue;
                                long currTime = System.currentTimeMillis();
                                long secondsSpent = (currTime - TestAll.this.myLastTestStartTime) / 1000L;
                                currentThread = TestAll.getCurrentThread();
                                if (TestAll.this.mySavingMemorySnapshot || secondsSpent <= PlatformTestCase.ourTestTime * (long)TestAll.this.myLastTestTestMethodCount) continue;
                                UsefulTestCase.printThreadDump();
                                TestAll.log("Interrupting current Test (out of time)! Test class: " + TestAll.this.myLastTestClass + " Seconds spent = " + secondsSpent);
                                TestAll.this.myInterruptedByOutOfTime = true;
                                if (currentThread != null) break;
                            }
                            currentThread.interrupt();
                            if (currentThread.isInterrupted()) break;
                            currentThread.stop();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                    TestAll.log("Time and Memory Guard finished.");
                }
            };
            timeAndMemoryGuard.setDaemon(true);
            timeAndMemoryGuard.start();
        }
        this.myStartTime = System.currentTimeMillis();
    }

    private static Thread getCurrentThread() {
        if (PlatformTestCase.ourTestThread != null) {
            return PlatformTestCase.ourTestThread;
        }
        return LightPlatformTestCase.ourTestThread;
    }

    private void addErrorMessage(TestResult testResult, String message) {
        String processedTestsMessage = this.myRunTests <= 0 ? "None of tests was run" : this.myRunTests + " tests processed";
        try {
            testResult.startTest((Test)this);
            testResult.addError((Test)this, new Throwable(processedTestsMessage + " before: " + message));
            testResult.endTest((Test)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TestResult testResult) {
        this.loadTestRecorder();
        List<Class> classes = this.myTestCaseLoader.getClasses();
        int totalTests = classes.size();
        for (Class aClass : classes) {
            boolean recording = false;
            if (this.myTestRecorder != null && TestAll.shouldRecord(aClass)) {
                this.myTestRecorder.beginRecording(aClass, aClass.getAnnotation(RecordExecution.class));
                recording = true;
            }
            try {
                this.runNextTest(testResult, totalTests, aClass);
            }
            finally {
                if (recording) {
                    this.myTestRecorder.endRecording();
                }
            }
            if (!testResult.shouldStop()) continue;
            break;
        }
        TestAll.tryGc(10);
    }

    private static boolean shouldRecord(@NotNull Class<?> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/TestAll", "shouldRecord"));
        }
        return aClass.getAnnotation(RecordExecution.class) != null;
    }

    private void loadTestRecorder() {
        String recorderClassName = System.getProperty("test.recorder.class");
        if (recorderClassName != null) {
            try {
                Class<?> recorderClass = Class.forName(recorderClassName);
                this.myTestRecorder = (TestRecorder)recorderClass.newInstance();
            }
            catch (Exception e) {
                System.out.println("Error loading test recorder class '" + recorderClassName + "': " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runNextTest(TestResult testResult, int totalTests, Class testCaseClass) {
        ++this.myRunTests;
        if (!this.checkAvailableMemory(35, testResult)) {
            testResult.stop();
            return;
        }
        if (testResult.errorCount() + testResult.failureCount() > 150) {
            this.addErrorMessage(testResult, "Too many errors. Executed: " + this.myRunTests + " of " + totalTests);
            testResult.stop();
            return;
        }
        if (this.myStartTime == 0L) {
            String loaderName = this.getClass().getClassLoader().getClass().getName();
            if (!loaderName.startsWith("com.intellij.")) {
                this.beforeFirstTest();
            }
        } else if (this.myInterruptedByOutOfTime) {
            this.addErrorMessage(testResult, "Time out in " + this.myLastTestClass + ". Executed: " + this.myRunTests + " of " + totalTests);
            testResult.stop();
            return;
        }
        TestAll.log("\nRunning " + testCaseClass.getName());
        Test test = TestAll.getTest(testCaseClass);
        if (test == null) {
            return;
        }
        this.myLastTestClass = testCaseClass.getName();
        this.myLastTestStartTime = System.currentTimeMillis();
        this.myLastTestTestMethodCount = test.countTestCases();
        try {
            test.run(testResult);
        }
        catch (OutOfMemoryError t) {
            if ((ourMode & 1) != 0) {
                try {
                    this.mySavingMemorySnapshot = true;
                    TestAll.log("OutOfMemoryError detected. Saving memory snapshot started");
                }
                finally {
                    TestAll.log("Saving memory snapshot finished");
                    this.mySavingMemorySnapshot = false;
                }
            }
            testResult.addError(test, (Throwable)t);
        }
        catch (Throwable t) {
            testResult.addError(test, t);
        }
    }

    private boolean checkAvailableMemory(int neededMemory, TestResult testResult) {
        if ((ourMode & 8) == 0) {
            return true;
        }
        boolean possibleOutOfMemoryError = TestAll.possibleOutOfMemory(neededMemory);
        if (possibleOutOfMemoryError) {
            TestAll.tryGc(5);
            possibleOutOfMemoryError = TestAll.possibleOutOfMemory(neededMemory);
            if (possibleOutOfMemoryError) {
                TestAll.log("OutOfMemoryError: dumping memory");
                Runtime runtime = Runtime.getRuntime();
                long total = runtime.totalMemory();
                long free = runtime.freeMemory();
                String errorMessage = "Too much memory used. Total: " + total + " free: " + free + " used: " + (total - free) + "\n";
                this.addErrorMessage(testResult, errorMessage);
            }
        }
        return !possibleOutOfMemoryError;
    }

    private static boolean possibleOutOfMemory(int neededMemory) {
        long meg;
        long needed;
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long realFreeMemory = runtime.freeMemory() + (maxMemory - runtime.totalMemory());
        return realFreeMemory < (needed = (long)neededMemory * (meg = 0x100000L));
    }

    private static boolean isPerformanceTestsRun() {
        return PERFORMANCE_TESTS_ONLY;
    }

    private static boolean isIncludingPerformanceTestsRun() {
        return INCLUDE_PERFORMANCE_TESTS;
    }

    @Nullable
    private static Test getTest(final @NotNull Class<?> testCaseClass) {
        if (testCaseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCaseClass", "com/intellij/TestAll", "getTest"));
        }
        try {
            if ((testCaseClass.getModifiers() & 1) == 0) {
                return null;
            }
            Bombed classBomb = testCaseClass.getAnnotation(Bombed.class);
            if (classBomb != null && PlatformTestUtil.bombExplodes(classBomb)) {
                return new ExplodedBomb(testCaseClass.getName(), classBomb);
            }
            Method suiteMethod = TestAll.safeFindMethod(testCaseClass, "suite");
            if (suiteMethod != null && !TestAll.isPerformanceTestsRun()) {
                return (Test)suiteMethod.invoke(null, (Object[])ArrayUtil.EMPTY_CLASS_ARRAY);
            }
            if (TestRunnerUtil.isJUnit4TestClass(testCaseClass)) {
                boolean runEverything;
                JUnit4TestAdapter adapter = new JUnit4TestAdapter(testCaseClass);
                boolean bl = runEverything = TestAll.isIncludingPerformanceTestsRun() || TestAll.isPerformanceTest(testCaseClass) && TestAll.isPerformanceTestsRun();
                if (!runEverything) {
                    try {
                        adapter.filter(TestAll.isPerformanceTestsRun() ? PERFORMANCE_ONLY : NO_PERFORMANCE);
                    }
                    catch (NoTestsRemainException noTestsRemainException) {
                        // empty catch block
                    }
                }
                return adapter;
            }
            final int[] testsCount = new int[]{0};
            TestSuite suite = new TestSuite(testCaseClass){

                public void addTest(Test test) {
                    if (!(test instanceof TestCase)) {
                        this.doAddTest(test);
                    } else {
                        String name = ((TestCase)test).getName();
                        if ("warning".equals(name)) {
                            return;
                        }
                        if (!TestAll.isIncludingPerformanceTestsRun() && TestAll.isPerformanceTestsRun() ^ (TestAll.hasPerformance(name) || TestAll.isPerformanceTest(testCaseClass))) {
                            return;
                        }
                        Method method = this.findTestMethod((TestCase)test);
                        if (method == null) {
                            this.doAddTest(test);
                        } else {
                            Bombed methodBomb = method.getAnnotation(Bombed.class);
                            if (methodBomb == null) {
                                this.doAddTest(test);
                            } else if (PlatformTestUtil.bombExplodes(methodBomb)) {
                                this.doAddTest((Test)new ExplodedBomb(method.getDeclaringClass().getName() + "." + method.getName(), methodBomb));
                            }
                        }
                    }
                }

                private void doAddTest(Test test) {
                    testsCount[0] = testsCount[0] + 1;
                    super.addTest(test);
                }

                @Nullable
                private Method findTestMethod(TestCase testCase) {
                    return TestAll.safeFindMethod(testCase.getClass(), testCase.getName());
                }
            };
            return testsCount[0] > 0 ? suite : null;
        }
        catch (Throwable t) {
            System.err.println("Failed to load test: " + testCaseClass.getName());
            t.printStackTrace(System.err);
            return null;
        }
    }

    public static boolean shouldIncludePerformanceTestCase(Class aClass) {
        return TestAll.isIncludingPerformanceTestsRun() || TestAll.isPerformanceTestsRun() || !TestAll.isPerformanceTest(aClass);
    }

    public static boolean isPerformanceTest(Class aClass) {
        return TestAll.hasPerformance(aClass.getSimpleName());
    }

    private static boolean hasPerformance(String name) {
        return name.toLowerCase(Locale.US).contains("performance");
    }

    @Nullable
    private static Method safeFindMethod(Class<?> klass, String name) {
        try {
            return klass.getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static void tryGc(int times) {
        if ((ourMode & 4) == 0) {
            return;
        }
        for (int i = 1; i < times; ++i) {
            try {
                Thread.sleep(i * 1000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.gc();
            long mem = Runtime.getRuntime().totalMemory();
            TestAll.log("Runtime.getRuntime().totalMemory() = " + mem);
        }
    }

    private static void log(String message) {
        TeamCityLogger.info(message);
    }

    static {
        Logger.setFactory(TestLoggerFactory.class);
        ourMode = 17;
        PERFORMANCE_TESTS_ONLY = System.getProperty("idea.performance.tests") != null;
        INCLUDE_PERFORMANCE_TESTS = System.getProperty("idea.include.performance.tests") != null;
        INCLUDE_UNCONVENTIONALLY_NAMED_TESTS = System.getProperty("idea.include.unconventionally.named.tests") != null;
        PERFORMANCE_ONLY = new Filter(){

            public boolean shouldRun(Description description) {
                String className = description.getClassName();
                String methodName = description.getMethodName();
                return className != null && TestAll.hasPerformance(className) || methodName != null && TestAll.hasPerformance(methodName);
            }

            public String describe() {
                return "Performance Tests Only";
            }
        };
        NO_PERFORMANCE = new Filter(){

            public boolean shouldRun(Description description) {
                return !PERFORMANCE_ONLY.shouldRun(description);
            }

            public String describe() {
                return "All Except Performance";
            }
        };
        outClassLoadingProblems = new ArrayList<Throwable>();
    }

    private static class ExplodedBomb
    extends TestCase {
        private final Bombed myBombed;

        public ExplodedBomb(String testName, Bombed bombed) {
            super(testName);
            this.myBombed = bombed;
        }

        protected void runTest() throws Throwable {
            String description = this.myBombed.description().isEmpty() ? "" : " (" + this.myBombed.description() + ")";
            ExplodedBomb.fail((String)("Bomb created by " + this.myBombed.user() + description + " now explodes!"));
        }
    }
}

