/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.HtmlCompletionData;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.XmlAttributeInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.xml.XmlAttributeImpl;
import com.intellij.psi.impl.source.xml.XmlAttributeReference;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.NamespaceAwareXmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAttributeReferenceCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final Logger LOG = Logger.getInstance(XmlAttributeReferenceCompletionProvider.class);

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/XmlAttributeReferenceCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/XmlAttributeReferenceCompletionProvider", "addCompletions"));
        }
        PsiReference reference = parameters.getPosition().getContainingFile().findReferenceAt(parameters.getOffset());
        if (reference instanceof XmlAttributeReference) {
            XmlAttributeReferenceCompletionProvider.addAttributeReferenceCompletionVariants((XmlAttributeReference)reference, result, null);
        }
    }

    public static void addAttributeReferenceCompletionVariants(XmlAttributeReference reference, CompletionResultSet result, @Nullable InsertHandler<LookupElement> replacementInsertHandler) {
        XmlTag declarationTag = reference.getElement().getParent();
        LOG.assertTrue(declarationTag.isValid());
        XmlElementDescriptor parentDescriptor = declarationTag.getDescriptor();
        if (parentDescriptor != null) {
            XmlAttribute[] attributes = declarationTag.getAttributes();
            XmlAttributeDescriptor[] descriptors = parentDescriptor.getAttributesDescriptors(declarationTag);
            descriptors = HtmlUtil.appendHtmlSpecificAttributeCompletions(declarationTag, descriptors, reference.getElement());
            XmlAttributeReferenceCompletionProvider.addVariants(result, attributes, descriptors, reference.getElement(), replacementInsertHandler);
        }
    }

    private static void addVariants(CompletionResultSet result, XmlAttribute[] attributes, XmlAttributeDescriptor[] descriptors, XmlAttribute attribute, @Nullable InsertHandler<LookupElement> replacementInsertHandler) {
        XmlTag tag = attribute.getParent();
        PsiFile file = tag.getContainingFile();
        XmlExtension extension = XmlExtension.getExtension(file);
        String prefix = attribute.getName().contains(":") && ((XmlAttributeImpl)attribute).getRealLocalName().length() > 0 ? attribute.getNamespacePrefix() + ":" : null;
        CompletionData completionData = CompletionUtil.getCompletionDataByElement((PsiElement)attribute, attribute.getContainingFile().getOriginalFile());
        boolean caseSensitive = !(completionData instanceof HtmlCompletionData) || ((HtmlCompletionData)completionData).isCaseSensitive();
        for (XmlAttributeDescriptor descriptor : descriptors) {
            int separator;
            if (!XmlAttributeReferenceCompletionProvider.isValidVariant(attribute, descriptor, attributes, extension)) continue;
            String name = descriptor.getName((PsiElement)tag);
            XmlAttributeInsertHandler insertHandler = XmlAttributeInsertHandler.INSTANCE;
            if (tag instanceof HtmlTag && HtmlUtil.isShortNotationOfBooleanAttributePreferred() && HtmlUtil.isBooleanAttribute(descriptor, (PsiElement)tag)) {
                insertHandler = null;
            }
            if (replacementInsertHandler != null) {
                insertHandler = replacementInsertHandler;
            } else if (descriptor instanceof NamespaceAwareXmlAttributeDescriptor) {
                String namespace = ((NamespaceAwareXmlAttributeDescriptor)descriptor).getNamespace(tag);
                if (file instanceof XmlFile && namespace != null && namespace.length() > 0 && !name.contains(":") && tag.getPrefixByNamespace(namespace) == null) {
                    insertHandler = new XmlAttributeInsertHandler(namespace);
                }
            }
            if (prefix != null && !name.startsWith(prefix)) continue;
            if (prefix != null && name.length() > prefix.length()) {
                name = descriptor.getName((PsiElement)tag).substring(prefix.length());
            }
            LookupElementBuilder element = LookupElementBuilder.create((String)name);
            if (descriptor instanceof PsiPresentableMetaData) {
                element = element.withIcon(((PsiPresentableMetaData)descriptor).getIcon());
            }
            if ((separator = name.indexOf(58)) > 0) {
                element = element.withLookupString(name.substring(separator + 1));
            }
            element = element.withCaseSensitivity(caseSensitive).withInsertHandler(insertHandler);
            result.addElement((LookupElement)(descriptor.isRequired() ? PrioritizedLookupElement.withPriority((LookupElement)element.appendTailText("(required)", true), (double)100.0) : (HtmlUtil.isOwnHtmlAttribute(descriptor) ? PrioritizedLookupElement.withPriority((LookupElement)element, (double)50.0) : element)));
        }
    }

    private static boolean isValidVariant(XmlAttribute attribute, @NotNull XmlAttributeDescriptor descriptor, XmlAttribute[] attributes, XmlExtension extension) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/completion/XmlAttributeReferenceCompletionProvider", "isValidVariant"));
        }
        if (extension.isIndirectSyntax(descriptor)) {
            return false;
        }
        String descriptorName = descriptor.getName((PsiElement)attribute.getParent());
        if (descriptorName == null) {
            LOG.error("Null descriptor name for " + descriptor + " " + descriptor.getClass() + " ");
            return false;
        }
        for (XmlAttribute otherAttr : attributes) {
            if (otherAttr == attribute || !otherAttr.getName().equals(descriptorName)) continue;
            return false;
        }
        return !descriptorName.contains("IntellijIdeaRulezzz");
    }
}

