/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import gnu.trove.TIntFunction;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeverityRegistrar
implements JDOMExternalizable,
Comparator<HighlightSeverity> {
    @NonNls
    private static final String INFO_TAG = "info";
    @NonNls
    private static final String COLOR_ATTRIBUTE = "color";
    private final Map<String, SeverityBasedTextAttributes> myMap;
    private final Map<String, Color> myRendererColors;
    public static final Topic<Runnable> SEVERITIES_CHANGED_TOPIC = Topic.create((String)"SEVERITIES_CHANGED_TOPIC", Runnable.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.TO_PARENT);
    @NotNull
    private final MessageBus myMessageBus;
    private volatile OrderMap myOrderMap;
    private JDOMExternalizableStringList myReadOrder;
    private static final Map<String, HighlightInfoType> STANDARD_SEVERITIES = ContainerUtil.newConcurrentMap();
    private static final AtomicFieldUpdater<SeverityRegistrar, OrderMap> ORDER_MAP_UPDATER;

    public SeverityRegistrar(@NotNull MessageBus messageBus) {
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar", "<init>"));
        }
        this.myMap = ContainerUtil.newConcurrentMap();
        this.myRendererColors = ContainerUtil.newConcurrentMap();
        this.myMessageBus = messageBus;
    }

    public static void registerStandard(@NotNull HighlightInfoType highlightInfoType, @NotNull HighlightSeverity highlightSeverity) {
        if (highlightInfoType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfoType", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar", "registerStandard"));
        }
        if (highlightSeverity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightSeverity", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar", "registerStandard"));
        }
        STANDARD_SEVERITIES.put(highlightSeverity.getName(), highlightInfoType);
    }

    @NotNull
    public static SeverityRegistrar getSeverityRegistrar(@Nullable Project project) {
        SeverityRegistrar severityRegistrar = project == null ? InspectionProfileManager.getInstance().getSeverityRegistrar() : InspectionProjectProfileManager.getInstance(project).getSeverityRegistrar();
        if (severityRegistrar == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar", "getSeverityRegistrar"));
        }
        return severityRegistrar;
    }

    public void registerSeverity(@NotNull SeverityBasedTextAttributes info, Color renderColor) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", INFO_TAG, "com/intellij/codeInsight/daemon/impl/SeverityRegistrar", "registerSeverity"));
        }
        HighlightSeverity severity = info.getType().getSeverity(null);
        this.myMap.put(severity.getName(), info);
        if (renderColor != null) {
            this.myRendererColors.put(severity.getName(), renderColor);
        }
        this.myOrderMap = null;
        HighlightDisplayLevel.registerSeverity((HighlightSeverity)severity, (TextAttributesKey)this.getHighlightInfoTypeBySeverity(severity).getAttributesKey(), null);
        this.severitiesChanged();
    }

    private void severitiesChanged() {
        ((Runnable)this.myMessageBus.syncPublisher(SEVERITIES_CHANGED_TOPIC)).run();
    }

    public SeverityBasedTextAttributes unregisterSeverity(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar", "unregisterSeverity"));
        }
        return this.myMap.remove(severity.getName());
    }

    @NotNull
    public HighlightInfoType.HighlightInfoTypeImpl getHighlightInfoTypeBySeverity(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar", "getHighlightInfoTypeBySeverity"));
        }
        HighlightInfoType infoType = STANDARD_SEVERITIES.get(severity.getName());
        if (infoType != null) {
            HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = (HighlightInfoType.HighlightInfoTypeImpl)infoType;
            if (highlightInfoTypeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar", "getHighlightInfoTypeBySeverity"));
            }
            return highlightInfoTypeImpl;
        }
        if (severity == HighlightSeverity.INFORMATION) {
            HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = (HighlightInfoType.HighlightInfoTypeImpl)HighlightInfoType.INFORMATION;
            if (highlightInfoTypeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar", "getHighlightInfoTypeBySeverity"));
            }
            return highlightInfoTypeImpl;
        }
        SeverityBasedTextAttributes type = this.getAttributesBySeverity(severity);
        HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = (HighlightInfoType.HighlightInfoTypeImpl)(type == null ? HighlightInfoType.WARNING : type.getType());
        if (highlightInfoTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar", "getHighlightInfoTypeBySeverity"));
        }
        return highlightInfoTypeImpl;
    }

    private SeverityBasedTextAttributes getAttributesBySeverity(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar", "getAttributesBySeverity"));
        }
        return this.myMap.get(severity.getName());
    }

    @Nullable
    public TextAttributes getTextAttributesBySeverity(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar", "getTextAttributesBySeverity"));
        }
        SeverityBasedTextAttributes infoType = this.getAttributesBySeverity(severity);
        if (infoType != null) {
            return infoType.getAttributes();
        }
        return null;
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myMap.clear();
        this.myRendererColors.clear();
        for (Element infoElement : element.getChildren(INFO_TAG)) {
            SeverityBasedTextAttributes highlightInfo = new SeverityBasedTextAttributes(infoElement);
            String colorStr = infoElement.getAttributeValue(COLOR_ATTRIBUTE);
            Color color = colorStr == null ? null : new Color(Integer.parseInt(colorStr, 16));
            this.registerSeverity(highlightInfo, color);
        }
        this.myReadOrder = new JDOMExternalizableStringList();
        this.myReadOrder.readExternal(element);
        ArrayList<HighlightSeverity> read = new ArrayList<HighlightSeverity>(this.myReadOrder.size());
        List<HighlightSeverity> knownSeverities = this.getDefaultOrder();
        for (String name : this.myReadOrder) {
            HighlightSeverity severity = this.getSeverity(name);
            if (severity == null || !knownSeverities.contains(severity)) continue;
            read.add(severity);
        }
        OrderMap orderMap = SeverityRegistrar.fromList(read);
        if (orderMap.isEmpty()) {
            orderMap = SeverityRegistrar.fromList(knownSeverities);
        } else {
            List<HighlightSeverity> list = SeverityRegistrar.getOrderAsList(orderMap);
            block2: for (int i = 0; i < knownSeverities.size(); ++i) {
                HighlightSeverity stdSeverity = knownSeverities.get(i);
                if (list.contains(stdSeverity)) continue;
                for (int oIdx = 0; oIdx < list.size(); ++oIdx) {
                    HighlightSeverity orderSeverity = list.get(oIdx);
                    HighlightInfoType type = STANDARD_SEVERITIES.get(orderSeverity.getName());
                    if (type == null || knownSeverities.indexOf(type.getSeverity(null)) <= i) continue;
                    list.add(oIdx, stdSeverity);
                    this.myReadOrder = null;
                    continue block2;
                }
            }
            orderMap = SeverityRegistrar.fromList(list);
        }
        this.myOrderMap = orderMap;
        this.severitiesChanged();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        List<HighlightSeverity> list = SeverityRegistrar.getOrderAsList(this.getOrderMap());
        for (HighlightSeverity severity : list) {
            Element info = new Element(INFO_TAG);
            String severityName = severity.getName();
            SeverityBasedTextAttributes infoType = this.getAttributesBySeverity(severity);
            if (infoType == null) continue;
            infoType.writeExternal(info);
            Color color = this.myRendererColors.get(severityName);
            if (color != null) {
                info.setAttribute(COLOR_ATTRIBUTE, Integer.toString(color.getRGB() & 0xFFFFFF, 16));
            }
            element.addContent(info);
        }
        if (this.myReadOrder != null && !this.myReadOrder.isEmpty()) {
            this.myReadOrder.writeExternal(element);
        } else if (!this.getDefaultOrder().equals(list)) {
            final JDOMExternalizableStringList ext = new JDOMExternalizableStringList(Collections.nCopies(this.getOrderMap().size(), ""));
            this.getOrderMap().forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<HighlightSeverity>(){

                public boolean execute(HighlightSeverity orderSeverity, int oIdx) {
                    ext.set(oIdx, (Object)orderSeverity.getName());
                    return true;
                }
            });
            ext.writeExternal(element);
        }
    }

    @NotNull
    private static List<HighlightSeverity> getOrderAsList(final @NotNull OrderMap orderMap) {
        if (orderMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderMap", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar", "getOrderAsList"));
        }
        ArrayList<HighlightSeverity> list = new ArrayList<HighlightSeverity>();
        for (Object o : orderMap.keys()) {
            list.add((HighlightSeverity)o);
        }
        Collections.sort(list, new Comparator<HighlightSeverity>(){

            @Override
            public int compare(HighlightSeverity o1, HighlightSeverity o2) {
                return SeverityRegistrar.compare(o1, o2, orderMap);
            }
        });
        ArrayList<HighlightSeverity> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar", "getOrderAsList"));
        }
        return arrayList;
    }

    public int getSeveritiesCount() {
        return this.createCurrentSeverityNames().size();
    }

    public HighlightSeverity getSeverityByIndex(final int i) {
        final HighlightSeverity[] found = new HighlightSeverity[1];
        this.getOrderMap().forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<HighlightSeverity>(){

            public boolean execute(HighlightSeverity severity, int order) {
                if (order == i) {
                    found[0] = severity;
                    return false;
                }
                return true;
            }
        });
        return found[0];
    }

    public int getSeverityMaxIndex() {
        int[] values = this.getOrderMap().getValues();
        int max = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (values[i] <= max) continue;
            max = values[i];
        }
        return max;
    }

    @Nullable
    public HighlightSeverity getSeverity(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar", "getSeverity"));
        }
        HighlightInfoType type = STANDARD_SEVERITIES.get(name);
        if (type != null) {
            return type.getSeverity(null);
        }
        SeverityBasedTextAttributes attributes = this.myMap.get(name);
        if (attributes != null) {
            return attributes.getSeverity();
        }
        return null;
    }

    @NotNull
    private List<String> createCurrentSeverityNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(STANDARD_SEVERITIES.keySet());
        list.addAll(this.myMap.keySet());
        ContainerUtil.sort(list);
        ArrayList<String> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar", "createCurrentSeverityNames"));
        }
        return arrayList;
    }

    public Icon getRendererIconByIndex(int i) {
        HighlightSeverity severity = this.getSeverityByIndex(i);
        HighlightDisplayLevel level = HighlightDisplayLevel.find((HighlightSeverity)severity);
        if (level != null) {
            return level.getIcon();
        }
        return HighlightDisplayLevel.createIconByMask((Color)this.myRendererColors.get(severity.getName()));
    }

    public boolean isSeverityValid(@NotNull String severityName) {
        if (severityName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severityName", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar", "isSeverityValid"));
        }
        return this.createCurrentSeverityNames().contains(severityName);
    }

    @Override
    public int compare(HighlightSeverity s1, HighlightSeverity s2) {
        return SeverityRegistrar.compare(s1, s2, this.getOrderMap());
    }

    private static int compare(HighlightSeverity s1, HighlightSeverity s2, OrderMap orderMap) {
        int o1 = orderMap.getOrder(s1, -1);
        int o2 = orderMap.getOrder(s2, -1);
        return o1 - o2;
    }

    @NotNull
    private OrderMap getOrderMap() {
        OrderMap orderMap;
        OrderMap defaultOrder = null;
        while ((orderMap = this.myOrderMap) == null) {
            boolean replaced;
            if (defaultOrder == null) {
                defaultOrder = SeverityRegistrar.fromList(this.getDefaultOrder());
            }
            if (!(replaced = ORDER_MAP_UPDATER.compareAndSet((Object)this, null, (Object)defaultOrder))) continue;
            orderMap = defaultOrder;
            break;
        }
        OrderMap orderMap2 = orderMap;
        if (orderMap2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar", "getOrderMap"));
        }
        return orderMap2;
    }

    @NotNull
    private static OrderMap fromList(@NotNull List<HighlightSeverity> orderList) {
        if (orderList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderList", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar", "fromList"));
        }
        TObjectIntHashMap map = new TObjectIntHashMap();
        for (int i = 0; i < orderList.size(); ++i) {
            HighlightSeverity severity = orderList.get(i);
            map.put((Object)severity, i);
        }
        OrderMap orderMap = new OrderMap(map);
        if (orderMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar", "fromList"));
        }
        return orderMap;
    }

    @NotNull
    private List<HighlightSeverity> getDefaultOrder() {
        Collection<SeverityBasedTextAttributes> values = this.myMap.values();
        ArrayList<HighlightSeverity> order = new ArrayList<HighlightSeverity>(STANDARD_SEVERITIES.size() + values.size());
        for (HighlightInfoType type : STANDARD_SEVERITIES.values()) {
            order.add(type.getSeverity(null));
        }
        for (SeverityBasedTextAttributes attributes : values) {
            order.add(attributes.getSeverity());
        }
        ContainerUtil.sort(order);
        ArrayList<HighlightSeverity> arrayList = order;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar", "getDefaultOrder"));
        }
        return arrayList;
    }

    public void setOrder(@NotNull List<HighlightSeverity> orderList) {
        if (orderList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderList", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar", "setOrder"));
        }
        this.myOrderMap = SeverityRegistrar.fromList(orderList);
        this.myReadOrder = null;
        this.severitiesChanged();
    }

    public int getSeverityIdx(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar", "getSeverityIdx"));
        }
        return this.getOrderMap().getOrder(severity, -1);
    }

    public boolean isDefaultSeverity(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar", "isDefaultSeverity"));
        }
        return STANDARD_SEVERITIES.containsKey(severity.myName);
    }

    public static boolean isGotoBySeverityEnabled(@NotNull HighlightSeverity minSeverity) {
        if (minSeverity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minSeverity", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar", "isGotoBySeverityEnabled"));
        }
        for (SeveritiesProvider provider : (SeveritiesProvider[])Extensions.getExtensions(SeveritiesProvider.EP_NAME)) {
            if (!provider.isGotoBySeverityEnabled(minSeverity)) continue;
            return true;
        }
        return minSeverity != HighlightSeverity.INFORMATION;
    }

    @NotNull
    Collection<SeverityBasedTextAttributes> allRegisteredAttributes() {
        ArrayList<SeverityBasedTextAttributes> arrayList = new ArrayList<SeverityBasedTextAttributes>(this.myMap.values());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar", "allRegisteredAttributes"));
        }
        return arrayList;
    }

    @NotNull
    Collection<HighlightInfoType> standardSeverities() {
        Collection<HighlightInfoType> collection = STANDARD_SEVERITIES.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar", "standardSeverities"));
        }
        return collection;
    }

    static {
        SeverityRegistrar.registerStandard(HighlightInfoType.ERROR, HighlightSeverity.ERROR);
        SeverityRegistrar.registerStandard(HighlightInfoType.WARNING, HighlightSeverity.WARNING);
        SeverityRegistrar.registerStandard(HighlightInfoType.INFO, HighlightSeverity.INFO);
        SeverityRegistrar.registerStandard(HighlightInfoType.WEAK_WARNING, HighlightSeverity.WEAK_WARNING);
        SeverityRegistrar.registerStandard(HighlightInfoType.GENERIC_WARNINGS_OR_ERRORS_FROM_SERVER, HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING);
        ORDER_MAP_UPDATER = AtomicFieldUpdater.forFieldOfType(SeverityRegistrar.class, OrderMap.class);
    }

    public static class SeverityBasedTextAttributes {
        private final TextAttributes myAttributes;
        private final HighlightInfoType.HighlightInfoTypeImpl myType;

        public SeverityBasedTextAttributes(@NotNull Element element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar$SeverityBasedTextAttributes", "<init>"));
            }
            this(new TextAttributes(element), new HighlightInfoType.HighlightInfoTypeImpl(element));
        }

        public SeverityBasedTextAttributes(@NotNull TextAttributes attributes, @NotNull HighlightInfoType.HighlightInfoTypeImpl type) {
            if (attributes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar$SeverityBasedTextAttributes", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar$SeverityBasedTextAttributes", "<init>"));
            }
            this.myAttributes = attributes;
            this.myType = type;
        }

        @NotNull
        public TextAttributes getAttributes() {
            TextAttributes textAttributes = this.myAttributes;
            if (textAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar$SeverityBasedTextAttributes", "getAttributes"));
            }
            return textAttributes;
        }

        @NotNull
        public HighlightInfoType.HighlightInfoTypeImpl getType() {
            HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = this.myType;
            if (highlightInfoTypeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar$SeverityBasedTextAttributes", "getType"));
            }
            return highlightInfoTypeImpl;
        }

        private void writeExternal(@NotNull Element element) throws WriteExternalException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar$SeverityBasedTextAttributes", "writeExternal"));
            }
            this.myAttributes.writeExternal(element);
            this.myType.writeExternal(element);
        }

        @NotNull
        public HighlightSeverity getSeverity() {
            HighlightSeverity highlightSeverity = this.myType.getSeverity(null);
            if (highlightSeverity == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar$SeverityBasedTextAttributes", "getSeverity"));
            }
            return highlightSeverity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SeverityBasedTextAttributes that = (SeverityBasedTextAttributes)o;
            if (!this.myAttributes.equals((Object)that.myAttributes)) {
                return false;
            }
            return this.myType.equals(that.myType);
        }

        public int hashCode() {
            int result = this.myAttributes.hashCode();
            result = 31 * result + this.myType.hashCode();
            return result;
        }
    }

    private static class OrderMap
    extends TObjectIntHashMap<HighlightSeverity> {
        private OrderMap(@NotNull TObjectIntHashMap<HighlightSeverity> map) {
            if (map == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar$OrderMap", "<init>"));
            }
            super(map.size());
            map.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<HighlightSeverity>(){

                public boolean execute(HighlightSeverity key, int value) {
                    OrderMap.super.put(key, value);
                    return true;
                }
            });
            this.trimToSize();
        }

        private int getOrder(@NotNull HighlightSeverity severity, int defaultOrder) {
            if (severity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/codeInsight/daemon/impl/SeverityRegistrar$OrderMap", "getOrder"));
            }
            int index = this.index(severity);
            return index < 0 ? defaultOrder : this._values[index];
        }

        public void clear() {
            throw new IncorrectOperationException("readonly");
        }

        protected void removeAt(int index) {
            throw new IncorrectOperationException("readonly");
        }

        public void transformValues(TIntFunction function) {
            throw new IncorrectOperationException("readonly");
        }

        public boolean adjustValue(HighlightSeverity key, int amount) {
            throw new IncorrectOperationException("readonly");
        }

        public int put(HighlightSeverity key, int value) {
            throw new IncorrectOperationException("readonly");
        }

        public int remove(HighlightSeverity key) {
            throw new IncorrectOperationException("readonly");
        }
    }
}

