/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.quickFix.ExternalLibraryResolver;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ThreeState;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JetBrainsAnnotationsExternalLibraryResolver
extends ExternalLibraryResolver {
    private static final ExternalLibraryDescriptor JAVA5 = new JetBrainsAnnotationsLibraryDescriptor(){

        @Override
        @NotNull
        public List<String> getLibraryClassesRoots() {
            List<String> list = Collections.singletonList(FileUtil.toSystemIndependentName((String)new File(PathManager.getLibPath(), "annotations.jar").getAbsolutePath()));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/JetBrainsAnnotationsExternalLibraryResolver$1", "getLibraryClassesRoots"));
            }
            return list;
        }
    };
    private static final ExternalLibraryDescriptor JAVA8 = new JetBrainsAnnotationsLibraryDescriptor(){

        @Override
        @NotNull
        public List<String> getLibraryClassesRoots() {
            List<String> list = Collections.singletonList(FileUtil.toSystemIndependentName((String)new File(PathManager.getHomePath(), "redist/annotations-java8.jar").getAbsolutePath()));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/JetBrainsAnnotationsExternalLibraryResolver$2", "getLibraryClassesRoots"));
            }
            return list;
        }
    };

    @Override
    @Nullable
    public ExternalLibraryResolver.ExternalClassResolveResult resolveClass(@NotNull String shortClassName, @NotNull ThreeState isAnnotation, @NotNull Module contextModule) {
        if (shortClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortClassName", "com/intellij/codeInsight/daemon/impl/quickfix/JetBrainsAnnotationsExternalLibraryResolver", "resolveClass"));
        }
        if (isAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isAnnotation", "com/intellij/codeInsight/daemon/impl/quickfix/JetBrainsAnnotationsExternalLibraryResolver", "resolveClass"));
        }
        if (contextModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextModule", "com/intellij/codeInsight/daemon/impl/quickfix/JetBrainsAnnotationsExternalLibraryResolver", "resolveClass"));
        }
        if (AnnotationUtil.isJetbrainsAnnotation((String)shortClassName)) {
            ExternalLibraryDescriptor libraryDescriptor = JetBrainsAnnotationsExternalLibraryResolver.getAnnotationsLibraryDescriptor(contextModule);
            return new ExternalLibraryResolver.ExternalClassResolveResult("org.jetbrains.annotations." + shortClassName, libraryDescriptor);
        }
        return null;
    }

    @NotNull
    public static ExternalLibraryDescriptor getAnnotationsLibraryDescriptor(@NotNull Module contextModule) {
        if (contextModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextModule", "com/intellij/codeInsight/daemon/impl/quickfix/JetBrainsAnnotationsExternalLibraryResolver", "getAnnotationsLibraryDescriptor"));
        }
        boolean java8 = EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)contextModule).isAtLeast(LanguageLevel.JDK_1_8);
        ExternalLibraryDescriptor externalLibraryDescriptor = java8 ? JAVA8 : JAVA5;
        if (externalLibraryDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/JetBrainsAnnotationsExternalLibraryResolver", "getAnnotationsLibraryDescriptor"));
        }
        return externalLibraryDescriptor;
    }

    private static abstract class JetBrainsAnnotationsLibraryDescriptor
    extends ExternalLibraryDescriptor {
        public JetBrainsAnnotationsLibraryDescriptor() {
            super("com.intellij", "annotations", null);
        }
    }
}

