/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class EnterAfterUnmatchedBraceHandler
extends EnterHandlerDelegateAdapter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.enter.EnterAfterUnmatchedBraceHandler");

    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "preprocessEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "preprocessEnter"));
        }
        if (caretOffsetRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretOffsetRef", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "preprocessEnter"));
        }
        if (caretAdvance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretAdvance", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "preprocessEnter"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "preprocessEnter"));
        }
        int caretOffset = (Integer)caretOffsetRef.get();
        int maxRBraceCount = this.getMaxRBraceCount(file, editor, caretOffset);
        if (maxRBraceCount > 0 && this.insertRBraces(file, editor, caretOffset, this.getRBraceOffset(file, editor, caretOffset), this.adjustRBraceCountForPosition(editor, caretOffset, maxRBraceCount))) {
            return EnterHandlerDelegate.Result.DefaultForceIndent;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    protected int getMaxRBraceCount(@NotNull PsiFile file, @NotNull Editor editor, int caretOffset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "getMaxRBraceCount"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "getMaxRBraceCount"));
        }
        if (!CodeInsightSettings.getInstance().INSERT_BRACE_ON_ENTER) {
            return 0;
        }
        return Math.max(0, EnterAfterUnmatchedBraceHandler.getUnmatchedLBracesNumberBefore(editor, caretOffset, file.getFileType()));
    }

    protected int adjustRBraceCountForPosition(@NotNull Editor editor, int caretOffset, int maxRBraceCount) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "adjustRBraceCountForPosition"));
        }
        assert (maxRBraceCount > 0);
        CharSequence text = editor.getDocument().getCharsSequence();
        int bracesToInsert = 0;
        block4: for (int i = caretOffset - 1; i >= 0 && bracesToInsert < maxRBraceCount; --i) {
            switch (text.charAt(i)) {
                case '\t': 
                case '\n': 
                case ' ': {
                    continue block4;
                }
                case '{': {
                    ++bracesToInsert;
                    continue block4;
                }
            }
        }
        return Math.max(bracesToInsert, 1);
    }

    protected int getRBraceOffset(@NotNull PsiFile file, @NotNull Editor editor, int caretOffset) {
        int fileLength;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "getRBraceOffset"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "getRBraceOffset"));
        }
        CharSequence text = editor.getDocument().getCharsSequence();
        int offset = CharArrayUtil.shiftForward((CharSequence)text, (int)caretOffset, (String)" \t");
        if (offset < (fileLength = text.length()) && ")];,%<?".indexOf(text.charAt(offset)) < 0) {
            offset = this.calculateOffsetToInsertClosingBrace(file, text, offset);
        }
        return Math.min(offset, fileLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean insertRBraces(@NotNull PsiFile file, @NotNull Editor editor, int caretOffset, int rBracesInsertOffset, int rBracesCount) {
        boolean closingBraceIndentAdjusted2;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "insertRBraces"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "insertRBraces"));
        }
        Document document = editor.getDocument();
        document.insertString(rBracesInsertOffset, (CharSequence)("\n" + StringUtil.repeatSymbol((char)'}', (int)rBracesCount)));
        document.insertString(caretOffset, (CharSequence)"\n");
        Project project = file.getProject();
        long stamp = document.getModificationStamp();
        try {
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, new TextRange(caretOffset, rBracesInsertOffset + 2));
        }
        catch (IncorrectOperationException e) {
            try {
                LOG.error((Throwable)e);
            }
            catch (Throwable throwable) {
                boolean closingBraceIndentAdjusted2 = stamp != document.getModificationStamp();
                document.deleteString(caretOffset, caretOffset + 1);
                throw throwable;
            }
            closingBraceIndentAdjusted2 = stamp != document.getModificationStamp();
            document.deleteString(caretOffset, caretOffset + 1);
        }
        closingBraceIndentAdjusted2 = stamp != document.getModificationStamp();
        document.deleteString(caretOffset, caretOffset + 1);
        if (!closingBraceIndentAdjusted2) {
            char c;
            int line = document.getLineNumber(rBracesInsertOffset);
            StringBuilder buffer = new StringBuilder();
            int start = document.getLineStartOffset(line);
            int end = document.getLineEndOffset(line);
            CharSequence text = document.getCharsSequence();
            for (int i = start; i < end && ((c = text.charAt(i)) == ' ' || c == '\t'); ++i) {
                buffer.append(c);
            }
            if (buffer.length() > 0) {
                document.insertString(rBracesInsertOffset + 1, (CharSequence)buffer);
            }
        }
        return true;
    }

    protected int calculateOffsetToInsertClosingBrace(PsiFile file, CharSequence text, int offset) {
        ASTNode parentNode;
        PsiElement element = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)offset);
        ASTNode node = element.getNode();
        if (node != null && node.getElementType() == TokenType.WHITE_SPACE) {
            return CharArrayUtil.shiftForwardUntil((CharSequence)text, (int)offset, (String)"\n");
        }
        for (PsiElement parent = element.getParent(); parent != null && (parentNode = parent.getNode()) != null && parentNode.getStartOffset() == offset; parent = parent.getParent()) {
            element = parent;
        }
        if (element.getTextOffset() != offset) {
            return CharArrayUtil.shiftForwardUntil((CharSequence)text, (int)offset, (String)"\n");
        }
        return element.getTextRange().getEndOffset();
    }

    public static boolean isAfterUnmatchedLBrace(Editor editor, int offset, FileType fileType) {
        return EnterAfterUnmatchedBraceHandler.getUnmatchedLBracesNumberBefore(editor, offset, fileType) > 0;
    }

    protected static int getUnmatchedLBracesNumberBefore(Editor editor, int offset, FileType fileType) {
        if (offset == 0) {
            return -1;
        }
        CharSequence chars = editor.getDocument().getCharsSequence();
        if (chars.charAt(offset - 1) != '{') {
            return -1;
        }
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        HighlighterIterator iterator = highlighter.createIterator(offset - 1);
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
        if (!braceMatcher.isLBraceToken(iterator, chars, fileType) || !braceMatcher.isStructuralBrace(iterator, chars, fileType)) {
            return -1;
        }
        Language language = iterator.getTokenType().getLanguage();
        iterator = highlighter.createIterator(0);
        int lBracesBeforeOffset = 0;
        int lBracesAfterOffset = 0;
        int rBracesBeforeOffset = 0;
        int rBracesAfterOffset = 0;
        while (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            if (tokenType.getLanguage().equals(language) && braceMatcher.isStructuralBrace(iterator, chars, fileType)) {
                boolean beforeOffset;
                boolean bl = beforeOffset = iterator.getStart() < offset;
                if (braceMatcher.isLBraceToken(iterator, chars, fileType)) {
                    if (beforeOffset) {
                        ++lBracesBeforeOffset;
                    } else {
                        ++lBracesAfterOffset;
                    }
                } else if (braceMatcher.isRBraceToken(iterator, chars, fileType)) {
                    if (beforeOffset) {
                        ++rBracesBeforeOffset;
                    } else {
                        ++rBracesAfterOffset;
                    }
                }
            }
            iterator.advance();
        }
        return lBracesBeforeOffset - rBracesBeforeOffset - (rBracesAfterOffset - lBracesAfterOffset);
    }
}

