/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18StreamApi;

import com.intellij.codeInspection.java18StreamApi.FluentIterableMethodTransformer;
import com.intellij.codeInspection.java18StreamApi.GuavaFluentIterableInspection;
import com.intellij.codeInspection.java18StreamApi.GuavaOptionalConverter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuavaFluentIterableMethodConverters {
    private static final Logger LOG = Logger.getInstance(GuavaFluentIterableMethodConverters.class);
    private static final Map<String, FluentIterableMethodTransformer> METHOD_INDEX = new HashMap<String, FluentIterableMethodTransformer>();
    private static final Map<String, String> TO_OTHER_COLLECTION_METHODS = new HashMap<String, String>();
    private static final Set<String> STOP_METHODS = new HashSet<String>();

    public static boolean isFluentIterableMethod(String methodName) {
        return STOP_METHODS.contains(methodName) || TO_OTHER_COLLECTION_METHODS.containsKey(methodName) || METHOD_INDEX.containsKey(methodName);
    }

    public static boolean isStopMethod(String methodName) {
        return STOP_METHODS.contains(methodName);
    }

    public static void convert(PsiLocalVariable localVariable, PsiElementFactory elementFactory, JavaCodeStyleManager codeStyleManager) {
        PsiTypeElement typeElement = localVariable.getTypeElement();
        PsiReferenceParameterList generics = (PsiReferenceParameterList)PsiTreeUtil.findChildOfType((PsiElement)typeElement, PsiReferenceParameterList.class);
        typeElement.replace((PsiElement)elementFactory.createTypeElementFromText("java.util.stream.Stream" + (generics == null ? "" : generics.getText()), null));
        PsiExpression initializer = localVariable.getInitializer();
        if (initializer != null) {
            PsiMethodCallExpression initializerMethodCall = (PsiMethodCallExpression)initializer;
            GuavaFluentIterableMethodConverters.convertMethodCallDeep(elementFactory, initializerMethodCall);
        }
        codeStyleManager.shortenClassReferences((PsiElement)localVariable);
    }

    public static void convert(PsiExpression expression, PsiElementFactory elementFactory, JavaCodeStyleManager codeStyleManager) {
        if (expression instanceof PsiReferenceExpression) {
            PsiElement expressionParent = expression.getParent();
            if (expressionParent instanceof PsiReturnStatement || GuavaFluentIterableMethodConverters.isIterableMethodParameter(expressionParent, expression)) {
                expression = (PsiExpression)expression.replace((PsiElement)elementFactory.createExpressionFromText(expression.getText() + ".collect(java.util.stream.Collectors.toList())", null));
                codeStyleManager.shortenClassReferences((PsiElement)expression);
            }
            return;
        }
        PsiMethodCallExpression parentMethodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethodCallExpression.class);
        if (parentMethodCall != null && parentMethodCall.getMethodExpression().getQualifierExpression() == expression) {
            PsiMethod seqTailMethod = parentMethodCall.resolveMethod();
            if (seqTailMethod == null) {
                return;
            }
            PsiClass seqTailMethodClass = seqTailMethod.getContainingClass();
            if (seqTailMethodClass != null && "com.google.common.base.Optional".equals(seqTailMethodClass.getQualifiedName())) {
                PsiMethodCallExpression newParentMethodCall = GuavaOptionalConverter.convertGuavaOptionalToJava(parentMethodCall, elementFactory);
                expression = newParentMethodCall.getMethodExpression().getQualifierExpression();
            }
        }
        if (expression instanceof PsiMethodCallExpression) {
            expression = GuavaFluentIterableMethodConverters.convertMethodCallDeep(elementFactory, (PsiMethodCallExpression)expression);
        }
        if (expression == null) {
            return;
        }
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiExpressionList) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)parent.getParent();
            Object[] expressions = methodCall.getArgumentList().getExpressions();
            int index = ArrayUtil.indexOf((Object[])expressions, (Object)expression);
            LOG.assertTrue(index >= 0);
            PsiMethod method = methodCall.resolveMethod();
            LOG.assertTrue(method != null);
            PsiType parameterType = method.getParameterList().getParameters()[index].getType();
            expression = GuavaFluentIterableMethodConverters.addCollectToListIfNeed(expression, parameterType, elementFactory);
        } else if (parent instanceof PsiReturnStatement) {
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiMethod.class);
            LOG.assertTrue(containingMethod != null);
            PsiType returnType = containingMethod.getReturnType();
            expression = GuavaFluentIterableMethodConverters.addCollectToListIfNeed(expression, returnType, elementFactory);
        }
        codeStyleManager.shortenClassReferences((PsiElement)expression);
    }

    private static PsiExpression addCollectToListIfNeed(PsiExpression expression, PsiType type, PsiElementFactory elementFactory) {
        PsiClass resolvedParamClass;
        if (type instanceof PsiClassType && (resolvedParamClass = ((PsiClassType)type).resolve()) != null && "java.lang.Iterable".equals(resolvedParamClass.getQualifiedName())) {
            PsiExpression newExpression = elementFactory.createExpressionFromText(expression.getText() + ".collect(java.util.stream.Collectors.toList())", null);
            return (PsiExpression)expression.replace((PsiElement)newExpression);
        }
        return expression;
    }

    private static boolean isIterableMethodParameter(PsiElement listExpression, PsiExpression parameterExpression) {
        if (!(listExpression instanceof PsiExpressionList)) {
            return false;
        }
        if (!(listExpression.getParent() instanceof PsiMethodCallExpression)) {
            return false;
        }
        Project project = parameterExpression.getProject();
        PsiClass fluentIterable = JavaPsiFacade.getInstance((Project)project).findClass("com.google.common.collect.FluentIterable", GlobalSearchScope.allScope((Project)project));
        return GuavaFluentIterableInspection.isMethodWithParamAcceptsConversion((PsiMethodCallExpression)listExpression.getParent(), parameterExpression, fluentIterable);
    }

    @Nullable
    private static PsiMethodCallExpression convertMethodCallDeep(PsiElementFactory elementFactory, @NotNull PsiMethodCallExpression methodCall) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInspection/java18StreamApi/GuavaFluentIterableMethodConverters", "convertMethodCallDeep"));
        }
        PsiMethodCallExpression newMethodCall = methodCall;
        PsiMethodCallExpression returnCall = null;
        while (true) {
            Pair<PsiMethodCallExpression, Boolean> converted;
            if (((Boolean)(converted = GuavaFluentIterableMethodConverters.convertMethodCall(elementFactory, newMethodCall)).getSecond()).booleanValue()) {
                return returnCall;
            }
            if (returnCall == null) {
                returnCall = (PsiMethodCallExpression)converted.getFirst();
            }
            if (converted.getFirst() == null) {
                return returnCall;
            }
            newMethodCall = (PsiMethodCallExpression)converted.getFirst();
            PsiExpression expression = newMethodCall.getMethodExpression().getQualifierExpression();
            if (!(expression instanceof PsiMethodCallExpression)) break;
            newMethodCall = (PsiMethodCallExpression)expression;
        }
        return returnCall;
    }

    public static Pair<PsiMethodCallExpression, Boolean> convertMethodCall(PsiElementFactory elementFactory, PsiMethodCallExpression methodCall) {
        PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
        String name = methodExpression.getReferenceName();
        if (TO_OTHER_COLLECTION_METHODS.containsKey(name)) {
            return Pair.create((Object)GuavaFluentIterableMethodConverters.convertToCollection(methodCall, name, elementFactory), (Object)false);
        }
        if ("from".equals(name)) {
            PsiExpression[] argumentList = methodCall.getArgumentList().getExpressions();
            LOG.assertTrue(argumentList.length == 1);
            PsiExpression expression = argumentList[0];
            PsiType type = expression.getType();
            LOG.assertTrue(type instanceof PsiClassType);
            PsiClass resolvedClass = ((PsiClassType)type).resolve();
            String newExpressionText = InheritanceUtil.isInheritor((PsiClass)resolvedClass, (String)"java.util.Collection") ? expression.getText() + ".stream()" : "java.util.stream.StreamSupport.stream(" + expression.getText() + ".spliterator(), false)";
            return Pair.create((Object)((PsiMethodCallExpression)methodCall.replace((PsiElement)elementFactory.createExpressionFromText(newExpressionText, null))), (Object)true);
        }
        FluentIterableMethodTransformer transformer = METHOD_INDEX.get(name);
        LOG.assertTrue(transformer != null, (Object)name);
        PsiMethodCallExpression transformedExpression = transformer.transform(methodCall, elementFactory);
        return Pair.create((Object)transformedExpression, (Object)false);
    }

    private static PsiMethodCallExpression convertToCollection(PsiMethodCallExpression methodCall, String methodName, PsiElementFactory elementFactory) {
        PsiExpression qualifier;
        PsiExpression[] expressions = methodCall.getArgumentList().getExpressions();
        assert (expressions.length < 2);
        String template = TO_OTHER_COLLECTION_METHODS.get(methodName);
        if (expressions.length == 1) {
            template = String.format(template, expressions[0].getText());
        }
        if ((qualifier = methodCall.getMethodExpression().getQualifierExpression()) == null) {
            return null;
        }
        String text = qualifier.getText() + "." + template;
        PsiExpression expression = elementFactory.createExpressionFromText(text, null);
        return (PsiMethodCallExpression)methodCall.replace((PsiElement)expression);
    }

    static {
        METHOD_INDEX.put("allMatch", new FluentIterableMethodTransformer.OneParameterMethodTransformer("allMatch(%s)", true));
        METHOD_INDEX.put("anyMatch", new FluentIterableMethodTransformer.OneParameterMethodTransformer("anyMatch(%s)", true));
        METHOD_INDEX.put("contains", new FluentIterableMethodTransformer.OneParameterMethodTransformer("anyMatch(e -> e != null && e.equals(%s))"));
        METHOD_INDEX.put("copyInto", new FluentIterableMethodTransformer.OneParameterMethodTransformer("forEach(%s::add)"));
        METHOD_INDEX.put("filter", new FluentIterableMethodTransformer.OneParameterMethodTransformer("filter(%s)", true));
        METHOD_INDEX.put("first", new FluentIterableMethodTransformer.ParameterlessMethodTransformer("findFirst"));
        METHOD_INDEX.put("firstMatch", new FluentIterableMethodTransformer.OneParameterMethodTransformer("filter(%s).findFirst()", true));
        METHOD_INDEX.put("get", new FluentIterableMethodTransformer.OneParameterMethodTransformer("collect(java.util.stream.Collectors.toList()).get(%s)"));
        METHOD_INDEX.put("index", new FluentIterableMethodTransformer.OneParameterMethodTransformer("collect(java.util.stream.Collectors.toList()).indexOf(%s)"));
        METHOD_INDEX.put("isEmpty", new FluentIterableMethodTransformer.ParameterlessMethodTransformer("findAny().isPresent()", true));
        METHOD_INDEX.put("last", new FluentIterableMethodTransformer.ParameterlessMethodTransformer("reduce((previous, current) -> current)"));
        METHOD_INDEX.put("limit", new FluentIterableMethodTransformer.OneParameterMethodTransformer("limit(%s)"));
        METHOD_INDEX.put("size", new FluentIterableMethodTransformer.ParameterlessMethodTransformer("collect(java.util.stream.Collectors.toList()).size()"));
        METHOD_INDEX.put("skip", new FluentIterableMethodTransformer.OneParameterMethodTransformer("skip(%s)"));
        METHOD_INDEX.put("toArray", new FluentIterableMethodTransformer.ToArrayMethodTransformer());
        METHOD_INDEX.put("transform", new FluentIterableMethodTransformer.OneParameterMethodTransformer("map(%s)", true));
        METHOD_INDEX.put("transformAndConcat", new FluentIterableMethodTransformer.OneParameterMethodTransformer("flatMap(%s)", true));
        METHOD_INDEX.put("uniqueIndex", new FluentIterableMethodTransformer.OneParameterMethodTransformer("collect(java.util.stream.Collectors.toMap(%s, java.util.function.Function.identity()))"));
        TO_OTHER_COLLECTION_METHODS.put("toMap", "collect(java.util.stream.Collectors.toMap(java.util.function.Function.identity(), %s))");
        TO_OTHER_COLLECTION_METHODS.put("toList", "collect(java.util.stream.Collectors.toList())");
        TO_OTHER_COLLECTION_METHODS.put("toSet", "collect(java.util.stream.Collectors.toSet())");
        TO_OTHER_COLLECTION_METHODS.put("toSortedList", "sorted(%s).collect(java.util.stream.Collectors.toList())");
        TO_OTHER_COLLECTION_METHODS.put("toSortedSet", "sorted(%s).collect(java.util.stream.Collectors.toSet())");
        STOP_METHODS.add("append");
        STOP_METHODS.add("cycle");
    }
}

