/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.codeinsight;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.EditorEvaluationCommand;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.Nullable;

public abstract class RuntimeTypeEvaluator
extends EditorEvaluationCommand<PsiClass> {
    public RuntimeTypeEvaluator(@Nullable Editor editor, PsiElement expression, DebuggerContextImpl context, ProgressIndicator indicator) {
        super(editor, expression, context, indicator);
    }

    @Override
    public void threadAction() {
        PsiClass type = null;
        try {
            type = (PsiClass)this.evaluate();
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        catch (EvaluateException evaluateException) {
        }
        finally {
            this.typeCalculationFinished(type);
        }
    }

    protected abstract void typeCalculationFinished(@Nullable PsiClass var1);

    @Override
    @Nullable
    protected PsiClass evaluate(final EvaluationContextImpl evaluationContext) throws EvaluateException {
        Project project = evaluationContext.getProject();
        ExpressionEvaluator evaluator = DebuggerInvocationUtil.commitAndRunReadAction(project, new EvaluatingComputable<ExpressionEvaluator>(){

            @Override
            public ExpressionEvaluator compute() throws EvaluateException {
                return EvaluatorBuilderImpl.getInstance().build(RuntimeTypeEvaluator.this.myElement, ContextUtil.getSourcePosition((StackFrameContext)evaluationContext));
            }
        });
        Value value = evaluator.evaluate((EvaluationContext)evaluationContext);
        if (value != null) {
            return RuntimeTypeEvaluator.getCastableRuntimeType(project, value);
        }
        throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.surrounded.expression.null", (Object[])new Object[0]));
    }

    public static PsiClass getCastableRuntimeType(Project project, Value value) {
        Type type = value.type();
        PsiClass psiClass = RuntimeTypeEvaluator.findPsiClass(project, type);
        if (psiClass != null) {
            return psiClass;
        }
        if (type instanceof ClassType) {
            ClassType superclass = ((ClassType)type).superclass();
            if (superclass != null && !"java.lang.Object".equals(superclass.name()) && (psiClass = RuntimeTypeEvaluator.findPsiClass(project, superclass)) != null) {
                return psiClass;
            }
            for (InterfaceType interfaceType : ((ClassType)type).interfaces()) {
                psiClass = RuntimeTypeEvaluator.findPsiClass(project, interfaceType);
                if (psiClass == null) continue;
                return psiClass;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PsiClass findPsiClass(Project project, Type type) {
        AccessToken token = ReadAction.start();
        try {
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(type.name().replace('$', '.'), GlobalSearchScope.allScope((Project)project));
            return psiClass;
        }
        finally {
            token.finish();
        }
    }

    public static boolean isSubtypeable(PsiExpression expr) {
        PsiClass psiClass;
        PsiType type = expr.getType();
        if (type instanceof PsiPrimitiveType) {
            return false;
        }
        return !(type instanceof PsiClassType) || (psiClass = ((PsiClassType)type).resolve()) == null || !psiClass.hasModifierProperty("final");
    }
}

