/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.propertyTable.renderers;

import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public final class ColorIcon
extends EmptyIcon {
    private final int myColorSize;
    private Color myColor;
    private boolean myShowRedLine;

    public ColorIcon(int size, int colorSize) {
        super(size, size);
        this.myColorSize = colorSize;
    }

    public Color getColor() {
        return this.myShowRedLine ? null : this.myColor;
    }

    public void setColor(Color color) {
        this.myColor = color;
    }

    public void showRedLine(boolean value) {
        this.myShowRedLine = value;
    }

    public void paintIcon(Component component, Graphics g, int left, int top) {
        int iconWidth = this.getIconWidth();
        int iconHeight = this.getIconHeight();
        if (component instanceof SimpleColoredComponent) {
            SimpleColoredComponent coloredComponent = (SimpleColoredComponent)component;
            g.setColor(component.getBackground());
            g.fillRect(left - coloredComponent.getIpad().left, 0, iconWidth + coloredComponent.getIpad().left + coloredComponent.getIconTextGap(), component.getHeight());
        }
        int x = left + (iconWidth - this.myColorSize) / 2;
        int y = top + (iconHeight - this.myColorSize) / 2;
        g.setColor(this.myColor);
        g.fillRect(x, y, this.myColorSize, this.myColorSize);
        if (this.myShowRedLine) {
            Graphics2D g2d = (Graphics2D)g;
            Object hint = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(Color.red);
            g.drawLine(x, y + this.myColorSize, x + this.myColorSize, y);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
        }
        g.setColor(Color.BLACK);
        g.drawRect(x, y, this.myColorSize, this.myColorSize);
    }
}

