/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffContextEx;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.MessageDiffRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorDiffTool
implements FrameDiffTool {
    public static final ErrorDiffTool INSTANCE = new ErrorDiffTool();

    @NotNull
    public FrameDiffTool.DiffViewer createComponent(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/ErrorDiffTool", "createComponent"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/ErrorDiffTool", "createComponent"));
        }
        MyViewer myViewer = new MyViewer(context, request);
        if (myViewer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/ErrorDiffTool", "createComponent"));
        }
        return myViewer;
    }

    public boolean canShow(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/ErrorDiffTool", "canShow"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/ErrorDiffTool", "canShow"));
        }
        return true;
    }

    @NotNull
    public String getName() {
        if ("Error viewer" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/ErrorDiffTool", "getName"));
        }
        return "Error viewer";
    }

    private static class MyViewer
    implements FrameDiffTool.DiffViewer {
        @NotNull
        private final DiffContext myContext;
        @NotNull
        private final DiffRequest myRequest;
        @NotNull
        private final JPanel myPanel;

        public MyViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/ErrorDiffTool$MyViewer", "<init>"));
            }
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/ErrorDiffTool$MyViewer", "<init>"));
            }
            this.myContext = context;
            this.myRequest = request;
            this.myPanel = JBUI.Panels.simplePanel((Component)this.createComponent(request));
        }

        @NotNull
        private JComponent createComponent(@NotNull DiffRequest request) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/ErrorDiffTool$MyViewer", "createComponent"));
            }
            if (request instanceof MessageDiffRequest) {
                String message = ((MessageDiffRequest)request).getMessage();
                JPanel jPanel = DiffUtil.createMessagePanel(message);
                if (jPanel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/ErrorDiffTool$MyViewer", "createComponent"));
                }
                return jPanel;
            }
            if (request instanceof ContentDiffRequest) {
                List contents = ((ContentDiffRequest)request).getContents();
                for (DiffContent content : contents) {
                    if (!(content instanceof FileContent) || !FileTypes.UNKNOWN.equals(content.getContentType())) continue;
                    final VirtualFile file = ((FileContent)content).getFile();
                    SimpleColoredComponent label = new SimpleColoredComponent();
                    label.append("Can't show diff for unknown file type. ", new SimpleTextAttributes(0, UIUtil.getInactiveTextColor()));
                    label.append("Associate", SimpleTextAttributes.LINK_ATTRIBUTES, (Object)new Runnable(){

                        @Override
                        public void run() {
                            FileType type = FileTypeChooser.associateFileType(file.getName());
                            if (type != null && MyViewer.this.myContext instanceof DiffContextEx) {
                                ((DiffContextEx)MyViewer.this.myContext).reloadDiffRequest();
                            }
                        }
                    });
                    LinkMouseListenerBase.installSingleTagOn(label);
                    JPanel jPanel = DiffUtil.createMessagePanel((JComponent)label);
                    if (jPanel == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/ErrorDiffTool$MyViewer", "createComponent"));
                    }
                    return jPanel;
                }
            }
            JPanel jPanel = DiffUtil.createMessagePanel("Can't show diff");
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/ErrorDiffTool$MyViewer", "createComponent"));
            }
            return jPanel;
        }

        @NotNull
        public JComponent getComponent() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/ErrorDiffTool$MyViewer", "getComponent"));
            }
            return jPanel;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return null;
        }

        @NotNull
        public FrameDiffTool.ToolbarComponents init() {
            FrameDiffTool.ToolbarComponents toolbarComponents = new FrameDiffTool.ToolbarComponents();
            if (toolbarComponents == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/ErrorDiffTool$MyViewer", "init"));
            }
            return toolbarComponents;
        }

        public void dispose() {
        }
    }
}

