/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.fragmented.ChangedBlock;
import com.intellij.diff.tools.fragmented.UnifiedDiffViewer;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnifiedDiffChange {
    @NotNull
    private final UnifiedDiffViewer myViewer;
    @NotNull
    private final EditorEx myEditor;
    private int myLine1;
    private int myLine2;
    @NotNull
    private final LineFragment myLineFragment;
    @NotNull
    private final List<RangeHighlighter> myHighlighters;
    @NotNull
    private final List<MyGutterOperation> myOperations;

    public UnifiedDiffChange(@NotNull UnifiedDiffViewer viewer, @NotNull ChangedBlock block, boolean innerFragments) {
        if (viewer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/diff/tools/fragmented/UnifiedDiffChange", "<init>"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/diff/tools/fragmented/UnifiedDiffChange", "<init>"));
        }
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.myOperations = new ArrayList<MyGutterOperation>();
        this.myViewer = viewer;
        this.myEditor = viewer.getEditor();
        this.myLine1 = block.getLine1();
        this.myLine2 = block.getLine2();
        this.myLineFragment = block.getLineFragment();
        TextRange deleted = new TextRange(block.getStartOffset1(), block.getEndOffset1());
        TextRange inserted = new TextRange(block.getStartOffset2(), block.getEndOffset2());
        this.installHighlighter(deleted, inserted, innerFragments);
    }

    public void destroyHighlighter() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
        for (MyGutterOperation operation : this.myOperations) {
            operation.dispose();
        }
        this.myOperations.clear();
    }

    private void installHighlighter(@NotNull TextRange deleted, @NotNull TextRange inserted, boolean innerFragments) {
        if (deleted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deleted", "com/intellij/diff/tools/fragmented/UnifiedDiffChange", "installHighlighter"));
        }
        if (inserted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inserted", "com/intellij/diff/tools/fragmented/UnifiedDiffChange", "installHighlighter"));
        }
        assert (this.myHighlighters.isEmpty());
        if (innerFragments && this.myLineFragment.getInnerFragments() != null) {
            this.doInstallHighlighterWithInner(deleted, inserted);
        } else {
            this.doInstallHighlighterSimple(deleted, inserted);
        }
        this.doInstallActionHighlighters();
    }

    private void doInstallActionHighlighters() {
        boolean leftEditable = this.myViewer.isEditable(Side.LEFT, false);
        boolean rightEditable = this.myViewer.isEditable(Side.RIGHT, false);
        if (rightEditable) {
            this.myOperations.add(this.createOperation(Side.LEFT, false));
        }
        if (leftEditable) {
            this.myOperations.add(this.createOperation(Side.RIGHT, rightEditable));
        }
    }

    private void doInstallHighlighterSimple(@NotNull TextRange deleted, @NotNull TextRange inserted) {
        if (deleted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deleted", "com/intellij/diff/tools/fragmented/UnifiedDiffChange", "doInstallHighlighterSimple"));
        }
        if (inserted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inserted", "com/intellij/diff/tools/fragmented/UnifiedDiffChange", "doInstallHighlighterSimple"));
        }
        this.createLineHighlighters(deleted, inserted, false);
    }

    private void doInstallHighlighterWithInner(@NotNull TextRange deleted, @NotNull TextRange inserted) {
        if (deleted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deleted", "com/intellij/diff/tools/fragmented/UnifiedDiffChange", "doInstallHighlighterWithInner"));
        }
        if (inserted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inserted", "com/intellij/diff/tools/fragmented/UnifiedDiffChange", "doInstallHighlighterWithInner"));
        }
        List innerFragments = this.myLineFragment.getInnerFragments();
        assert (innerFragments != null);
        this.createLineHighlighters(deleted, inserted, true);
        for (DiffFragment fragment : innerFragments) {
            this.createInlineHighlighter(TextDiffType.DELETED, deleted.getStartOffset() + fragment.getStartOffset1(), deleted.getStartOffset() + fragment.getEndOffset1());
            this.createInlineHighlighter(TextDiffType.INSERTED, inserted.getStartOffset() + fragment.getStartOffset2(), inserted.getStartOffset() + fragment.getEndOffset2());
        }
    }

    private void createLineHighlighters(@NotNull TextRange deleted, @NotNull TextRange inserted, boolean ignored) {
        if (deleted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deleted", "com/intellij/diff/tools/fragmented/UnifiedDiffChange", "createLineHighlighters"));
        }
        if (inserted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inserted", "com/intellij/diff/tools/fragmented/UnifiedDiffChange", "createLineHighlighters"));
        }
        if (!inserted.isEmpty() && !deleted.isEmpty()) {
            this.createLineMarker(TextDiffType.DELETED, this.getLine1(), SeparatorPlacement.TOP);
            this.createHighlighter(TextDiffType.DELETED, deleted.getStartOffset(), deleted.getEndOffset(), ignored);
            this.createHighlighter(TextDiffType.INSERTED, inserted.getStartOffset(), inserted.getEndOffset(), ignored);
            this.createLineMarker(TextDiffType.INSERTED, this.getLine2() - 1, SeparatorPlacement.BOTTOM);
        } else if (!inserted.isEmpty()) {
            this.createLineMarker(TextDiffType.INSERTED, this.getLine1(), SeparatorPlacement.TOP);
            this.createHighlighter(TextDiffType.INSERTED, inserted.getStartOffset(), inserted.getEndOffset(), ignored);
            this.createLineMarker(TextDiffType.INSERTED, this.getLine2() - 1, SeparatorPlacement.BOTTOM);
        } else if (!deleted.isEmpty()) {
            this.createLineMarker(TextDiffType.DELETED, this.getLine1(), SeparatorPlacement.TOP);
            this.createHighlighter(TextDiffType.DELETED, deleted.getStartOffset(), deleted.getEndOffset(), ignored);
            this.createLineMarker(TextDiffType.DELETED, this.getLine2() - 1, SeparatorPlacement.BOTTOM);
        }
    }

    private void createHighlighter(@NotNull TextDiffType type, int start, int end, boolean ignored) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/tools/fragmented/UnifiedDiffChange", "createHighlighter"));
        }
        this.myHighlighters.addAll(DiffDrawUtil.createHighlighter(this.myEditor, start, end, type, ignored));
    }

    private void createInlineHighlighter(@NotNull TextDiffType type, int start, int end) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/tools/fragmented/UnifiedDiffChange", "createInlineHighlighter"));
        }
        this.myHighlighters.addAll(DiffDrawUtil.createInlineHighlighter(this.myEditor, start, end, type));
    }

    private void createLineMarker(@NotNull TextDiffType type, int line, @NotNull SeparatorPlacement placement) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/tools/fragmented/UnifiedDiffChange", "createLineMarker"));
        }
        if (placement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placement", "com/intellij/diff/tools/fragmented/UnifiedDiffChange", "createLineMarker"));
        }
        this.myHighlighters.addAll(DiffDrawUtil.createLineMarker(this.myEditor, line, type, placement));
    }

    public int getLine1() {
        return this.myLine1;
    }

    public int getLine2() {
        return this.myLine2;
    }

    @NotNull
    public LineFragment getLineFragment() {
        LineFragment lineFragment = this.myLineFragment;
        if (lineFragment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffChange", "getLineFragment"));
        }
        return lineFragment;
    }

    public void processChange(int oldLine1, int oldLine2, int shift) {
        DiffUtil.UpdatedLineRange newRange = DiffUtil.updateRangeOnModification(this.myLine1, this.myLine2, oldLine1, oldLine2, shift);
        this.myLine1 = newRange.startLine;
        this.myLine2 = newRange.endLine;
    }

    public void updateGutterActions() {
        for (MyGutterOperation operation : this.myOperations) {
            operation.update();
        }
    }

    @NotNull
    private MyGutterOperation createOperation(@NotNull Side side, boolean secondAction) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/UnifiedDiffChange", "createOperation"));
        }
        int line = secondAction ? Math.min(this.myLine1 + 1, this.myLine2 - 1) : this.myLine1;
        int offset = this.myEditor.getDocument().getLineStartOffset(line);
        RangeHighlighter highlighter = this.myEditor.getMarkupModel().addRangeHighlighter(offset, offset, 3000, null, HighlighterTargetArea.LINES_IN_RANGE);
        MyGutterOperation myGutterOperation = new MyGutterOperation(side, highlighter);
        if (myGutterOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffChange", "createOperation"));
        }
        return myGutterOperation;
    }

    @Nullable
    private GutterIconRenderer createIconRenderer(final @NotNull Side sourceSide, final @NotNull String tooltipText, final @NotNull Icon icon) {
        if (sourceSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSide", "com/intellij/diff/tools/fragmented/UnifiedDiffChange", "createIconRenderer"));
        }
        if (tooltipText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tooltipText", "com/intellij/diff/tools/fragmented/UnifiedDiffChange", "createIconRenderer"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/diff/tools/fragmented/UnifiedDiffChange", "createIconRenderer"));
        }
        return new GutterIconRenderer(){

            @NotNull
            public Icon getIcon() {
                Icon icon2 = icon;
                if (icon2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffChange$1", "getIcon"));
                }
                return icon2;
            }

            public boolean isNavigateAction() {
                return true;
            }

            @Nullable
            public AnAction getClickAction() {
                return new DumbAwareAction(){

                    public void actionPerformed(AnActionEvent e) {
                        Project project = e.getProject();
                        Document document = UnifiedDiffChange.this.myViewer.getDocument(sourceSide.other());
                        DiffUtil.executeWriteCommand(document, project, "Replace change", new Runnable(){

                            @Override
                            public void run() {
                                UnifiedDiffChange.this.myViewer.applyChange(UnifiedDiffChange.this, sourceSide);
                            }
                        });
                        UnifiedDiffChange.this.myViewer.rediff();
                    }
                };
            }

            public boolean equals(Object obj) {
                return obj == this;
            }

            public int hashCode() {
                return System.identityHashCode((Object)this);
            }

            @Nullable
            public String getTooltipText() {
                return tooltipText;
            }

            public boolean isDumbAware() {
                return true;
            }
        };
    }

    private class MyGutterOperation {
        @NotNull
        private final Side mySide;
        @NotNull
        private final RangeHighlighter myHighlighter;

        private MyGutterOperation(@NotNull Side sourceSide, RangeHighlighter highlighter) {
            if (sourceSide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSide", "com/intellij/diff/tools/fragmented/UnifiedDiffChange$MyGutterOperation", "<init>"));
            }
            if (highlighter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/diff/tools/fragmented/UnifiedDiffChange$MyGutterOperation", "<init>"));
            }
            this.mySide = sourceSide;
            this.myHighlighter = highlighter;
            this.update();
        }

        public void dispose() {
            this.myHighlighter.dispose();
        }

        public void update() {
            if (this.myHighlighter.isValid()) {
                this.myHighlighter.setGutterIconRenderer(this.createRenderer());
            }
        }

        @Nullable
        public GutterIconRenderer createRenderer() {
            if (UnifiedDiffChange.this.myViewer.isStateIsOutOfDate()) {
                return null;
            }
            if (!UnifiedDiffChange.this.myViewer.isEditable(this.mySide.other(), true)) {
                return null;
            }
            boolean bothEditable = UnifiedDiffChange.this.myViewer.isEditable(this.mySide, true);
            if (bothEditable) {
                if (this.mySide.isLeft()) {
                    return UnifiedDiffChange.this.createIconRenderer(this.mySide, "Apply Before", AllIcons.Diff.ArrowRight);
                }
                return UnifiedDiffChange.this.createIconRenderer(this.mySide, "Apply After", AllIcons.Diff.Arrow);
            }
            if (this.mySide.isLeft()) {
                return UnifiedDiffChange.this.createIconRenderer(this.mySide, "Revert", AllIcons.Diff.Remove);
            }
            return UnifiedDiffChange.this.createIconRenderer(this.mySide, "Apply", AllIcons.Diff.Arrow);
        }
    }
}

