/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.NavigationContextChecker;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.OnesideTextDiffViewer;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffNavigationContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleOnesideDiffViewer
extends OnesideTextDiffViewer {
    public static final Logger LOG = Logger.getInstance(SimpleOnesideDiffViewer.class);
    @NotNull
    private final MyInitialScrollHelper myInitialScrollHelper;
    @NotNull
    private final List<RangeHighlighter> myHighlighters;

    public SimpleOnesideDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/simple/SimpleOnesideDiffViewer", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/simple/SimpleOnesideDiffViewer", "<init>"));
        }
        super(context, (ContentDiffRequest)request);
        this.myInitialScrollHelper = new MyInitialScrollHelper();
        this.myHighlighters = new ArrayList<RangeHighlighter>();
    }

    @Override
    protected void onDispose() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
        super.onDispose();
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)new MyIgnorePolicySettingAction());
        group.add((AnAction)new MyHighlightPolicySettingAction());
        group.add((AnAction)new MyReadOnlyLockAction());
        group.add((AnAction)this.myEditorSettingsAction);
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleOnesideDiffViewer", "createToolbarActions"));
        }
        return arrayList;
    }

    @Override
    @Nullable
    protected List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new MyIgnorePolicySettingAction().getPopupGroup());
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new MyHighlightPolicySettingAction().getPopupGroup());
        return group;
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        this.myInitialScrollHelper.processContext((DiffRequest)this.myRequest);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myInitialScrollHelper.updateContext((DiffRequest)this.myRequest);
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/simple/SimpleOnesideDiffViewer", "performRediff"));
        }
        indicator.checkCanceled();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                boolean shouldHighlight;
                SimpleOnesideDiffViewer.this.clearDiffPresentation();
                boolean bl = shouldHighlight = SimpleOnesideDiffViewer.this.getTextSettings().getHighlightPolicy() != HighlightPolicy.DO_NOT_HIGHLIGHT;
                if (shouldHighlight) {
                    DocumentContent content = SimpleOnesideDiffViewer.this.getContent();
                    Document document = content.getDocument();
                    int start = 0;
                    int end = document.getTextLength();
                    TextDiffType type = (TextDiffType)SimpleOnesideDiffViewer.this.getSide().select((Object)TextDiffType.DELETED, (Object)TextDiffType.INSERTED);
                    SimpleOnesideDiffViewer.this.myHighlighters.addAll(DiffDrawUtil.createHighlighter(SimpleOnesideDiffViewer.this.getEditor(), start, end, type, false));
                    int startLine = 0;
                    int endLine = DiffUtil.getLineCount(document);
                    if (startLine != endLine) {
                        SimpleOnesideDiffViewer.this.myHighlighters.addAll(DiffDrawUtil.createLineMarker(SimpleOnesideDiffViewer.this.getEditor(), startLine, type, SeparatorPlacement.TOP));
                        SimpleOnesideDiffViewer.this.myHighlighters.addAll(DiffDrawUtil.createLineMarker(SimpleOnesideDiffViewer.this.getEditor(), endLine - 1, type, SeparatorPlacement.BOTTOM));
                    }
                }
                SimpleOnesideDiffViewer.this.myInitialScrollHelper.onRediff();
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleOnesideDiffViewer", "performRediff"));
        }
        return runnable;
    }

    private void clearDiffPresentation() {
        this.myPanel.resetNotifications();
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
    }

    private void doScrollToChange(boolean animated) {
        DiffUtil.moveCaret(this.getEditor(), 0);
        DiffUtil.scrollEditor(this.getEditor(), 0, animated);
    }

    protected boolean doScrollToContext(@NotNull DiffNavigationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/simple/SimpleOnesideDiffViewer", "doScrollToContext"));
        }
        if (this.getSide().isLeft()) {
            return false;
        }
        AllLinesIterator allLinesIterator = new AllLinesIterator();
        NavigationContextChecker checker2 = new NavigationContextChecker(allLinesIterator, context);
        int line = checker2.contextMatchCheck();
        if (line == -1) {
            return false;
        }
        this.scrollToLine(line);
        return true;
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/simple/SimpleOnesideDiffViewer", "canShowRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/simple/SimpleOnesideDiffViewer", "canShowRequest"));
        }
        return OnesideTextDiffViewer.canShowRequest(context, request);
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        if (DiffDataKeys.CURRENT_CHANGE_RANGE.is(dataId)) {
            int lineCount = DiffUtil.getLineCount(this.getEditor().getDocument());
            return new LineRange(0, lineCount);
        }
        return super.getData(dataId);
    }

    private class MyInitialScrollHelper
    extends OnesideTextDiffViewer.MyInitialScrollPositionHelper {
        private MyInitialScrollHelper() {
            super(SimpleOnesideDiffViewer.this);
        }

        @Override
        protected boolean doScrollToChange() {
            if (this.myScrollToChange == null) {
                return false;
            }
            SimpleOnesideDiffViewer.this.doScrollToChange(false);
            return true;
        }

        @Override
        protected boolean doScrollToFirstChange() {
            SimpleOnesideDiffViewer.this.doScrollToChange(false);
            return true;
        }

        @Override
        protected boolean doScrollToContext() {
            if (this.myNavigationContext == null) {
                return false;
            }
            return SimpleOnesideDiffViewer.this.doScrollToContext(this.myNavigationContext);
        }

        @Override
        protected boolean doScrollToPosition() {
            if (this.myCaretPosition == null) {
                return false;
            }
            LogicalPosition position = (LogicalPosition)SimpleOnesideDiffViewer.this.getSide().select((Object[])this.myCaretPosition);
            SimpleOnesideDiffViewer.this.getEditor().getCaretModel().moveToLogicalPosition(position);
            if (this.myEditorsPosition != null && this.myEditorsPosition.isSame(position)) {
                DiffUtil.scrollToPoint(SimpleOnesideDiffViewer.this.getEditor(), this.myEditorsPosition.myPoints[0], false);
            } else {
                DiffUtil.scrollToCaret(SimpleOnesideDiffViewer.this.getEditor(), false);
            }
            return true;
        }

        @Override
        @Nullable
        protected LogicalPosition[] getCaretPositions() {
            int index = SimpleOnesideDiffViewer.this.getSide().getIndex();
            int otherIndex = SimpleOnesideDiffViewer.this.getSide().other().getIndex();
            LogicalPosition[] carets = new LogicalPosition[2];
            carets[index] = SimpleOnesideDiffViewer.this.getEditor().getCaretModel().getLogicalPosition();
            carets[otherIndex] = new LogicalPosition(0, 0);
            return carets;
        }
    }

    private class AllLinesIterator
    implements Iterator<Pair<Integer, CharSequence>> {
        @NotNull
        private final Document myDocument;
        private int myLine = 0;

        private AllLinesIterator() {
            this.myDocument = SimpleOnesideDiffViewer.this.getEditor().getDocument();
        }

        @Override
        public boolean hasNext() {
            return this.myLine < DiffUtil.getLineCount(this.myDocument);
        }

        @Override
        public Pair<Integer, CharSequence> next() {
            int offset1 = this.myDocument.getLineStartOffset(this.myLine);
            int offset2 = this.myDocument.getLineEndOffset(this.myLine);
            CharSequence text = this.myDocument.getImmutableCharSequence().subSequence(offset1, offset2);
            Pair pair = new Pair((Object)this.myLine, (Object)text);
            ++this.myLine;
            return pair;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class MyIgnorePolicySettingAction
    extends TextDiffViewerUtil.IgnorePolicySettingAction {
        public MyIgnorePolicySettingAction() {
            super(SimpleOnesideDiffViewer.this.getTextSettings());
        }

        @Override
        protected void onSettingsChanged() {
            SimpleOnesideDiffViewer.this.rediff();
        }
    }

    private class MyHighlightPolicySettingAction
    extends TextDiffViewerUtil.HighlightPolicySettingAction {
        public MyHighlightPolicySettingAction() {
            super(SimpleOnesideDiffViewer.this.getTextSettings());
        }

        @Override
        protected void onSettingsChanged() {
            SimpleOnesideDiffViewer.this.rediff();
        }
    }

    private class MyReadOnlyLockAction
    extends TextDiffViewerUtil.EditorReadOnlyLockAction {
        public MyReadOnlyLockAction() {
            super(SimpleOnesideDiffViewer.this.getContext(), SimpleOnesideDiffViewer.this.getEditableEditors());
        }
    }
}

