/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.AnimatedIcon;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class StatusPanel
extends JPanel {
    private final JLabel myTextLabel = new JLabel("");
    private final AnimatedIcon myBusySpinner;

    public StatusPanel() {
        super(new BorderLayout());
        this.myTextLabel.setVisible(false);
        this.myBusySpinner = new AsyncProcessIcon("StatusPanelSpinner");
        this.myBusySpinner.setVisible(false);
        this.add((Component)this.myTextLabel, "Center");
        this.add((Component)this.myBusySpinner, "West");
        this.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)4, (int)0, (int)4));
    }

    public void update() {
        String message = this.getMessage();
        this.myTextLabel.setVisible(message != null);
        this.myTextLabel.setText(StringUtil.notNullize((String)message));
    }

    public void setBusy(boolean busy) {
        if (busy) {
            this.myBusySpinner.setVisible(true);
            this.myBusySpinner.resume();
        } else {
            this.myBusySpinner.setVisible(false);
            this.myBusySpinner.suspend();
        }
    }

    @Nullable
    protected String getMessage() {
        int count = this.getChangesCount();
        if (count == -1) {
            return null;
        }
        return DiffBundle.message((String)"diff.count.differences.status.text", (Object[])new Object[]{count});
    }

    protected int getChangesCount() {
        return -1;
    }
}

