/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.ToggleActionButton;
import com.intellij.util.EditorPopupHandler;
import com.intellij.util.containers.ContainerUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TextDiffViewerUtil {
    public static final Logger LOG = Logger.getInstance(TextDiffViewerUtil.class);
    public static final Key<Boolean> READ_ONLY_LOCK_KEY = Key.create((String)"ReadOnlyLockAction");

    @NotNull
    public static List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        result.add(ActionManager.getInstance().getAction("CompareClipboardWithSelection"));
        result.add((AnAction)Separator.getInstance());
        ContainerUtil.addAll(result, (Object[])((ActionGroup)ActionManager.getInstance().getAction("Diff.EditorPopupMenu")).getChildren(null));
        ArrayList<AnAction> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "createEditorPopupActions"));
        }
        return arrayList;
    }

    @NotNull
    public static FoldingModelSupport.Settings getFoldingModelSettings(@NotNull DiffContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "getFoldingModelSettings"));
        }
        TextDiffSettingsHolder.TextDiffSettings settings = TextDiffViewerUtil.getTextSettings(context);
        FoldingModelSupport.Settings settings2 = new FoldingModelSupport.Settings(settings.getContextRange(), settings.isExpandByDefault());
        if (settings2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "getFoldingModelSettings"));
        }
        return settings2;
    }

    @NotNull
    public static TextDiffSettingsHolder.TextDiffSettings getTextSettings(@NotNull DiffContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "getTextSettings"));
        }
        TextDiffSettingsHolder.TextDiffSettings settings = (TextDiffSettingsHolder.TextDiffSettings)context.getUserData(TextDiffSettingsHolder.KEY);
        if (settings == null) {
            settings = TextDiffSettingsHolder.TextDiffSettings.getSettings((String)context.getUserData(DiffUserDataKeysEx.PLACE));
            context.putUserData(TextDiffSettingsHolder.KEY, (Object)settings);
            if (DiffUtil.isUserDataFlagSet((Key<Boolean>)DiffUserDataKeys.DO_NOT_IGNORE_WHITESPACES, new UserDataHolder[]{context})) {
                settings.setIgnorePolicy(IgnorePolicy.DEFAULT);
            }
        }
        TextDiffSettingsHolder.TextDiffSettings textDiffSettings = settings;
        if (textDiffSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "getTextSettings"));
        }
        return textDiffSettings;
    }

    @NotNull
    public static boolean[] checkForceReadOnly(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "checkForceReadOnly"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "checkForceReadOnly"));
        }
        int contentCount = request.getContents().size();
        boolean[] result = new boolean[contentCount];
        if (DiffUtil.isUserDataFlagSet((Key<Boolean>)DiffUserDataKeys.FORCE_READ_ONLY, new UserDataHolder[]{request, context})) {
            Arrays.fill(result, true);
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "checkForceReadOnly"));
            }
            return result;
        }
        boolean[] data = (boolean[])request.getUserData(DiffUserDataKeys.FORCE_READ_ONLY_CONTENTS);
        if (data != null && data.length == contentCount) {
            if (data == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "checkForceReadOnly"));
            }
            return data;
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "checkForceReadOnly"));
        }
        return result;
    }

    public static void checkDifferentDocuments(@NotNull ContentDiffRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "checkDifferentDocuments"));
        }
        List contents = request.getContents();
        boolean sameDocuments = false;
        for (int i = 0; i < contents.size(); ++i) {
            for (int j = i + 1; j < contents.size(); ++j) {
                DiffContent content1 = (DiffContent)contents.get(i);
                DiffContent content2 = (DiffContent)contents.get(j);
                if (!(content1 instanceof DocumentContent) || !(content2 instanceof DocumentContent)) continue;
                sameDocuments |= ((DocumentContent)content1).getDocument() == ((DocumentContent)content2).getDocument();
            }
        }
        if (sameDocuments) {
            StringBuilder message = new StringBuilder();
            message.append("DiffRequest with same documents detected\n");
            message.append(request.toString()).append("\n");
            for (DiffContent content : contents) {
                message.append(content.toString()).append("\n");
            }
            LOG.warn(new Throwable(message.toString()));
        }
    }

    @NotNull
    public static List<? extends EditorEx> getEditableEditors(@NotNull List<? extends EditorEx> editors) {
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "getEditableEditors"));
        }
        List list = ContainerUtil.filter(editors, (Condition)new Condition<EditorEx>(){

            public boolean value(EditorEx editor) {
                return editor != null && !editor.isViewer();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil", "getEditableEditors"));
        }
        return list;
    }

    public static class EditorActionsPopup
    extends EditorPopupHandler {
        @NotNull
        private final List<? extends AnAction> myEditorPopupActions;

        public EditorActionsPopup(@NotNull List<? extends AnAction> editorPopupActions) {
            if (editorPopupActions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorPopupActions", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EditorActionsPopup", "<init>"));
            }
            this.myEditorPopupActions = editorPopupActions;
        }

        public void install(@NotNull List<? extends Editor> editors) {
            if (editors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EditorActionsPopup", "install"));
            }
            for (Editor editor : editors) {
                if (editor == null) continue;
                editor.addEditorMouseListener((EditorMouseListener)this);
            }
        }

        @Override
        public void invokePopup(EditorMouseEvent event) {
            if (this.myEditorPopupActions.isEmpty()) {
                return;
            }
            DefaultActionGroup group = new DefaultActionGroup(this.myEditorPopupActions);
            EditorPopupHandler handler = EditorActionUtil.createEditorPopupHandler((ActionGroup)group);
            handler.invokePopup(event);
        }
    }

    public static class EditorFontSizeSynchronizer
    implements PropertyChangeListener {
        @NotNull
        private final List<? extends EditorEx> myEditors;
        private boolean myDuringUpdate;

        public EditorFontSizeSynchronizer(@NotNull List<? extends EditorEx> editors) {
            if (editors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EditorFontSizeSynchronizer", "<init>"));
            }
            this.myDuringUpdate = false;
            this.myEditors = editors;
        }

        public void install(@NotNull Disposable disposable) {
            if (disposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EditorFontSizeSynchronizer", "install"));
            }
            if (ContainerUtil.skipNulls(this.myEditors).size() < 2) {
                return;
            }
            for (EditorEx editorEx : this.myEditors) {
                if (editorEx == null) continue;
                editorEx.addPropertyChangeListener(this, disposable);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.myDuringUpdate) {
                return;
            }
            if (!"fontSize".equals(evt.getPropertyName())) {
                return;
            }
            if (evt.getOldValue().equals(evt.getNewValue())) {
                return;
            }
            int fontSize = (Integer)evt.getNewValue();
            for (EditorEx editorEx : this.myEditors) {
                if (editorEx == null || evt.getSource() == editorEx) continue;
                this.updateEditor(editorEx, fontSize);
            }
        }

        public void updateEditor(@NotNull EditorEx editor, int fontSize) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EditorFontSizeSynchronizer", "updateEditor"));
            }
            try {
                this.myDuringUpdate = true;
                editor.setFontSize(fontSize);
            }
            finally {
                this.myDuringUpdate = false;
            }
        }
    }

    public static class EditorReadOnlyLockAction
    extends ReadOnlyLockAction {
        private final List<? extends EditorEx> myEditableEditors;

        public EditorReadOnlyLockAction(@NotNull DiffContext context, @NotNull List<? extends EditorEx> editableEditors) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EditorReadOnlyLockAction", "<init>"));
            }
            if (editableEditors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editableEditors", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EditorReadOnlyLockAction", "<init>"));
            }
            super(context);
            this.myEditableEditors = editableEditors;
            this.init();
        }

        @Override
        protected void doApply(boolean readOnly) {
            for (EditorEx editorEx : this.myEditableEditors) {
                editorEx.setViewer(readOnly);
            }
        }

        @Override
        protected boolean canEdit() {
            return !this.myEditableEditors.isEmpty();
        }
    }

    public static abstract class ReadOnlyLockAction
    extends ToggleAction
    implements DumbAware {
        @NotNull
        protected final DiffContext myContext;

        public ReadOnlyLockAction(@NotNull DiffContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ReadOnlyLockAction", "<init>"));
            }
            super("Disable editing", null, AllIcons.Nodes.Padlock);
            this.myContext = context;
            this.setEnabledInModalContext(true);
        }

        protected void init() {
            if (this.isVisible()) {
                this.setSelected(null, this.isSelected(null));
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ReadOnlyLockAction", "update"));
            }
            if (!this.isVisible()) {
                e.getPresentation().setEnabledAndVisible(false);
            } else {
                super.update(e);
            }
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myContext.getUserData(READ_ONLY_LOCK_KEY) != Boolean.FALSE;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.myContext.putUserData(READ_ONLY_LOCK_KEY, (Object)state);
            this.doApply(state);
        }

        private boolean isVisible() {
            return this.myContext.getUserData(DiffUserDataKeysEx.SHOW_READ_ONLY_LOCK) == Boolean.TRUE && this.canEdit();
        }

        protected abstract void doApply(boolean var1);

        protected abstract boolean canEdit();
    }

    public static abstract class ToggleExpandByDefaultAction
    extends ToggleActionButton
    implements DumbAware {
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public ToggleExpandByDefaultAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ToggleExpandByDefaultAction", "<init>"));
            }
            super("Collapse unchanged fragments", AllIcons.Actions.Collapseall);
            this.mySettings = settings;
            this.setEnabledInModalContext(true);
        }

        public boolean isVisible() {
            return this.mySettings.getContextRange() != -1;
        }

        public boolean isSelected(AnActionEvent e) {
            return !this.mySettings.isExpandByDefault();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            boolean expand;
            boolean bl = expand = !state;
            if (this.mySettings.isExpandByDefault() == expand) {
                return;
            }
            this.mySettings.setExpandByDefault(expand);
            this.expandAll(expand);
        }

        protected abstract void expandAll(boolean var1);
    }

    public static class ToggleAutoScrollAction
    extends ToggleActionButton
    implements DumbAware {
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public ToggleAutoScrollAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ToggleAutoScrollAction", "<init>"));
            }
            super("Synchronize Scrolling", AllIcons.Actions.SynchronizeScrolling);
            this.mySettings = settings;
            this.setEnabledInModalContext(true);
        }

        public boolean isSelected(AnActionEvent e) {
            return this.mySettings.isEnableSyncScroll();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.mySettings.setEnableSyncScroll(state);
        }
    }

    public static abstract class IgnorePolicySettingAction
    extends ComboBoxSettingAction<IgnorePolicy> {
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public IgnorePolicySettingAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$IgnorePolicySettingAction", "<init>"));
            }
            this.mySettings = settings;
        }

        @Override
        protected void applySetting(@NotNull IgnorePolicy setting, @NotNull AnActionEvent e) {
            if (setting == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setting", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$IgnorePolicySettingAction", "applySetting"));
            }
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$IgnorePolicySettingAction", "applySetting"));
            }
            if (this.getCurrentSetting() == setting) {
                return;
            }
            this.mySettings.setIgnorePolicy(setting);
            this.update(e);
            this.onSettingsChanged();
        }

        @Override
        @NotNull
        protected IgnorePolicy getCurrentSetting() {
            IgnorePolicy ignorePolicy = this.mySettings.getIgnorePolicy();
            if (ignorePolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$IgnorePolicySettingAction", "getCurrentSetting"));
            }
            return ignorePolicy;
        }

        @Override
        @NotNull
        protected String getText(@NotNull IgnorePolicy setting) {
            if (setting == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setting", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$IgnorePolicySettingAction", "getText"));
            }
            String string = setting.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$IgnorePolicySettingAction", "getText"));
            }
            return string;
        }

        @Override
        @NotNull
        protected List<IgnorePolicy> getAvailableSettings() {
            List<IgnorePolicy> list = Arrays.asList(IgnorePolicy.values());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$IgnorePolicySettingAction", "getAvailableSettings"));
            }
            return list;
        }

        protected abstract void onSettingsChanged();
    }

    public static abstract class HighlightPolicySettingAction
    extends ComboBoxSettingAction<HighlightPolicy> {
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public HighlightPolicySettingAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$HighlightPolicySettingAction", "<init>"));
            }
            this.mySettings = settings;
        }

        @Override
        protected void applySetting(@NotNull HighlightPolicy setting, @NotNull AnActionEvent e) {
            if (setting == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setting", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$HighlightPolicySettingAction", "applySetting"));
            }
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$HighlightPolicySettingAction", "applySetting"));
            }
            if (this.getCurrentSetting() == setting) {
                return;
            }
            this.mySettings.setHighlightPolicy(setting);
            this.update(e);
            this.onSettingsChanged();
        }

        @Override
        @NotNull
        protected HighlightPolicy getCurrentSetting() {
            HighlightPolicy highlightPolicy = this.mySettings.getHighlightPolicy();
            if (highlightPolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$HighlightPolicySettingAction", "getCurrentSetting"));
            }
            return highlightPolicy;
        }

        @Override
        @NotNull
        protected String getText(@NotNull HighlightPolicy setting) {
            if (setting == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setting", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$HighlightPolicySettingAction", "getText"));
            }
            String string = setting.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$HighlightPolicySettingAction", "getText"));
            }
            return string;
        }

        @Override
        @NotNull
        protected List<HighlightPolicy> getAvailableSettings() {
            List<HighlightPolicy> list = Arrays.asList(HighlightPolicy.values());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$HighlightPolicySettingAction", "getAvailableSettings"));
            }
            return list;
        }

        protected abstract void onSettingsChanged();
    }

    public static abstract class ComboBoxSettingAction<T>
    extends ComboBoxAction
    implements DumbAware {
        private DefaultActionGroup myChildren;

        public ComboBoxSettingAction() {
            this.setEnabledInModalContext(true);
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setText(this.getText(this.getCurrentSetting()));
        }

        @NotNull
        public DefaultActionGroup getPopupGroup() {
            this.initChildren();
            DefaultActionGroup defaultActionGroup = this.myChildren;
            if (defaultActionGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ComboBoxSettingAction", "getPopupGroup"));
            }
            return defaultActionGroup;
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button) {
            this.initChildren();
            DefaultActionGroup defaultActionGroup = this.myChildren;
            if (defaultActionGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ComboBoxSettingAction", "createPopupActionGroup"));
            }
            return defaultActionGroup;
        }

        private void initChildren() {
            if (this.myChildren == null) {
                this.myChildren = new DefaultActionGroup();
                for (T setting : this.getAvailableSettings()) {
                    this.myChildren.add((AnAction)new MyAction(setting));
                }
            }
        }

        @NotNull
        protected abstract List<T> getAvailableSettings();

        @NotNull
        protected abstract String getText(@NotNull T var1);

        @NotNull
        protected abstract T getCurrentSetting();

        protected abstract void applySetting(@NotNull T var1, @NotNull AnActionEvent var2);

        private class MyAction
        extends AnAction
        implements DumbAware {
            @NotNull
            private final T mySetting;

            public MyAction(T setting) {
                if (setting == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setting", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ComboBoxSettingAction$MyAction", "<init>"));
                }
                super(ComboBoxSettingAction.this.getText(setting));
                this.setEnabledInModalContext(true);
                this.mySetting = setting;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ComboBoxSettingAction$MyAction", "actionPerformed"));
                }
                ComboBoxSettingAction.this.applySetting(this.mySetting, e);
            }
        }
    }
}

